/*
Copyright (C) 2010 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
*/

package com.clustercontrol.nodemap.ejb.entity;

import java.lang.String;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 *
 * <!-- begin-user-doc --> マップ描画対象ノード（スコープ）の関係情報を保持するEntityBean '<em><b>AssociationBean</b></em>'. <!-- end-user-doc --> *
 *
 * <!-- begin-xdoclet-definition -->
 * @ejb.bean name="Association"
 *	jndi-name="Association"
 *	type="CMP" 
 *  schema="Association" 
 *  cmp-version="2.x"
 *  data-source="java:/HinemosDS"
 *  primkey-field="mapId","associationId"
 * 
 * @jboss.depends name="jboss.jca:service=DataSourceBinding,name=HinemosDS"
 * 
 * @ejb.persistence 
 *   table-name="cc_map_association" 
 * 
 * @ejb.permission
 *     unchecked="true"
 *     
 * @ejb.finder 
 *    query="SELECT OBJECT(a) FROM Association as a"  
 *    signature="java.util.Collection findAll()"  
 *    
 * @ejb.finder 
 *    query="SELECT OBJECT(a) FROM Association as a WHERE a.mapId = ?1"  
 *    signature="java.util.Collection findByMapId(java.lang.String mapId)"  
 *    
 * @ejb.pk class="com.clustercontrol.nodemap.ejb.entity.AssociationPK"
 * <!-- end-xdoclet-definition -->
 * @generated
 **/
public abstract class AssociationBean implements javax.ejb.EntityBean {
	protected static Log m_log = LogFactory.getLog( AssociationBean.class );
	
	/**
	 * <!-- begin-user-doc -->
	 * The  ejbCreate method.
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.create-method 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public AssociationPK ejbCreate(
			String map_id,
			String source,
			String target
	) throws javax.ejb.CreateException {
		setMapId(map_id);
		setSource(source);
		setTarget(target);
		return null;
	}
	
	
	/**
	 * <!-- begin-user-doc -->
	 * The container invokes this method immediately after it calls ejbCreate.
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void ejbPostCreate() throws javax.ejb.CreateException {
		// begin-user-code
		// end-user-code
	}
		
	/**
	 * <!-- begin-user-doc -->
	 * CMP Field map_id
	 *
	 * Returns the map_id
	 * @return the map_id
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 *
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="map_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR"
	 *     read-only="false"
	 * 
	 * @ejb.pk-field 
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public abstract java.lang.String getMapId();
	
	/**
	 * <!-- begin-user-doc -->
	 * Sets the map_id
	 * 
	 * @param java.lang.String the new map_id value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated 
	 */
	public abstract void setMapId(java.lang.String map_id);
	
	/**
	 * <!-- begin-user-doc -->
	 * CMP Field source
	 *
	 * Returns the source
	 * @return the source
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 *
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="source"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR"
	 *     read-only="false"
	 *
	 * @ejb.pk-field 
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public abstract java.lang.String getSource();
	
	/**
	 * <!-- begin-user-doc -->
	 * Sets the source
	 * 
	 * @param java.lang.String the new source value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated 
	 */
	public abstract void setSource(java.lang.String source);
	
	/**
	 * <!-- begin-user-doc -->
	 * CMP Field target
	 *
	 * Returns the target
	 * @return the target
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 *
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="target"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR"
	 *     read-only="false"
	 *
	 * @ejb.pk-field 
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public abstract java.lang.String getTarget();
	
	/**
	 * <!-- begin-user-doc -->
	 * Sets the target
	 * 
	 * @param java.lang.String the new target value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated 
	 */
	public abstract void setTarget(java.lang.String target);
}
