/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.maintenance.factory;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;

import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.commons.util.ConnectionManager;

/**
 * 仮想化操作の削除処理
 * @author Hinemos
 *
 */
public class MaintenanceVM extends MaintenanceObject{

	protected static Log m_log = LogFactory.getLog( MaintenanceVM.class );

	/**
	 * VM情報のオブジェクト名。<BR>
	 * キャッシュをフラッシュするオブジェクト名を指定します。
	 */
	public static final String[] OBJECT_NAME_VM = 
		{"jboss.j2ee:jndiName=VmOperationDetailLocal,service=EJB"};

	/**
	 * コンストラクタ
	 */
	public MaintenanceVM() {
		super(OBJECT_NAME_VM);
	}
	
	/**
	 * 削除処理
	 */
	@Override
	public int _delete(Timestamp keep, boolean status) throws FinderException,
			NamingException, CreateException, SQLException, RemoveException {
		m_log.debug("_delete() start : keep = " + keep.toString() + ", status = " + status);

		int ret = -1;
		Connection conn = null;
		Statement stmt = null;
		boolean autoCommit = false;
		
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();
			autoCommit = conn.getAutoCommit();
			conn.setAutoCommit(false);
			
			//SQL文のセット
			stmt = conn.createStatement();
			
			//SQL文の定義
			StringBuffer sql = new StringBuffer();
			sql.append("DELETE FROM cc_vm_operation_detail WHERE start_date < '" + keep.toString() + "'");
			if(!status){
				//status=falseの場合は実行状態が「終了」の履歴を削除する
				sql.append(" AND (status = 2 OR status = 3)");
			}
			
			//SQL文の実行
			m_log.debug("_delete() execute : " + sql.toString());
			ret = stmt.executeUpdate(sql.toString());
			
			///////////////////////////////////////////////
			// COMMIT
			///////////////////////////////////////////////
			conn.commit();

			//終了
			m_log.debug("_delete() count : " + ret);
			return ret;
			
		} catch (SQLException e) {
			m_log.error("_delete() : keep = " + keep.toString() + ", status = " + status, e);
			throw e;

		} finally {
			try {
				if(stmt != null){
					stmt.close();
				}
				if(conn != null){
					conn.setAutoCommit(autoCommit);
					conn.close();
				}
			} catch (SQLException e) {
				m_log.error("_delete() : keep = " + keep.toString() + ", status = " + status, e);
			}
		}
	}
}
