/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.ejb.entity;

import java.util.Collection;
import java.util.Date;

import javax.ejb.FinderException;
import javax.naming.NamingException;

import com.clustercontrol.JobInfoNotFoundException;
import com.clustercontrol.jobmanagement.dao.JobSessionNodeDAOImpl;


/**
 * セッションノードのBMP Entity Bean クラス<BR>
 * 
 * @ejb.bean name="JobSessionNode"
 *    jndi-name="JobSessionNode"
 *    type="BMP"
 *    view-type="local"
 * 
 * @jboss.container-configuration
 *    name="Hinemos Log BMP EntityBean"
 * 
 * @jboss.depends
 *    name="jboss.jca:service=DataSourceBinding,name=HinemosDS"
 * 
 * @ejb.dao
 *    class="com.clustercontrol.jobmanagement.dao.JobSessionNodeDAO"
 *    impl-class="com.clustercontrol.jobmanagement.dao.JobSessionNodeDAOImpl"
 * 
 * @ejb.permission
 *    unchecked="true"
 * 
 * @jboss.method-attributes
 *    pattern="get*"
 *    read-only="true"
 * 
 * @see com.clustercontrol.jobmanagement.dao.JobSessionNodeDAO
 * @see com.clustercontrol.jobmanagement.dao.JobSessionNodeDAOImpl
 */
public abstract class JobSessionNodeBean implements javax.ejb.EntityBean {
	/** セッションID */
    protected String session_id;
	/** 所属ジョブユニットのジョブID */
	protected String jobunit_id;
	/** ジョブID */
    protected String job_id;
    /** ファシリティID */
    protected String facility_id;
    /** ファシリティ名 */
    protected String node_name;
    /** 実行状態 */
    protected Integer status;
    /** 開始・再開日時 */
    protected Date start_date;
    /** 終了・中断日時 */
    protected Date end_date;
    /** 戻り値 */
    protected Integer end_value;
    /** メッセージ */
    protected String message;
    /** エージェントチェック */
    protected Integer agent_check;
    /** エージェントチェック日時 */
    protected Date check_date;
    /** リトライ回数 */
    protected Integer retry_count;
    /** 結果 */
    protected String result;
    /** 実行状態バッファ */
    protected Integer status_buffer;
    
    /**
     * セッションノードを生成します。
     * 
     * @ejb.create-method 
     * 
     * @param session_id セッションID
     * @param jobunit_id 所属ジョブユニットのジョブID
     * @param job_id ジョブID
     * @param facility_id ファシリティID
     * @param node_name ファシリティ名
     * @param status 実行状態
     * @param start_date 開始・再開日時
     * @param end_date 終了・中断日時
     * @param end_value 戻り値
     * @param message メッセージ
     * @param agent_check エージェントチェック
     * @param check_date エージェントチェック日時
     * @param retry_count リトライ回数
     * @param result 結果
     * @param status_buffer 実行状態バッファ
     * @return プライマリーキー
     * @throws javax.ejb.CreateException
     * 
     * @see com.clustercontrol.bean.StatusConstant
     * @see com.clustercontrol.jobmanagement.bean.AgentCheckConstant
     */
    public JobSessionNodePK ejbCreate(
            String session_id, 
            String jobunit_id, 
            String job_id, 
            String facility_id, 
            String node_name, 
            Integer status, 
            Date start_date, 
            Date end_date, 
            Integer end_value, 
            String message, 
            Integer agent_check, 
            Date check_date, 
            Integer retry_count, 
            String result, 
            Integer status_buffer
    ) throws javax.ejb.CreateException {
        this.session_id = session_id;
        this.jobunit_id = jobunit_id;
        this.job_id = job_id;
        this.facility_id = facility_id;
        this.node_name = node_name;
        this.status = status;
        this.start_date = start_date;
        this.end_date = end_date;
        this.end_value = end_value;
        this.message = message;
        this.agent_check = agent_check;
        this.check_date = check_date;
        this.retry_count = retry_count;
        this.result = result;
        this.status_buffer = status_buffer;
        return null;
    }
    
	/**
	 * 全てのセッションノードを検索します。
	 * 
	 * @return プライマリキーのコレクション
	 * @throws FinderException
	 * 
	 * @see com.clustercontrol.jobmanagement.dao.JobSessionNodeDAOImpl#findAll()
	 */
	public Collection ejbFindAll() throws FinderException {
		return null;
	}
	
	/**
	 * プライマリキーに一致するセッションノードを検索します。
	 * 
	 * @param pk プライマリキー
	 * @return プライマリキー
	 * @throws FinderException
	 * 
	 * @see com.clustercontrol.jobmanagement.dao.JobSessionNodeDAOImpl#findByPrimaryKey(JobSessionNodePK)
	 */
	public JobSessionNodePK ejbFindByPrimaryKey(JobSessionNodePK pk) throws FinderException {
		return null;
	}
	
	/**
	 * セッションIDとジョブIDに一致するセッションノードを検索します。
	 * 
	 * @param sessionId セッションID
	 * @param jobId ジョブID
	 * @return プライマリキーのコレクション
	 * @throws FinderException
	 * 
	 * @see com.clustercontrol.jobmanagement.dao.JobSessionNodeDAOImpl#findBySessionIdAndJobId(String, String)
	 */
	public Collection ejbFindBySessionIdAndJobId(java.lang.String sessionId, java.lang.String jobId) throws FinderException {
		return null;
	}
    
	/**
	 * ファシリティIDに一致するセッションノードを検索します。
	 * 
	 * @param facilityId ファシリティID
	 * @return プライマリキーのコレクション
	 * @throws FinderException
	 * 
	 * @see com.clustercontrol.jobmanagement.dao.JobSessionNodeDAOImpl#findByFacilityId(String)
	 */
	public Collection ejbFindByFacilityId(java.lang.String facilityId) throws FinderException {
		return null;
	}
	
	/**
	 * 実行状態に一致するセッションノードを検索します。
	 * 
	 * @param status 実行状態
	 * @return プライマリキーのコレクション
	 * @throws FinderException
	 * 
	 * @see com.clustercontrol.bean.StatusConstant
	 * @see com.clustercontrol.jobmanagement.dao.JobSessionNodeDAOImpl#findByStatus(Integer)
	 */
	public Collection ejbFindByStatus(java.lang.Integer status) throws FinderException {
		return null;
	}
	
	/**
	 * セッションIDを返す。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.pk-field 
	 * @ejb.interface-method
	 * 
	 * @return セッションID
	 */
    public java.lang.String getSession_id() {
    	return session_id;
    }
    
	/**
	 * セッションIDを設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param session_id セッションID
	 */
    public void setSession_id(java.lang.String session_id) {
    	this.session_id = session_id;
    }
	
	/**
	 * 所属ジョブユニットのジョブIDを返す。<BR>
	 * 
	 * @ejb.persistent-field 
	 * @ejb.pk-field 
	 * @ejb.interface-method
	 * 
	 * @return 所属ジョブユニットのジョブID
	 */
	public java.lang.String getJobunit_id() {
		return jobunit_id;
	}
	
	/**
	 * 所属ジョブユニットのジョブIDを設定する。<BR>
	 * 
	 * @ejb.interface-method
	 * 
	 * @param jobunit_id 所属ジョブユニットのジョブID
	 */
	public void setJobunit_id(java.lang.String jobunit_id) {
		this.jobunit_id = jobunit_id;
	}
	
	
	/**
	 * ジョブIDを返す。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.pk-field 
	 * @ejb.interface-method
	 * 
	 * @return ジョブID
	 */
    public java.lang.String getJob_id() {
    	return job_id;
    }
    
	/**
	 * ジョブIDを設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param job_id ジョブID
	 */
    public void setJob_id(java.lang.String job_id) {
    	this.job_id = job_id;
    }
    
	/**
	 * ファシリティIDを返す。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.pk-field 
	 * @ejb.interface-method
	 * 
	 * @return ファシリティID
	 */
    public java.lang.String getFacility_id() {
    	return facility_id;
    }
    
	/**
	 * ファシリティIDを設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param facility_id ファシリティID
	 */
    public void setFacility_id(java.lang.String facility_id) {
    	this.facility_id = facility_id;
    }
    
	/**
	 * ファシリティ名を返す。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 * 
	 * @return ファシリティ名
	 */
    public java.lang.String getNode_name() {
    	return node_name;
    }
    
	/**
	 * ファシリティ名を設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param node_name ファシリティ名
	 */
    public void setNode_name(java.lang.String node_name) {
    	this.node_name = node_name;
    }
    
    /**
     * 実行状態を返す。
     * 
     * @ejb.persistent-field 
     * @ejb.interface-method
     * 
     * @return 実行状態
     * 
     * @see com.clustercontrol.bean.StatusConstant
     */
    public java.lang.Integer getStatus() {
    	return status;
    }
    
    /**
     * 実行状態を設定する。
     * 
     * @ejb.interface-method
     * 
     * @param status 実行状態
     * 
     * @see com.clustercontrol.bean.StatusConstant
     */
    public void setStatus(java.lang.Integer status) {
    	this.status = status;
    }
    
    /**
     * 開始・再開日時を返す。
     * 
     * @ejb.persistent-field 
     * @ejb.interface-method
     * 
     * @return 開始・再開日時
     */
    public java.util.Date getStart_date() {
    	return start_date;
    }
    
    /**
     * 開始・再開日時を設定する。
     * 
     * @ejb.interface-method
     * 
     * @param start_date 開始・再開日時
     */
    public void setStart_date(java.util.Date start_date) {
    	this.start_date = start_date;
    }
    
    /**
     * 終了・中断日時を返す。
     * 
     * @ejb.persistent-field 
     * @ejb.interface-method
     * 
     * @return 終了・中断日時
     */
    public java.util.Date getEnd_date() {
    	return end_date;
    }
    
    /**
     * 終了・中断日時を設定する。
     * 
     * @ejb.interface-method
     * 
     * @param end_date 終了・中断日時
     */
    public void setEnd_date(java.util.Date end_date) {
    	this.end_date = end_date;
    }
    
    /**
     * 戻り値を返す。
     * 
     * @ejb.persistent-field 
     * @ejb.interface-method
     * 
     * @return 戻り値
     */
    public java.lang.Integer getEnd_value() {
    	return end_value;
    }
    
    /**
     * 戻り値を設定する。
     * 
     * @ejb.interface-method
     * 
     * @param end_value 戻り値
     */
    public void setEnd_value(java.lang.Integer end_value) {
    	this.end_value = end_value;
    }
    
    /**
     * メッセージを返す。
     * 
     * @ejb.persistent-field 
     * @ejb.interface-method
     * 
     * @return メッセージ
     */
    public java.lang.String getMessage() {
    	return message;
    }
    
    /**
     * メッセージを設定する。
     * 
     * @ejb.interface-method
     * 
     * @param message メッセージ
     */
    public void setMessage(java.lang.String message) {
    	this.message = message;
    }
    
    /**
     * エージェントチェックを返す。
     * 
     * @ejb.persistent-field 
     * @ejb.interface-method
     * 
     * @return エージェントチェック
     * 
     * @see com.clustercontrol.jobmanagement.bean.AgentCheckConstant
     */
    public java.lang.Integer getAgent_check() {
    	return agent_check;
    }
    
    /**
     * エージェントチェックを設定する。
     * 
     * @ejb.interface-method
     * 
     * @param agent_check エージェントチェック
     * 
     * @see com.clustercontrol.jobmanagement.bean.AgentCheckConstant
     */
    public void setAgent_check(java.lang.Integer agent_check) {
    	this.agent_check = agent_check;
    }
    
    /**
     * エージェントチェック日時を返す。
     * 
     * @ejb.persistent-field 
     * @ejb.interface-method
     * 
     * @return エージェントチェック日時
     */
    public java.util.Date getCheck_date() {
    	return check_date;
    }
    
    /**
     * エージェントチェック日時を設定する。
     * 
     * @ejb.interface-method
     * 
     * @param check_date エージェントチェック日時
     */
    public void setCheck_date(java.util.Date check_date) {
    	this.check_date = check_date;
    }
    
    /**
     * リトライ回数を返す。
     * 
     * @ejb.persistent-field 
     * @ejb.interface-method
     * 
     * @return リトライ回数
     */
    public java.lang.Integer getRetry_count() {
    	return retry_count;
    }
    
    /**
     * リトライ回数を設定する。
     * 
     * @ejb.interface-method
     * 
     * @param retry_count リトライ回数
     */
    public void setRetry_count(java.lang.Integer retry_count) {
    	this.retry_count = retry_count;
    }
    
	/**
	 * 結果を返す。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 * 
	 * @return 結果
	 */
	public java.lang.String getResult() {
		return result;
	}
	
	/**
	 * 結果を設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param result 結果
	 */
	public void setResult(java.lang.String result) {
		this.result = result;
	}
	
    /**
     * 実行状態バッファを返す。
     * 
     * @ejb.persistent-field 
     * @ejb.interface-method
     * 
     * @return 実行状態バッファ
     * 
     * @see com.clustercontrol.bean.StatusConstant
     */
    public java.lang.Integer getStatus_buffer() {
    	return status_buffer;
    }
    
    /**
     * 実行状態バッファを設定する。
     * 
     * @ejb.interface-method
     * 
     * @param status_buffer 実行状態バッファ
     * 
     * @see com.clustercontrol.bean.StatusConstant
     */
    public void setStatus_buffer(java.lang.Integer status_buffer) {
    	this.status_buffer = status_buffer;
    }
	
	/**
	 * セッションジョブを取得する。
	 * 
	 * @ejb.interface-method view-type="local"
	 * 
	 * @return セッションジョブ
	 * 
	 * @see com.clustercontrol.jobmanagement.ejb.entity.JobSessionJobUtil
	 * @see com.clustercontrol.jobmanagement.ejb.entity.JobSessionJobPK
	 * @see com.clustercontrol.jobmanagement.ejb.entity.JobSessionJobBean#ejbFindByPrimaryKey(JobSessionJobPK)
	 */
    public JobSessionJobLocal getJobSessionJob() {
    	JobSessionJobLocal jobSessionJob = null;
		try {
			jobSessionJob = JobSessionJobUtil.getLocalHome().findByPrimaryKey(new JobSessionJobPK(getSession_id(), getJobunit_id(), getJob_id()));
		} catch (FinderException e) {
		} catch (NamingException e) {
		}
		return jobSessionJob;
	}
    
	/**
	 * セッションノードを作成する。
	 * 
	 * @ejb.home-method view-type="both"
	 * 
	 * @param sessionId セッションID
	 * @param jobunitId 所属ジョブユニットのジョブID
	 * @param jobs ジョブIDのコレクション
	 * @throws javax.ejb.CreateException
	 * @throws JobInfoNotFoundException 
	 * 
	 * @see com.clustercontrol.jobmanagement.dao.JobSessionNodeDAOImpl#makeSession(String, String, Collection)
	 */
    public void ejbHomeMakeSession(String sessionId, String jobunitId, Collection jobs)
    		throws javax.ejb.CreateException, JobInfoNotFoundException{
    	JobSessionNodeDAOImpl jsnDAO = new JobSessionNodeDAOImpl(); 
    	
    	jsnDAO.makeSession(sessionId, jobunitId, jobs);
    }
    
}
