/*
                                                                                                
Copyright (C) since 2009 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
 
*/

package com.clustercontrol.performance.factory;

import java.util.Collection;
import java.util.Iterator;

import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.performance.monitor.ejb.entity.CollectorItemCodeMstData;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorItemCodeMstLocal;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorItemCodeMstUtil;

/**
 * 収集項目コード定義マスタ情報追加クラス
 * 
 * @version 1.2.0
 * @since 1.2.0
 * @author uchiyama
 *
 */
public class OperateCollectItemCodeMaster {
	
	protected static Log m_log = LogFactory.getLog( OperateCollectItemCodeMaster.class );
	
	/**
	 * 収集項目コード定義マスタ情報を追加します。
	 * 
	 * @param data 収集項目コード定義情報
	 * @return 成功した場合、true
	 * @throws NamingException 
	 * @throws CreateException 
	 * 
	 */
	public boolean add(CollectorItemCodeMstData data) throws CreateException, NamingException {
		
		// 収集項目コード定義情報の追加
		CollectorItemCodeMstUtil.getLocalHome().create(
				data.getItemCode(),
				data.getCategoryCode(),
				data.getParentItemCode(),
				data.getItemName(),
				data.getMeasure(),
				data.getDeviceSupport(),
				data.getDeviceType(),
				data.getGraphRange()
		);
				
		return true;
	}
	
	/**
	 * 収集項目コード定義マスタ情報を削除します。
	 * @throws NamingException 
	 * @throws FinderException 
	 * @throws RemoveException 
	 * @throws EJBException 
	 */
	public boolean delete(String itemCode) throws FinderException, NamingException, EJBException, RemoveException {
		
		CollectorItemCodeMstLocal local = CollectorItemCodeMstUtil.getLocalHome().findByPrimaryKey(itemCode);
		// pkが同じデータが登録されている場合は、削除する
		local.remove();
		
		return true;
	}
	
	/**
	 * 収集項目コード定義マスタ情報を全て削除します。
	 * @throws NamingException 
	 * @throws FinderException 
	 * @throws RemoveException 
	 * @throws EJBException 
	 */
	public boolean deleteAll() throws FinderException, NamingException, EJBException, RemoveException {
		
		Collection<CollectorItemCodeMstLocal> col = CollectorItemCodeMstUtil.getLocalHome().findAll();
		Iterator<CollectorItemCodeMstLocal> itr = col.iterator();
		
		while(itr.hasNext()){
			itr.next().remove();
		}
		
		return true;
	}
	
}
