/*
                                                                                                
Copyright (C) since 2009 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
 
*/

package com.clustercontrol.performance.factory;

import java.util.Collection;
import java.util.Iterator;

import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.performance.monitor.ejb.entity.CollectorCalcMethodMstData;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorCalcMethodMstLocal;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorCalcMethodMstUtil;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorCategoryCollectMstData;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorCategoryCollectMstLocal;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorCategoryCollectMstPK;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorCategoryCollectMstUtil;

/**
 * カテゴリ別収集方法マスタ情報追加クラス
 * 
 * @version 1.2.0
 * @since 1.2.0
 * @author uchiyama
 *
 */
public class OperateCollectCategoryCollectMaster {
	
	protected static Log m_log = LogFactory.getLog( OperateCollectCategoryCollectMaster.class );
	
	/**
	 * カテゴリ別収集方法マスタ情報を追加します。
	 * 
	 * @param data カテゴリ別収集方法情報
	 * @return 成功した場合、true
	 * @throws NamingException 
	 * @throws CreateException 
	 * 
	 */
	public boolean add(CollectorCategoryCollectMstData data) throws CreateException, NamingException {
		
		// カテゴリ別収集方法情報の追加
		CollectorCategoryCollectMstUtil.getLocalHome().create(
				data.getPlatformId(),
				data.getSubPlatformId(),
				data.getCategoryCode(),
				data.getCollectMethod()
		);
				
		return true;
	}
	
	/**
	 * カテゴリ別収集方法マスタ情報を削除します。
	 * @throws NamingException 
	 * @throws FinderException 
	 * @throws RemoveException 
	 * @throws EJBException 
	 */
	public boolean delete(CollectorCategoryCollectMstPK pk) throws FinderException, NamingException, EJBException, RemoveException {
		
		CollectorCategoryCollectMstLocal local = CollectorCategoryCollectMstUtil.getLocalHome().findByPrimaryKey(pk);
		// pkが同じデータが登録されている場合は、削除する
		local.remove();
		
		return true;
	}
	
	/**
	 * カテゴリ別収集方法マスタ情報を全て削除します。
	 * @throws NamingException 
	 * @throws FinderException 
	 * @throws RemoveException 
	 * @throws EJBException 
	 */
	public boolean deleteAll() throws FinderException, NamingException, EJBException, RemoveException {
		
		Collection<CollectorCategoryCollectMstLocal> col = CollectorCategoryCollectMstUtil.getLocalHome().findAll();
		Iterator<CollectorCategoryCollectMstLocal> itr = col.iterator();
		
		while(itr.hasNext()){
			itr.next().remove();
		}
		
		return true;
	}
	
}
