/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.bean;

/**
 * ジョブ[スケジュール]ビューのテーブル定義を定数として定義するクラス<BR>
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class ScheduleTableDefine {

	/** スケジュールID */
	public static final int SCHE_ID = 0;
	/** スケジュール名 */
	public static final int SCHE_NAME = 1;
	/** ジョブID */
	public static final int JOB_ID = 2;
	/** ジョブ名 */
	public static final int JOB_NAME = 3;
	/** ジョブユニットID */
	public static final int JOBUNIT_ID = 4;
	/** カレンダID */
	public static final int CALENDAR_ID = 5;
	/** スケジュール */
	public static final int SCHEDULE = 6;
	/** 有効/無効 */
	public static final int VALID = 7;
	/** 新規作成ユーザ */
	public static final int CREATE_USER = 8;
	/** 作成日時 */
	public static final int CREATE_TIME = 9;
	/** 最終更新ユーザ */
	public static final int UPDATE_USER = 10;
	/** 最終更新日時 */
	public static final int UPDATE_TIME = 11;
	
	/** 初期表示時ソートカラム */
	public static final int SORT_COLUMN_INDEX = SCHE_ID;
	/** 初期表示時ソートオーダー (昇順=1, 降順=-1) */
	public static final int SORT_ORDER = 1;
	
}
