/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

/**
 * リポジトリツリー情報を取得するクライアント側アクションクラス
 */
package com.clustercontrol.repository.action;

import java.util.Locale;

import com.clustercontrol.bean.FacilityTreeItem;
import com.clustercontrol.repository.ejb.session.RepositoryController;
import com.clustercontrol.repository.util.EjbConnectionManager;

public class GetFacilityTree {

	/**
	 * 
	 * @param locale
	 * @return
	 */
	public FacilityTreeItem getFacilityTree(Locale locale){
		//System.out.println("GetFacilityTree.getFacilityTree() : start");

		FacilityTreeItem item = null;

		RepositoryController repository = EjbConnectionManager
				.getConnectionManager().getRepositoryController();

		try{
			item = repository.getFacilityTree(Locale.getDefault());
		}catch (Exception e) {
			System.out.println("Error : " + e.getMessage());
			e.printStackTrace();
		}

		//System.out.println("GetFacilityTree.getFacilityTree() : stop");
		return item;
	}
}
