/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.repository.action;

import java.rmi.AccessException;
import java.rmi.RemoteException;
import java.util.ArrayList;

import org.eclipse.jface.dialogs.MessageDialog;

import com.clustercontrol.FacilityDuplicateException;
import com.clustercontrol.action.FacilityTree;
import com.clustercontrol.bean.Property;
import com.clustercontrol.repository.bean.ScopeConstant;
import com.clustercontrol.repository.bean.ScopeInfo;
import com.clustercontrol.repository.ejb.session.RepositoryController;
import com.clustercontrol.repository.util.EjbConnectionManager;
import com.clustercontrol.repository.util.ScopePropertyUtil;
import com.clustercontrol.util.Messages;
import com.clustercontrol.util.PropertyUtil;

/**
 * スコープの追加を行うクライアント側アクションクラス<BR>
 * 
 * @version 2.2.0
 * @since 1.0.0
 */
public class AddScopeProperty {

    // ----- instance メソッド ----- //

    /**
     * 指定したスコープの配下に新しいスコープを追加します。
     * 
     * @param parentId
     *            親のスコープのファシリティID
     * @param property
     *            属性情報
     * @return 登録に成功した場合、true
     */
    public boolean add(String parentId, Property property) {
    	

    	
    	Property copy = PropertyUtil.copy(property);
        PropertyUtil.deletePropertyDefine(copy);

        RepositoryController repository = EjbConnectionManager
                .getConnectionManager().getRepositoryController();

        boolean result = false;
        try {
        	ScopeInfo scopeinfo = ScopePropertyUtil.property2scope(copy);
            repository.addScope(parentId, scopeinfo);
            result = true;
        } catch (RemoteException e) {
			if(e instanceof AccessException){
				// アクセス権なしの場合、エラーダイアログを表示する
	            MessageDialog.openInformation(null, Messages.getString("message"),
	                    Messages.getString("message.accesscontrol.16"));
			}
        } catch (FacilityDuplicateException e) {
			// ファシリティIDが重複している場合、エラーダイアログを表示する
			
			//ファシリティID取得
	        ArrayList values = PropertyUtil.getPropertyValue(copy, ScopeConstant.FACILITY_ID);
			String args[] = { (String)values.get(0) };

            MessageDialog.openInformation(
            		null, 
            		Messages.getString("message"),
                    Messages.getString("message.repository.26", args));
            return result;
		}
        
		if(result){
        	MessageDialog.openInformation(
        			null, 
        			Messages.getString("successful"), 
        			Messages.getString("message.repository.14"));
		}
		else{
        	MessageDialog.openError(
        			null, 
        			Messages.getString("failed"), 
        			Messages.getString("message.repository.15"));
		}
    	
		// リポジトリキャッシュの更新
		if(result)
			FacilityTree.reflesh();
		
    	return result;
    }
}