/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.repository;

import org.eclipse.ui.IFolderLayout;
import org.eclipse.ui.IPageLayout;

import com.clustercontrol.ClusterControlPerspectiveBase;
import com.clustercontrol.repository.view.NodeAttributeView;
import com.clustercontrol.repository.view.NodeListView;
import com.clustercontrol.repository.view.NodeScopeView;
import com.clustercontrol.repository.view.ScopeListView;

/**
 * リポジトリ機能のパースペクティブを生成するクラス<BR>
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class RepositoryPerspective extends ClusterControlPerspectiveBase {

    /**
     * @see org.eclipse.ui.IPerspectiveFactory#createInitialLayout(org.eclipse.ui.IPageLayout)
     */
    @Override
	public void createInitialLayout(IPageLayout layout) {
    	super.createInitialLayout(layout);
    	
        //エディタ領域のIDを取得
        String editorArea = layout.getEditorArea();

        //エディタ領域の左部60%を占めるフォルダを作成
        IFolderLayout top = layout.createFolder("top", IPageLayout.LEFT,
                0.65f, editorArea);
        //エディタ領域の右部40%を占めるフォルダを作成
        IFolderLayout right = layout.createFolder("right", IPageLayout.RIGHT,
                0.35f, editorArea);
        //エディタ領域の下部34%を占めるフォルダを作成
        IFolderLayout middle = layout.createFolder("middle",
                IPageLayout.BOTTOM, 0.34f, "top");
        //エディタ領域の下部34%を占めるフォルダを作成
        IFolderLayout bottom = layout.createFolder("bottom",
                IPageLayout.BOTTOM, 0.5f, "middle");

        top.addView(NodeListView.ID);
        right.addView(NodeAttributeView.ID);
        middle.addView(NodeScopeView.ID);
        bottom.addView(ScopeListView.ID);
    }
}