/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.priority.dialog;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

import com.clustercontrol.dialog.CommonDialog;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.priority.action.ModifyPriorityJudgment;
import com.clustercontrol.priority.bean.PriorityJudgmentInfo;
import com.clustercontrol.priority.composite.PatternComposite;
import com.clustercontrol.priority.composite.PatternLabelComposite;
import com.clustercontrol.util.Messages;

/**
 * 重要度判定の作成・変更ダイアログクラス<BR>
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public class PriorityJudgmentDialog extends CommonDialog {
	PriorityJudgmentInfo priorityInfo = null;
	
    // 後でpackするためsizeXはダミーの値。
    private final int sizeX = 600;
    private final int sizeY = 600;

    /** 変更用ダイアログ判別フラグ */
    protected boolean isModifyDialog = false;
    
    /** 入力値の正当性を保持するオブジェクト */
    private ValidateResult validateResult = null;
    
    protected PatternComposite pattern01 = null;
    protected PatternComposite pattern02 = null;
    protected PatternComposite pattern03 = null;
    protected PatternComposite pattern04 = null;
    protected PatternComposite pattern05 = null;
    protected PatternComposite pattern06 = null;
    protected PatternComposite pattern07 = null;
    protected PatternComposite pattern08 = null;
    protected PatternComposite pattern09 = null;
    protected PatternComposite pattern10 = null;
    protected PatternComposite pattern11 = null;
    protected PatternComposite pattern12 = null;
    protected PatternComposite pattern13 = null;
    protected PatternComposite pattern14 = null;
    protected PatternComposite pattern15 = null;
    
    /**
     * 指定した形式のダイアログのインスタンスを返します。
     * 
     * @param parent
     *            親のシェルオブジェクト
     * @param judgmentId
     *            判定ID
     * @param isModifyDialog
     *            変更用ダイアログとして利用する場合は、true
     */
    public PriorityJudgmentDialog(Shell parent, boolean isModifyDialog) {
        super(parent);
        setShellStyle(getShellStyle() | SWT.RESIZE | SWT.MAX);

        this.isModifyDialog = isModifyDialog;
    }
    
    /**
     * ダイアログの初期サイズを返します。
     * 
     * @return 初期サイズ
     */
    @Override
	protected Point getInitialSize() {
        return new Point(sizeX, sizeY);
    }

    /**
     * ダイアログエリアを生成します。
     * 
     * @param parent
     *            親のインスタンス
     */
    @Override
	protected void customizeDialog(Composite parent) {
        Shell shell = this.getShell();

        // タイトル
        shell.setText(Messages
                .getString("dialog.priority.create.modify"));

        // レイアウト
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.numColumns = 11;
        parent.setLayout(layout);

        /*
         * 判定の組み合わせ定義
         */
        Label label = new Label(parent, SWT.LEFT);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 11;
        label.setLayoutData(gridData);
        label.setText(Messages.getString("combination.definition.of.judgments") + " : ");

        Group group = new Group(parent, SWT.NONE);
        layout = new GridLayout(1, true);
        layout.marginWidth = 1;
        layout.marginHeight = 1;
        layout.numColumns = 1;
        group.setLayout(layout);
        
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 11;
        group.setLayoutData(gridData);
        
        //判定の組み合わせ＆判定結果
        PatternLabelComposite patternLabel = new PatternLabelComposite(group, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 11;
        patternLabel.setLayoutData(gridData);
        
		// 　　　　    通知 | 警告 | 危険 | 不明
        // パターン 1: ○　 | ×　 | ×　 | ×　
		// パターン 2: ○　 | ×　 | ×　 | ○　
		// パターン 3: ○　 | ○　 | ×　 | ×　
        // パターン 4: ○　 | ○　 | ×　 | ○　 
		// パターン 5: ×　 | ○　 | ×　 | ×　
		// パターン 6: ×　 | ○　 | ×　 | ○　 
		// パターン 7: ○　 | ×　 | ○　 | ×　
		// パターン 8: ○　 | ×　 | ○　 | ○　 
		// パターン 9: ○　 | ○　 | ○　 | ×　 
		// パターン10: ○　 | ○　 | ○　 | ○　 
		// パターン11: ×　 | ○　 | ○　 | ×　 
		// パターン12: ×　 | ○　 | ○　 | ○　 
		// パターン13: ×　 | ×　 | ○　 | ×　 
		// パターン14: ×　 | ×　 | ○　 | ○　
		// パターン15: ×　 | ×　 | ×　 | ○　 
        
        //パターン1
        pattern01 = new PatternComposite(group, SWT.NONE, true, false, false, false, this.priorityInfo.getPattern_01());
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 11;
        pattern01.setLayoutData(gridData);
        
        //パターン2
        pattern02 = new PatternComposite(group, SWT.NONE, true, false, false, true, this.priorityInfo.getPattern_02());
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 11;
        pattern02.setLayoutData(gridData);
        
        //パターン3
        pattern03 = new PatternComposite(group, SWT.NONE, true, true, false, false, this.priorityInfo.getPattern_03());
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 11;
        pattern03.setLayoutData(gridData);
        
        //パターン4
        pattern04 = new PatternComposite(group, SWT.NONE, true, true, false, true, this.priorityInfo.getPattern_04());
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 11;
        pattern04.setLayoutData(gridData);
        
        //パターン5
        pattern05 = new PatternComposite(group, SWT.NONE, false, true, false, false, this.priorityInfo.getPattern_05());
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 11;
        pattern05.setLayoutData(gridData);
        
        //パターン6
        pattern06 = new PatternComposite(group, SWT.NONE, false, true, false, true, this.priorityInfo.getPattern_06());
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 11;
        pattern06.setLayoutData(gridData);
        
        //パターン7
        pattern07 = new PatternComposite(group, SWT.NONE, true, false, true, false, this.priorityInfo.getPattern_07());
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 11;
        pattern07.setLayoutData(gridData);
        
        //パターン8
        pattern08 = new PatternComposite(group, SWT.NONE, true, false, true, true, this.priorityInfo.getPattern_08());
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 11;
        pattern08.setLayoutData(gridData);
        
        //パターン9
        pattern09 = new PatternComposite(group, SWT.NONE, true, true, true, false, this.priorityInfo.getPattern_09());
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 11;
        pattern09.setLayoutData(gridData);
        
        //パターン10
        pattern10 = new PatternComposite(group, SWT.NONE, true, true, true, true, this.priorityInfo.getPattern_10());
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 11;
        pattern10.setLayoutData(gridData);
        
        //パターン11
        pattern11 = new PatternComposite(group, SWT.NONE, false, true, true, false, this.priorityInfo.getPattern_11());
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 11;
        pattern11.setLayoutData(gridData);
        
        //パターン12
        pattern12 = new PatternComposite(group, SWT.NONE, false, true, true, true, this.priorityInfo.getPattern_12());
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 11;
        pattern12.setLayoutData(gridData);
        
        //パターン13
        pattern13 = new PatternComposite(group, SWT.NONE, false, false, true, false, this.priorityInfo.getPattern_13());
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 11;
        pattern13.setLayoutData(gridData);
        
        //パターン14
        pattern14 = new PatternComposite(group, SWT.NONE, false, false, true, true, this.priorityInfo.getPattern_14());
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 11;
        pattern14.setLayoutData(gridData);
        
        //パターン15
        pattern15 = new PatternComposite(group, SWT.NONE, false, false, false, true, this.priorityInfo.getPattern_15());
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 11;
        pattern15.setLayoutData(gridData);
        

        // ラインを引く
        Label line = new Label(parent, SWT.SEPARATOR | SWT.HORIZONTAL);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 11;
        line.setLayoutData(gridData);

        // 画面中央に
        Display display = shell.getDisplay();
        shell.setLocation((display.getBounds().width - shell.getSize().x) / 2,
                (display.getBounds().height - shell.getSize().y) / 2);
        
        //ダイアログのサイズ調整（pack:resize to be its preferred size）
        shell.pack();
        shell.setSize(new Point(sizeX, shell.getSize().y ));

    }

    /**
     * 入力値チェックをします。
     * 
     * @return 検証結果
     */
    @Override
	protected ValidateResult validate() {
        // 入力値生成
        this.priorityInfo = this.createInputData();

        if (this.priorityInfo != null) {
            return super.validate();
        } else {
            return validateResult;
        }
    }
    

    /**
     * 入力値を用いて通知情報を生成します。
     * 
     * @return 入力値を保持した重要度判定情報
     */
    protected PriorityJudgmentInfo createInputData() {

    	//各パターンの重要度を取得
    	this.priorityInfo.setPattern_01(new Integer(pattern01.getPriority()));
    	this.priorityInfo.setPattern_02(new Integer(pattern02.getPriority()));
    	this.priorityInfo.setPattern_03(new Integer(pattern03.getPriority()));
    	this.priorityInfo.setPattern_04(new Integer(pattern04.getPriority()));
    	this.priorityInfo.setPattern_05(new Integer(pattern05.getPriority()));
    	this.priorityInfo.setPattern_06(new Integer(pattern06.getPriority()));
    	this.priorityInfo.setPattern_07(new Integer(pattern07.getPriority()));
    	this.priorityInfo.setPattern_08(new Integer(pattern08.getPriority()));
    	this.priorityInfo.setPattern_09(new Integer(pattern09.getPriority()));
    	this.priorityInfo.setPattern_10(new Integer(pattern10.getPriority()));
    	this.priorityInfo.setPattern_11(new Integer(pattern11.getPriority()));
    	this.priorityInfo.setPattern_12(new Integer(pattern12.getPriority()));
    	this.priorityInfo.setPattern_13(new Integer(pattern13.getPriority()));
    	this.priorityInfo.setPattern_14(new Integer(pattern14.getPriority()));
    	this.priorityInfo.setPattern_15(new Integer(pattern15.getPriority()));
    	
        return this.priorityInfo;
    }

    /**
     * 変更用ダイアログなのかを返します。
     * 
     * @return 変更用ダイアログの場合、true
     */
    public boolean isModifyDialog() {
        return this.isModifyDialog;
    }

    /**
     * 入力値を保持したデータモデルを生成します。
     * 
     * @return データモデル
     */
    public PriorityJudgmentInfo getInputData() {
        return this.priorityInfo;
    }
    
    /**
     * 入力値を保持したデータモデルを設定します。
     * 
     * @return データモデル
     */
    public void setInputData(PriorityJudgmentInfo priorityInfo) {
        this.priorityInfo = priorityInfo;
    }

    /**
     * ＯＫボタンのテキストを返します。
     * 
     * @return ＯＫボタンのテキスト
     */
    @Override
	protected String getOkButtonText() {
        if (isModifyDialog()) {
            return Messages.getString("modify");
        } else {
            return Messages.getString("register");
        }
    }

    /**
     * キャンセルボタンのテキストを返します。
     * 
     * @return キャンセルボタンのテキスト
     */
    @Override
	protected String getCancelButtonText() {
        return Messages.getString("cancel");
    }

	@Override
	protected void okPressed() {
        ValidateResult result = this.validate();

        if (result == null || result.isValid()) {
        	//変更時
        	if(this.isModifyDialog){
            	if (new ModifyPriorityJudgment().edit(this.priorityInfo)) {
                    // 成功報告ダイアログを生成
                	MessageDialog.openInformation(
                			null, 
                			Messages.getString("successful"), 
                			Messages.getString("message.priority.judgment.1"));
                } else {
                    // 失敗報告ダイアログを生成
                	MessageDialog.openError(
                			null, 
                			Messages.getString("failed"), 
                			Messages.getString("message.priority.judgment.2"));
                }
        		super.okPressed();
        	}
        	else{
        		
        	}
        } else {
            this.displayError(result);
        }
	}
}