/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 */

package com.clustercontrol.performance.view.action;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

import com.clustercontrol.performance.action.RecordController;
import com.clustercontrol.performance.dialog.RecordSetDialog;
import com.clustercontrol.performance.util.Messages;
import com.clustercontrol.performance.view.CurrentListView;
import com.clustercontrol.performance.bean.CollectorProperty;

/**
 * 収集中データのプロパティ表示を行うアクションクラス
 * 
 * @version 1.0
 * @since 1.0
 */
public class ShowPropertyAction implements IViewActionDelegate {
	public static final String ID = "com.clustercontrol.performance.view.action.ShowPropertyAction";
	
    private IViewPart viewPart; // ビュー

    /**
     * ビューを保持します。ワークベンチにロードされた際に呼ばれます。
     * 
     * @param view ビューのインスタンス
     * 
     * @see org.eclipse.ui.IViewActionDelegate#init(org.eclipse.ui.IViewPart)
     */
    public void init(IViewPart view) {
        this.viewPart = view;
    }

    /**
     * 性能[収集データ]ビューで選択されている収集のプロパティ表示を行います。
     * 
     * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
     */
    public void run(IAction action) {
        /*
         * 呼び出し元のViewを持ってきます。
         */
        IWorkbenchPage page = PlatformUI.getWorkbench()
                .getActiveWorkbenchWindow().getActivePage();
        CurrentListView currentListView = (CurrentListView) page
                .findView(CurrentListView.ID);

        String collectorId = currentListView.getSelectedID();
        
        // プロパティを表示
        if (collectorId != null) {
    		// アクセス権なしの場合、エラーダイアログを表示する
        	if(!RecordController.getInstance().checkPermissionRead()){
        		MessageDialog.openInformation(null, com.clustercontrol.util.Messages.getString("message"),
        				com.clustercontrol.util.Messages.getString("message.accesscontrol.16"));
        		return;
        	}
        	
            /*
             * controllerの初期化をします。
             */
            RecordController controller = RecordController.getInstance();
            // マネージャとの接続に失敗した場合はエラーダイアログを表示
            if (controller == null) {
                MessageDialog.openError(this.viewPart.getSite().getShell(),
                        Messages.getString("MESSAGE_0020"),  // "確認"
                        Messages.getString("CONNECTION_ERROR_MESSAGE"));
                return;
            }
        	
            // 削除ロックをかける
            controller.lock(collectorId);
        	
            CollectorProperty property = controller
                    .getCollectorProperty(collectorId);
            // 収集定義を取得できなかった場合はエラーダイアログを表示
            if (property == null) {
                MessageDialog.openError(this.viewPart.getSite().getShell(),
                        Messages.getString("MESSAGE_0020"),  // "確認"
                        Messages.getString("GET_PROPERTY_ERROR_MESSAGE"));
                return;
            }

            Shell shell = new Shell();
            // 編集不可でダイアログを生成
            RecordSetDialog propertyDialog = new RecordSetDialog(shell, property, false);
            propertyDialog.open();
        } else {

            String msg = Messages.getString("MESSAGE_0014");

            MessageDialog.openError(null,
                    Messages.getString("ERROR_IN_JP"), msg);
        }

    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.ui.IActionDelegate#selectionChanged(org.eclipse.jface.action.IAction,
     *      org.eclipse.jface.viewers.ISelection)
     */
    public void selectionChanged(IAction action, ISelection selection) {

    }

}