/*

 Copyright (C) 2006 NTT DATA Corporation

 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 */

package com.clustercontrol.performance.monitor.action;

import java.rmi.AccessException;
import java.rmi.RemoteException;

import org.eclipse.jface.dialogs.MessageDialog;

import com.clustercontrol.HinemosUnknownException;
import com.clustercontrol.MonitorNotFoundException;
import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.performance.monitor.util.EjbConnectionManager;
import com.clustercontrol.performance.monitor.ejb.session.MonitorPerfController;
import com.clustercontrol.util.Messages;

/**
 * リソース監視情報を更新するクラス
 * 
 * @version 2.2.0
 * @since 2.0.0
 */
public class ModifyPerformance {

    /**
     * リソース監視情報を更新します。
     * 
     * @param info リソース監視情報
     * @return 更新に成功した場合、true
     */
    public boolean modify(MonitorInfo info) {
    	
    	MonitorPerfController ctr = EjbConnectionManager.getConnectionManager().getMonitorPerfController();

        boolean result = false;
        String[] args = { info.getMonitorId() };
        try {
        	result = ctr.modifyPerformance(info);
        } catch (RemoteException e) {
			if(e instanceof AccessException){
				// アクセス権なしの場合、エラーダイアログを表示する
	            MessageDialog.openInformation(
	            		null, 
	            		Messages.getString("message"),
	                    Messages.getString("message.accesscontrol.16"));
			}
        } catch (MonitorNotFoundException e) {
		} catch (HinemosUnknownException e) {
		}
        
		if(result){
        	MessageDialog.openInformation(
        			null, 
        			Messages.getString("successful"), 
        			Messages.getString("message.monitor.35", args));
		}
		else{
        	MessageDialog.openError(
        			null, 
        			Messages.getString("failed"), 
        			Messages.getString("message.monitor.36", args));
		}
        
        return result;
    }
}