/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 */

package com.clustercontrol.performance.dialog;

import java.text.SimpleDateFormat;
import java.util.Date;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

import com.clustercontrol.dialog.DateTimeDialog;
import com.clustercontrol.performance.bean.GraphConstant;
import com.clustercontrol.performance.util.Messages;
import com.clustercontrol.performance.util.RealtimeCollectorInfo;
import com.clustercontrol.performance.util.RealtimeCollectorItemInfo;


/**
 * リアルタイムの表示設定を行うダイアログ 設定の項目はfacilityID 収集項目 更新間隔など。
 * このダイアログよりリアルタイム表示が開始される
 * 
 * @version 1.0
 * @since 1.0
 */
public class RealtimeSetDialog2 extends Dialog {	//CommonDialogをextendするよう仕様変更する.
	
	private static int plotNum;
	
	private Composite composite = null;
	
	private Composite composite2 = null;
	
	private Group group4 = null;
	
	private Combo combo = null;
	private Combo combo1 = null;
	
	private int comboSetting;
	private int comboIndex;
	
	private RealtimeCollectorInfo collectorInfo = null;
	
	private RealtimeCollectorItemInfo collectorItemInfo = null;
	
//	private Combo combo = null;
	
	private int arrayNum;
	
	private Group plotGroup;
	private Group rangeGroup;
	
	private Button radioButton00;
	
	private Button radioButton01;
	
	private Text startTimeText = null;
	private Label startTimeLabel = null;
	private Label endTimeTopLabel = null;
	private Text endTimeText = null;
	private Label endTimeLabel = null;
	
	private Button startTimeButton;
	private Button endTimeButton;
	
	private Date startTime = null;
	private Date endTime = null;
	
	private Date startTimeLocal;
	private Date endTimeLocal;
	
	private boolean isRange = false;
	
	
	private boolean isInterval = false;
	
	private Shell parent;
	
	private SimpleDateFormat dateFormat;
	private boolean isPlotAuto = false;
	
	private int interval;
	
	
	/**
	 * コンストラクター
	 * 
	 * @param parent
	 */
	public RealtimeSetDialog2(Shell parent) {
		super(parent);
		
		// 画面中央に配置する(ダイアログ呼び出し側で逐一記述する手間をかけさせない).
		Display display = parent.getDisplay();
		parent.setLocation((display.getBounds().width - parent.getSize().x) / 2,
				(display.getBounds().height - parent.getSize().y) / 2);
		
		this.parent = parent;
		
		initialize();
	}
	
	private void initialize() {	
		dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
	}
	
	public void update() {	
		
		collectorItemInfo.refreshItemInfoForDialog();
		
		interval = collectorInfo.getInterval();
		
		// 実績グラフ表示の場合のみの設定.
		if (collectorInfo.getCollectStartTime() != null) { // 全てのチェックは省略.
			
			//collectorInfo.getCollectStartTime(); 収集開始時刻
			//collectorInfo.getCollectEndTime(); 収集終了予定時刻
			//collectorInfo.getGraphStartTime(); グラフ表示開始時刻
			//collectorInfo.getGraphEndTime(); グラフ表示終了時刻
			
			startTime = collectorInfo.getCollectStartTime();
			endTime = collectorInfo.getCollectEndTime();
			
			if(endTime == null){
				endTime = new Date(); // 現在の時刻を終了時刻に設定する。	
			} 
			
			if (collectorInfo.getGraphStartTime() == null) {
				startTimeLocal = startTime;
				
				endTimeLocal = new Date(startTime.getTime() + interval * 1000 * GraphConstant.REALTIME_GRAPH_MAX_PLOT);  
				if (endTimeLocal.after(endTime)) { // グラフ表示終了時刻が収集終了時刻をすぎている場合
					endTimeLocal = endTime;
				}
				collectorInfo.setGraphPlotNum(0);
				
			} else {
				
				startTimeLocal = collectorInfo.getGraphStartTime();
				endTimeLocal = collectorInfo.getGraphEndTime();
				if (endTimeLocal.after(endTime)) { // グラフ表示終了時刻が収集終了時刻をすぎている場合
					endTimeLocal = endTime;
				}
			}
			
			isRange = true;
		} else {
			isRange = false;
		}
		
		
		switch (collectorInfo.getInterval()) {
		case 5:
			this.comboSetting = 0;
			break;
		case 10:
			this.comboSetting = 1;
			break;
		case 30:
			this.comboSetting = 2;
			break;
		case 60:
			this.comboSetting = 3;
			break;
		}
		
		switch (collectorInfo.getGraphPlotNum()) {
		case GraphConstant.PLOT_NUM_1:
			this.comboIndex = 0;
			break;
		case GraphConstant.PLOT_NUM_2:
			this.comboIndex = 1;
			break;
		case GraphConstant.PLOT_NUM_3:
			this.comboIndex = 2;
			break;
		case GraphConstant.PLOT_NUM_4:
			this.comboIndex = 3;
			break;
		}
		
		
	}
	
	@Override
	protected Point getInitialSize() {
		return new Point(450, 270);
	}
	
	@Override
	protected void configureShell(Shell newShell) {
		super.configureShell(newShell);
		newShell.setText(Messages.getString("PLOT_AND_SPAN")); // "プロット数と期間"
	}
	
	@Override
	protected Control createDialogArea(Composite parent) {
		composite = (Composite) super.createDialogArea(parent);
		composite.setLayout(new FormLayout());
		createComposite2();
		return composite;
	}
	
	private void createComposite2() {
		composite2 = new Composite(composite, SWT.NONE);
		FormData composite2Data = new FormData();
		composite2Data.top = new FormAttachment(0, 0); // ダイアログ内のコンポジットの上に張りつく
		composite2Data.bottom = new FormAttachment(100, 0); // ダイアログ内のコンポジットの下に張りつく
		composite2Data.right = new FormAttachment(100, 0); // ダイアログ内のコンポジットの右に張りつく
		composite2Data.left = new FormAttachment(0, 0); // ダイアログ内のコンポジットの右に張りつく
		composite2.setLayoutData(composite2Data);
		
		GridLayout gridLayout00 = new GridLayout();
		GridData gridDataGroup = new GridData(GridData.FILL_HORIZONTAL);
		// 将来はデータ項目を選択可能にすることを視野にいれる。
		
		// 初期化または前回設定の復元
		
		// グループの設定
		String itemCode = collectorItemInfo.getItemCodeForDialog(0);
		plotGroup = new Group(composite2, SWT.NONE);
		gridDataGroup = new GridData(GridData.FILL_HORIZONTAL);
		plotGroup.setLayoutData(gridDataGroup);
		plotGroup.setText(Messages.getString("PLOT")); // "プロット"
		
		gridLayout00 = new GridLayout();
		gridLayout00.numColumns = 3; //３列
		plotGroup.setLayout(gridLayout00);
		
		
		// ラジオボタン(共通：前処理)
		GridData gridData00;
		if (collectorInfo.getGraphPlotNum() == 0) {
			isPlotAuto = true;
			comboIndex = 0;
		} else {
			isPlotAuto = false;
		}
		
		// ラジオボタン(固定)
		radioButton00 = new Button(plotGroup, SWT.RADIO);
		radioButton00.setText(Messages.getString("FIXED")); // "固定"
		gridData00 = new GridData(GridData.FILL_VERTICAL);
		gridData00.horizontalSpan = 1; //３列分を占める
		radioButton00.setLayoutData(gridData00);
		radioButton00.setSelection(! isPlotAuto);
		radioButton00.addListener(SWT.Selection, new Listener() {
			public void handleEvent(Event event) {
				isPlotAuto = false;
				combo1.setEnabled(true);
				endTimeTopLabel.setEnabled(false);
				endTimeText.setEnabled(false);
				endTimeButton.setEnabled(false);
				
				if (combo1.getSelectionIndex() == 0) {
					plotNum = GraphConstant.PLOT_NUM_1;
				} else if (combo1.getSelectionIndex() == 1) {
					plotNum = GraphConstant.PLOT_NUM_2;
				} else if (combo1.getSelectionIndex() == 2) {
					plotNum = GraphConstant.PLOT_NUM_3;
				} else if (combo1.getSelectionIndex() == 3) {
					plotNum = GraphConstant.PLOT_NUM_4;
				}
				
				if (isRange) {
					
					endTimeLocal = new Date(startTimeLocal.getTime() + interval * 1000 * plotNum);
					if (endTimeLocal.after(endTime)) { // グラフ表示終了時刻が収集終了時刻をすぎている場合
						endTimeLocal = endTime;
					}
					endTimeText.setText(dateFormat.format(endTimeLocal));
					
				}
			}
		});
		
		//comboの設定
		//     リスト内の文字列の編集を不可にするため
		//    SWT.READ_ONLYを指定(尚ビット演算指定以外の指定方法見つからず).
		combo1 = new Combo(plotGroup, SWT.NONE | SWT.READ_ONLY);
		GridData gridDataCombo = new GridData(GridData.VERTICAL_ALIGN_BEGINNING);
		gridDataCombo.horizontalSpan = 1; //3列分を占める
		combo1.setLayoutData(gridDataCombo);
		
		combo1.add(GraphConstant.PLOT_NUM_1 + Messages.getString("PLOT"));  // プロット
		combo1.add(GraphConstant.PLOT_NUM_2 + Messages.getString("PLOT"));  // プロット
		combo1.add(GraphConstant.PLOT_NUM_3 + Messages.getString("PLOT")); // プロット
		combo1.add(GraphConstant.PLOT_NUM_4 + Messages.getString("PLOT")); // プロット
		
		// 既に選択されているときはそれを復元する必要がある.
		combo1.select(comboIndex); //選択項目.この指定がない場合「指定なし」の選択が可能となってしまう.
		combo1.addSelectionListener(new SelectionListener() {
			public void widgetDefaultSelected(SelectionEvent e) {
			}
			public void widgetSelected(SelectionEvent e) {
				comboIndex = combo1.getSelectionIndex();
				
				if (combo1.getSelectionIndex() == 0) {
					plotNum = GraphConstant.PLOT_NUM_1;
				} else if (combo1.getSelectionIndex() == 1) {
					plotNum = GraphConstant.PLOT_NUM_2;
				} else if (combo1.getSelectionIndex() == 2) {
					plotNum = GraphConstant.PLOT_NUM_3;
				} else if (combo1.getSelectionIndex() == 3) {
					plotNum = GraphConstant.PLOT_NUM_4;
				}
				
				if (isRange) {
					
					endTimeLocal = new Date(startTimeLocal.getTime() + interval * 1000 * plotNum);
					if (endTimeLocal.after(endTime)) { // グラフ表示終了時刻が収集終了時刻をすぎている場合
						endTimeLocal = endTime;
					}
					endTimeText.setText(dateFormat.format(endTimeLocal));
					
				}
			} // widgetSelected
		});
		
		// ラジオボタン(自動)
		radioButton01 = new Button(plotGroup, SWT.RADIO);
		// 最大プロット数が200を超えるときは先頭200プロット、とはしない.
		// 理由は、200プロット以上での表示も可能にするため.
		// うっかりミス対策は、初期表示をするとき200を超えるときは固定を選択させるかたちとした.
		radioButton01.setText(Messages.getString("AUTO")); // "自動 "
		gridData00 = new GridData(GridData.FILL_VERTICAL);
		gridData00.horizontalSpan = 3; //３列分を占める
		radioButton01.setLayoutData(gridData00);
		radioButton01.setSelection(isPlotAuto);
		radioButton01.addListener(SWT.Selection, new Listener() {
			public void handleEvent(Event event) {
				isPlotAuto = true;
				combo1.setEnabled(false);
				if (isRange) {
					if (!endTimeTopLabel.getEnabled()) {
					endTimeTopLabel.setEnabled(true);
					endTimeText.setEnabled(true);
					endTimeButton.setEnabled(true);
						endTimeLocal = new Date(startTimeLocal.getTime() + interval * 1000 * plotNum);
						if (endTimeLocal.after(endTime)) { // グラフ表示終了時刻が収集終了時刻をすぎている場合
						endTimeLocal = endTime;
						}
					}					
				}
			}
		});
		
		// ラジオボタン(共通：後処理)
		if (collectorInfo.getGraphPlotNum() == 0) {
			combo1.setEnabled(false);
		}
		// 初期化または前回設定の復元
		
		// グループの設定
		rangeGroup = new Group(composite2, SWT.NONE);
		gridDataGroup = new GridData(GridData.FILL_HORIZONTAL);
		rangeGroup.setLayoutData(gridDataGroup);
		rangeGroup.setText(Messages.getString("SPAN")); // "期間"
		
		gridLayout00 = new GridLayout();
		
		if (isRange) {
			rangeGroup.setEnabled(true);
			gridLayout00.numColumns = 4; //３列に分割する.
		} else {
			rangeGroup.setEnabled(false);
			gridLayout00.numColumns = 3; //３列に分割する.
		}
		rangeGroup.setLayout(gridLayout00);
		
		// ラジオボタン(共通：前処理)
		GridData gridData004;
		
		// ラジオボタン(非表示)
		startTimeLabel = new Label(rangeGroup, SWT.NONE);
		startTimeLabel.setText(Messages.getString("START") + ":");  // "開始"
		gridData004 = new GridData(GridData.FILL_VERTICAL);
		gridData004.horizontalSpan = 1; //３列分を占める
		startTimeLabel.setLayoutData(gridData004);
		if (! isRange) {
			startTimeLabel.setEnabled(false);
		}
		
		startTimeText = new Text(rangeGroup, SWT.BORDER | SWT.READ_ONLY);
		if (isRange) {
			startTimeText.setText(dateFormat.format(startTimeLocal));
		} else {
			startTimeText.setText("*********NR**********");
			startTimeText.setEnabled(false);
		}
		gridData004 = new GridData(GridData.FILL_VERTICAL);
		gridData004.horizontalSpan = 1; //３列分を占める
		startTimeText.setLayoutData(gridData004);
		
		startTimeButton = new Button(rangeGroup, SWT.NULL);
		startTimeButton.setText(Messages.getString("REFER")); // "参照"
		if (! isRange) {
			startTimeButton.setEnabled(false);
		}
		gridData004 = new GridData(GridData.FILL_VERTICAL);
		gridData004.horizontalSpan = 1; //３列分を占める
		startTimeButton.setLayoutData(gridData004);
		startTimeButton.addListener(SWT.Selection, new Listener() {
			public void handleEvent(Event event) {
				Date date = startTimeLocal;
				DateTimeDialog dialog = new DateTimeDialog(parent);
				dialog.setDate(date);
				//選択した日付を取得する
				dialog.open();
				date = dialog.getDate();
				
				Date startTimeTemp = new Date(startTime.getTime()-1000);  // 判定だけに使用する変数(収集開始時刻より1秒ひいたもの)
				if (isPlotAuto) { // プロット数の指定が「自動」の場合
					if (date != null && date.after(startTimeTemp) && date.before(endTimeLocal)) {
					startTimeLocal = date;
					startTimeText.setText(dateFormat.format(date));
				}
				} else {// プロット数の指定が「固定」の場合
					if (date != null && date.after(startTimeTemp) && date.before(endTime)) {
						startTimeLocal = date;
						startTimeText.setText(dateFormat.format(startTimeLocal));
						
						endTimeLocal = new Date(startTimeLocal.getTime() + interval * 1000 * plotNum);
						if (endTimeLocal.after(endTime)) {
							endTimeLocal = endTime;
						}
						endTimeText.setText(dateFormat.format(endTimeLocal));
					}
				}
				dialog = null;
			}
		});
		
		if (isRange) {
			startTimeLabel = new Label(rangeGroup, SWT.NONE);
			startTimeLabel.setText(dateFormat.format(startTime) + Messages.getString("AFTER")); // "以降"
			gridData004 = new GridData(GridData.FILL_VERTICAL);
			gridData004.horizontalSpan = 1; //３列分を占める
			startTimeLabel.setLayoutData(gridData004);
		}
		
		endTimeTopLabel = new Label(rangeGroup, SWT.NONE);
		endTimeTopLabel.setText(Messages.getString("END") + ":"); // "終了:"
		endTimeTopLabel.setLayoutData(gridData004);
		if (! isRange || ! isPlotAuto) {
			endTimeTopLabel.setEnabled(false);
		}
		gridData004 = new GridData(GridData.FILL_VERTICAL);
		gridData004.horizontalSpan = 1; //３列分を占める
		endTimeTopLabel.setLayoutData(gridData004);
		
		endTimeText = new Text(rangeGroup, SWT.BORDER | SWT.READ_ONLY);
		if (isRange) {
			endTimeText.setText(dateFormat.format(endTimeLocal));
		} else {
			endTimeText.setText("*********NR**********");
		}
		if (! isPlotAuto) {
			endTimeText.setEnabled(false);
		}
		
		endTimeButton = new Button(rangeGroup, SWT.NULL);
		endTimeButton.setText(Messages.getString("REFER")); // "参照"
		if (! isRange || ! isPlotAuto) {
			endTimeButton.setEnabled(false);
		}
		gridData004 = new GridData(GridData.FILL_VERTICAL);
		gridData004.horizontalSpan = 1; //３列分を占める
		endTimeButton.setLayoutData(gridData004);
		endTimeButton.addListener(SWT.Selection, new Listener() {
			public void handleEvent(Event event) {
				Date date = endTimeLocal;
				DateTimeDialog dialog = new DateTimeDialog(parent);
				dialog.setDate(date);
				//選択した日付を取得する
				dialog.open();
				date = dialog.getDate();
				
				if (date != null && date.after(startTimeLocal) && date.before(endTime)) {
					endTimeLocal = date;
					endTimeText.setText(dateFormat.format(date));
				}
				dialog = null;
			}
		});
		
		if (isRange) {
			endTimeLabel = new Label(rangeGroup, SWT.NONE);
			endTimeLabel.setText(dateFormat.format(endTime) + Messages.getString("BEFORE")); // "以前"
			gridData004 = new GridData(GridData.FILL_VERTICAL);
			gridData004.horizontalSpan = 1; //３列分を占める
			endTimeLabel.setLayoutData(gridData004);
		}

		composite2.setLayout(new GridLayout());
	}
	
	/**
	 * グラフの更新間隔(秒)を指定する領域の生成
	 *  
	 */
	private void createIntervalGroup() {
		// 共通処理
		group4 = new Group(composite2, SWT.NONE);
		GridData gridDataGroup4 = new GridData(GridData.FILL_HORIZONTAL);
		group4.setLayoutData(gridDataGroup4);
		group4.setText(Messages.getString("GRAPH_REFRESH_INTERVAL_IN_JP"));
		
		GridLayout gridLayoutRefresh = new GridLayout();
		group4.setLayout(gridLayoutRefresh);
		
		// プルダウン
		combo = new Combo(group4, SWT.READ_ONLY);
		GridData gridDataRefresh;
		gridDataRefresh = new GridData(GridData.FILL_VERTICAL);
		combo.setLayoutData(gridDataRefresh);
		if (this.isInterval) {
			combo.add(Messages.getString("5SEC"));
			combo.add(Messages.getString("10SEC"));
			combo.add(Messages.getString("30SEC"));
			combo.add(Messages.getString("1MIN"));
			combo.select(comboSetting); //選択項目
		}
		
		combo.setEnabled(this.isInterval);
	}
	
	/**
	 * OKボタン押下時の処理
	 */
	@Override
	protected void okPressed() {
		
		collectorItemInfo.copyItemInfoForDialog();
		
		if (this.isInterval) {
			if (combo.getSelectionIndex() == 0) {
				collectorInfo.setInterval(5);
				collectorInfo.setRequestInterval(5);
			} else if (combo.getSelectionIndex() == 1) {
				collectorInfo.setInterval(10);
				collectorInfo.setRequestInterval(10);
			} else if (combo.getSelectionIndex() == 2) {
				collectorInfo.setInterval(30);
				collectorInfo.setRequestInterval(30);
			} else if (combo.getSelectionIndex() == 3) {
				collectorInfo.setInterval(60);
				collectorInfo.setRequestInterval(60);
			}
		}
		
		if (isPlotAuto) {
			collectorInfo.setGraphPlotNum(0);
		} else {
			if (combo1.getSelectionIndex() == 0) {
				collectorInfo.setGraphPlotNum(GraphConstant.PLOT_NUM_1);
			} else if (combo1.getSelectionIndex() == 1) {
				collectorInfo.setGraphPlotNum(GraphConstant.PLOT_NUM_2);
			} else if (combo1.getSelectionIndex() == 2) {
				collectorInfo.setGraphPlotNum(GraphConstant.PLOT_NUM_3);
			} else if (combo1.getSelectionIndex() == 3) {
				collectorInfo.setGraphPlotNum(GraphConstant.PLOT_NUM_4);
			}
		}
		
		
//		if (startTimeLocal != null && startTimeLocal.compareTo(startTime) != 0) {
//		collectorInfo.setGraphStartTime(startTimeLocal);
//		}
//		
//		if (endTimeLocal != null && endTimeLocal.compareTo(endTime) != 0) {
//		collectorInfo.setGraphEndTime(endTimeLocal);
//		}
		
		if (startTimeLocal != null) {
			collectorInfo.setGraphStartTime(startTimeLocal);
		}
		
		if (endTimeLocal != null) {
			collectorInfo.setGraphEndTime(endTimeLocal);
		}
		super.okPressed();
	}
	
	public void setCollectorInfo(RealtimeCollectorInfo collectorInfo) {
		this.collectorInfo = collectorInfo;
	}
	
	public void setCollectorItemInfo(RealtimeCollectorItemInfo collectorItemInfo) {
		this.collectorItemInfo = collectorItemInfo;
	}
	
	public void setInterval(boolean isInterval) {
		this.isInterval = isInterval;
	}
}