package com.clustercontrol.notify.util;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

import com.clustercontrol.HinemosUnknownException;
import com.clustercontrol.NotifyNotFoundException;
import com.clustercontrol.notify.bean.NotifyTypeMstInfo;
import com.clustercontrol.notify.bean.NotifyTypeMstMap;
import com.clustercontrol.util.Messages;

public class NotifyTypeMstMapCache {
	private static volatile NotifyTypeMstMap map = null;
	
	private synchronized static void init(){
		// 連続でinit()が呼ばれた場合、すでにインスタンスが生成されているのであれば処理する必要がない
		if(map != null){
			return;
		}
		
		// マネージャから情報を取得します。
		try {
			map = EjbConnectionManager.getConnectionManager().getNotifyController().getNotifyTypeMstMap();
		} catch (RemoteException e) {
			// 取得に失敗した場合は、空のマップを返す
			map = new NotifyTypeMstMap(new ArrayList<NotifyTypeMstInfo>());
		} catch (NotifyNotFoundException e){
		} catch (HinemosUnknownException e){
		}
	}

	/**
	 * 保持しているキャッシュ情報をクリアする。
	 */
	public synchronized static void clear(){
		map = null;
	}

	/**
	 * 各通知の定義情報をリストに格納し返します。<BR>
	 * 
	 * @return 各通知の定義情報のリスト
	 */
	public static List<NotifyTypeMstInfo> getNotifyTypeMstInfoList() {
		if(map == null){
			init();
		}

		return map.getNotifyTypeMstInfoList();
	}
	
	/**
	 * 種別から文字列に変換します。
	 * 
	 * @param type 種別
	 * @return 文字列
	 */
	public static String typeToString(int type) {
		if(map == null){
			init();
		}

		return Messages.getString(map.getNotifyTypeMstInfo(type).getNotifyNameKey());
	}
	
	/**
	 * 種別からクラスに変換します。<BR>
	 * 
	 * @param 文字列
	 * @return ダイアログ
	 */
	public static String typeToDialog(int type) {
		if(map == null){
			init();
		}
		
		return map.getNotifyTypeMstInfo(type).getDialogClassName();
	}
}
