/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.notify.action;

import java.rmi.AccessException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.window.Window;

import com.clustercontrol.HinemosUnknownException;
import com.clustercontrol.NotifyNotFoundException;
import com.clustercontrol.bean.HinemosModuleConstant;
import com.clustercontrol.notify.ejb.session.NotifyController;
import com.clustercontrol.notify.util.EjbConnectionManager;
import com.clustercontrol.util.Messages;

/**
 * 通知情報を削除するクライアント側アクションクラス<BR>
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class DeleteNotify {

    /**
     * 通知情報を削除します。<BR>
     * マネージャにSessionBean経由でアクセスします。
     * 
     * @param notifyId 削除対象の通知ID
	 * @return 削除に成功した場合、<code> true </code>
     * @throws HinemosUnknownException 
     * @throws NotifyNotFoundException 
	 * 
	 * @see com.clustercontrol.notify.util.EjbConnectionManager
	 * @see com.clustercontrol.notify.ejb.session.NotifyController
	 * @see com.clustercontrol.notify.ejb.session.NotifyControllerBean#deleteNotify(java.lang.String)
     */
    public boolean delete(String notifyId) {
    	
        NotifyController notify = EjbConnectionManager.getConnectionManager().getNotifyController();

        boolean result = false;
        try {
        	result = notify.deleteNotify(notifyId);
        	
        	return result;
        } catch (RemoteException e) {
			if(e instanceof AccessException){
				// アクセス権なしの場合、エラーダイアログを表示する
	            MessageDialog.openInformation(null, Messages.getString("message"),
	                    Messages.getString("message.accesscontrol.16"));
			}
        } catch (NotifyNotFoundException e) {
        } catch (HinemosUnknownException e) {
        } 
        return false;
    }
    
    
    public int useCheck (String notifyId){
        NotifyController notify = EjbConnectionManager.getConnectionManager().getNotifyController();

        int result = Window.OK;
        try {
        	ArrayList<String> notifyGroupIdList = notify.checkNotifyId(notifyId);
        	
        	if(notifyGroupIdList.size() != 0){
        		String message = null;
        		String notifyGroupId = null;
        		String[] strings = null;
    			String moduleName = "";
    			ArrayList<String> checkList = new ArrayList<String>();	// 同一監視内で、同じ監視項目IDを表示しないようチェックするリスト（文字列監視用）
    			String id = this.toString();
        		
        		Iterator<String> itr = notifyGroupIdList.iterator();
        		
        		String[] args = { notifyId };        		
        		MultiStatus mStatus = new MultiStatus(this.toString(), IStatus.OK, Messages.getString("message.notify.26", args), null);
        		IStatus status = null;
        		
        		while(itr.hasNext()){
        			notifyGroupId = itr.next();
        			strings = notifyGroupId.split("-");
        			
        			// HinemosModuleConstantに定義されている場合
        			if(HinemosModuleConstant.isExist(strings[0]) &&
        					!strings[0].equals(HinemosModuleConstant.JOB_SESSION)){	// JobSessionIDを除外
        			
        				// 監視の種別を出力（監視の種類が同じである場合は、出力しない）
	        			if(!moduleName.equals(strings[0])) {
	        				
	        				// 最初の一回目を除外する
	        				if(!moduleName.equals("")){
		        				status = new Status(IStatus.INFO, id, IStatus.OK, "", null);
		            			mStatus.add(status);
	        				}
	        				
	            			moduleName = strings[0];
	            			message = "[" + HinemosModuleConstant.nameToString(moduleName) + "]";
	            			checkList.clear();
	            			
	            			status = new Status(IStatus.INFO, id, IStatus.OK, message, null);
	            			mStatus.add(status);
	        			}
	        			
	        			// 監視項目IDを出力	            				
	        			String monitorId = strings[1];
	        			for(int i = 2; i < strings.length - 1 ; i++){	// stringsの最後には、文字列監視用のindexが含まれているため除外
	        				monitorId = monitorId + "-" + strings[i];
	        			}
	        			
	        			if(!checkList.contains(monitorId)){
	        				checkList.add(monitorId);
	        				
	//	        			message = "  " + strings[1];
		        			message = "  " + monitorId;
	            			status = new Status(IStatus.INFO, id, IStatus.OK, message, null);
	            			mStatus.add(status);
	        			}
	        		}
        			
        		}

        		// どの監視機能で使用されているかをダイアログで表示する
        		result = ErrorDialog.openError(
            			null, 
            			Messages.getString("info"),
            			null,
            			mStatus);
        	}
        } catch (RemoteException e) {
			if(e instanceof AccessException){
				// アクセス権なしの場合、エラーダイアログを表示する
	            MessageDialog.openInformation(null, Messages.getString("message"),
	                    Messages.getString("message.accesscontrol.16"));
			}
        } catch (NotifyNotFoundException e) {
        } catch (HinemosUnknownException e) {
        }
        
        return result;
    }
    
}