/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.monitor.dialog;

import java.util.List;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

import com.clustercontrol.bean.Property;
import com.clustercontrol.composite.PropertySheet;
import com.clustercontrol.dialog.CommonDialog;
import com.clustercontrol.monitor.action.GetEventInfoProperty;
import com.clustercontrol.util.Messages;

/**
 * 監視[イベントの詳細]ダイアログクラス<BR>
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class EventInfoDialog extends CommonDialog {

    /** 選択されたアイテム。 */
    private List m_list = null;
    
    /** プロパティシート。 */
    private PropertySheet propertySheet = null;

    /**
     * インスタンスを返します。
     * 
     * @param parent 親のシェルオブジェクト
     */
    public EventInfoDialog(Shell parent, List list) {
        super(parent);
        setShellStyle(getShellStyle() | SWT.RESIZE | SWT.MAX);
        m_list = list;
    }

    /**
     * ダイアログの初期サイズを返します。
     * 
     * @return 初期サイズ
     */
    @Override
	protected Point getInitialSize() {
        return new Point(500, 500);
    }

    /**
     * ダイアログエリアを生成します。
     * 
     * @param parent 親のコンポジット
     * 
     * @see com.clustercontrol.monitor.action.GetEventInfoProperty#getProperty(List)
     */
    @Override
	protected void customizeDialog(Composite parent) {
        Shell shell = this.getShell();

        // タイトル
        shell.setText(Messages.getString("dialog.monitor.info.events"));

        // レイアウト
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        parent.setLayout(layout);

        /*
         * 属性プロパティシート
         */
        
        // ラベル
        Label label = new Label(parent, SWT.LEFT);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        label.setLayoutData(gridData);
        label.setText(Messages.getString("attribute") + " : ");

        // プロパティシート
        TableTree table = new TableTree(parent, SWT.H_SCROLL | SWT.V_SCROLL
                | SWT.FULL_SELECTION | SWT.SINGLE | SWT.BORDER);
        
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.verticalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 1;
        table.setLayoutData(gridData);

        this.propertySheet = new PropertySheet(table);

        // プロパティ取得及び設定
        Property property = new GetEventInfoProperty().getProperty(m_list);
        this.propertySheet.setInput(property);

        // ラインを引く
        Label line = new Label(parent, SWT.SEPARATOR | SWT.HORIZONTAL);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        line.setLayoutData(gridData);

        // 画面中央に
        Display display = shell.getDisplay();
        shell.setLocation((display.getBounds().width - shell.getSize().x) / 2,
                (display.getBounds().height - shell.getSize().y) / 2);
    }
    
    /**
     * 入力値を保持したプロパティを返します。<BR>
     * プロパティシートよりプロパティを取得します。
     * 
     * @return プロパティ
     * 
     * @see com.clustercontrol.composite.PropertySheet#getInput()
     */
    public Property getInputData() {
        return (Property) this.propertySheet.getInput();
    }

    /**
     * 入力値を保持したプロパティを設定します。
     * 
     * @param property プロパティ
     */
    public void setInputData(Property property) {
        propertySheet.setInput(property);
    }
    
    /**
     * 閉じるボタンを作成します。
     * 
     * @param parent 親のコンポジット（ボタンバー）
     */
    @Override
	protected void createButtonsForButtonBar(Composite parent) {
    	
        // 閉じるボタン
        this.createButton(parent, IDialogConstants.CANCEL_ID, Messages.getString("ok"), false);
    }
}