/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.monitor.action;

import java.util.ArrayList;
import java.util.Locale;

import org.eclipse.swt.SWT;

import com.clustercontrol.bean.TableColumnInfo;
import com.clustercontrol.monitor.bean.EventTableDefine;
import com.clustercontrol.util.Messages;

/**
 * 監視[イベント]ビューのテーブル定義を取得するクライアント側アクションクラス<BR>
 * 
 * マネージャにSessionBean経由でアクセスし、テーブル定義を取得します。
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class GetEventListTableDefine {

	/**
	 * 監視[イベント]ビューのテーブル定義情報を取得します。<BR><BR>
	 * リストに、カラム毎にテーブルカラム情報をセットします。
	 * 
	 * @return テーブル定義情報（{@link com.clustercontrol.bean.TableColumnInfo}のリスト）
	 * 
	 * @see com.clustercontrol.bean.TableColumnInfo#TableColumnInfo(java.lang.String, int, int, int)
	 * @see com.clustercontrol.monitor.bean.EventTableDefine
	 */
	@SuppressWarnings("unchecked")
	public static ArrayList getEventListTableDefine() {
		
		Locale locale = Locale.getDefault();
		
		/** テーブル情報定義配列 */
		ArrayList tableDefine = new ArrayList();

		tableDefine.add(EventTableDefine.PRIORITY, 
				new TableColumnInfo(Messages.getString("priority", locale), TableColumnInfo.PRIORITY, 70, SWT.LEFT));
		tableDefine.add(EventTableDefine.RECEIVE_TIME, 
				new TableColumnInfo(Messages.getString("receive.time", locale), TableColumnInfo.NONE, 150, SWT.LEFT));
		tableDefine.add(EventTableDefine.OUTPUT_DATE, 
				new TableColumnInfo(Messages.getString("output.time", locale), TableColumnInfo.NONE, 150, SWT.LEFT));
		tableDefine.add(EventTableDefine.PLUGIN_ID, 
				new TableColumnInfo(Messages.getString("plugin.id", locale), TableColumnInfo.NONE, 100, SWT.LEFT));
		tableDefine.add(EventTableDefine.MONITOR_ID, 
				new TableColumnInfo(Messages.getString("monitor.id", locale), TableColumnInfo.NONE, 100, SWT.LEFT));
		tableDefine.add(EventTableDefine.FACILITY_ID, 
				new TableColumnInfo(Messages.getString("facility.id", locale), TableColumnInfo.NONE, 100, SWT.LEFT));
		tableDefine.add(EventTableDefine.SCOPE, 
				new TableColumnInfo(Messages.getString("scope", locale), TableColumnInfo.FACILITY, 150, SWT.LEFT));
		tableDefine.add(EventTableDefine.APPLICATION, 
				new TableColumnInfo(Messages.getString("application", locale), TableColumnInfo.NONE, 100, SWT.LEFT));
		tableDefine.add(EventTableDefine.MESSAGE_ID, 
				new TableColumnInfo(Messages.getString("message.id", locale), TableColumnInfo.NONE, 200, SWT.LEFT));
		tableDefine.add(EventTableDefine.MESSAGE,
				new TableColumnInfo(Messages.getString("message", locale), TableColumnInfo.NONE, 200, SWT.LEFT));
		tableDefine.add(EventTableDefine.CONFIRMED, 
				new TableColumnInfo(Messages.getString("confirmed", locale), TableColumnInfo.CONFIRM, 50, SWT.LEFT));
		tableDefine.add(EventTableDefine.CONFIRM_USER, 
				new TableColumnInfo(Messages.getString("confirm.user", locale), TableColumnInfo.NONE, 100, SWT.LEFT));

		return tableDefine;
	}
    
}