/*
 
Copyright (C) 2007 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.maintenance.composite;

import java.util.ArrayList;

import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

import com.clustercontrol.maintenance.action.GetMaintenance;
import com.clustercontrol.maintenance.bean.MaintenanceKeepMstConstant;
import com.clustercontrol.util.Messages;


/**
 * 履歴保存期間指定コンポジットクラスです。
 * 
 * @version 2.2.0
 * @since 2.2.0
 */
public class MaintenanceKeepListComposite extends Composite {

    // ----- instance フィールド ----- //

    /** 履歴保存期間ラベル */
	private Label labelMaintenanceKeep = null;
	
    /** 履歴保存期間指定コンボボックス */
    private Combo comboMaintenanceKeep = null;

    /** メンテナンス期間一覧リスト */
    ArrayList maintenanceKeepList = null;
    
    // ----- コンストラクタ ----- //

    /**
     * インスタンスを返します。
     * 
     * @param parent 親のコンポジット
     * @param style スタイル
     * @param labelFlg メンテナンス種別ラベル表示フラグ
     */
    public MaintenanceKeepListComposite(Composite parent, int style, boolean labelFlg) {
        super(parent, style);
        
        this.initialize(parent, labelFlg);
    }
    

    // ----- instance メソッド ----- //

    /**
     * コンポジットを生成・構築します。
     */
    private void initialize(Composite parent, boolean labelFlg) {
    	
        // 変数として利用されるグリッドデータ
        GridData gridData = null;
        
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        if(labelFlg){
        	layout.numColumns = 15;	
        }
        else{
        	layout.numColumns = 10;
        }
        this.setLayout(layout);
        
        /*
         * メンテナンス種別
         */
        if(labelFlg){
            // ラベル
            this.labelMaintenanceKeep = new Label(this, SWT.NONE);
            gridData = new GridData();
            gridData.horizontalSpan = 5;
            gridData.horizontalAlignment = GridData.FILL;
            gridData.grabExcessHorizontalSpace = true;
            this.labelMaintenanceKeep.setLayoutData(gridData);
            this.labelMaintenanceKeep.setText(Messages.getString("maintenance.keep") + " : ");
        }
        
        // コンボボックス
        this.comboMaintenanceKeep = new Combo(this, SWT.DROP_DOWN | SWT.READ_ONLY);
        gridData = new GridData();
        gridData.horizontalSpan = 5;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        this.comboMaintenanceKeep.setLayoutData(gridData);
                
        this.update();
    }

    /**
     * コンポジットを更新します。
     * <p>
     * 
     */
    @Override
	public void update() {
    	
    	// データ取得
    	if(maintenanceKeepList == null){
    		getMaintenanceKeepList();
    	}
    	
        // 種別リスト
    	ArrayList maintenanceKeep = null;
        for(int index=0; index<maintenanceKeepList.size(); index++){
        	maintenanceKeep = (ArrayList)maintenanceKeepList.get(index);
        	this.comboMaintenanceKeep.add(Messages.getString((String)maintenanceKeep.get(MaintenanceKeepMstConstant.NAME_ID)));
        }
    }
    
    /**
     * メンテナンス期間のプルダウンメニューより選択された期間の選択番号を取得
     * @return
     */
    public int getSelectionIndex(){
    	return comboMaintenanceKeep.getSelectionIndex();
    }
    
    /**
     * メンテナンス期間のプルダウンメニューより選択された期間の取得
     * @param index
     * @return
     */
    public String getSelectionKeepId(){
    	String keepId = null;
    	
    	// データ取得
        if(maintenanceKeepList == null){
        	getMaintenanceKeepList();
        }
        int index = getSelectionIndex();
        if(index >= 0){
        	ArrayList maintenanceKeep = (ArrayList) maintenanceKeepList.get(index);
        	keepId = (String)maintenanceKeep.get(MaintenanceKeepMstConstant.KEEP_ID);
        }else{
        	keepId = "";//何も選択されていない=空文字列
        }
        	
    	return keepId;
    }
    
    /**
     * メンテナンス期間IDよりメンテナンス期間名の取得
     * @param keep_id
     * @return
     */
    public String getMaintenanceKeepName(String keep_id){
    	String name = null;
    	
    	// データ取得
        if(maintenanceKeepList == null){
        	getMaintenanceKeepList();
        }

        // メンテナンス種別IDよりメンテナンス種別名を取得
    	ArrayList maintenanceKeep = null;
        for(int index=0; index<maintenanceKeepList.size(); index++){
        	maintenanceKeep = (ArrayList)maintenanceKeepList.get(index);
        	if(((String)maintenanceKeep.get(MaintenanceKeepMstConstant.KEEP_ID)).equals(keep_id)){
        		name = Messages.getString((String)maintenanceKeep.get(MaintenanceKeepMstConstant.NAME_ID));
        		break;
        	}
        }
    	return name;

    }
    /**
     * メンテナンス期間一覧の取得
     */
    private void getMaintenanceKeepList(){
        maintenanceKeepList = new GetMaintenance().getMaintenanceKeepList();
    }
    
	/* (非 Javadoc)
	 * @see org.eclipse.swt.widgets.Control#setEnabled(boolean)
	 */
	@Override
	public void setEnabled(boolean enabled) {
		this.comboMaintenanceKeep.setEnabled(enabled);
	}

	/* (非 Javadoc)
	 * @see org.eclipse.swt.widgets.Combo#getText()
	 */
	public String getText() {
		return this.comboMaintenanceKeep.getText();
	}

	/* (非 Javadoc)
	 * @see org.eclipse.swt.widgets.Combo#setText(java.lang.String)
	 */
	public void setText(String string) {
		this.comboMaintenanceKeep.setText(string);
	}
}