/*
 
Copyright (C) 2007 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.maintenance.action;

import java.rmi.AccessException;
import java.rmi.RemoteException;
import java.text.ParseException;

import javax.ejb.CreateException;
import javax.ejb.DuplicateKeyException;
import javax.naming.NamingException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;

import org.eclipse.jface.dialogs.MessageDialog;
import org.quartz.SchedulerException;

import com.clustercontrol.HinemosUnknownException;
import com.clustercontrol.maintenance.bean.ScheduleInfo;
import com.clustercontrol.maintenance.bean.MaintenanceInfoDataImp;
import com.clustercontrol.maintenance.ejb.session.MaintenanceController;
import com.clustercontrol.maintenance.util.EjbConnectionManager;
import com.clustercontrol.util.Messages;

/**
 * 
 * メンテナンス情報を登録するクライアント側アクションクラス<BR>
 * 
 * @version 3.0.0
 * @since 2.2.0
 * 
 */
public class AddMaintenance {
	
	public boolean add(MaintenanceInfoDataImp data, ScheduleInfo schedule) {
		boolean ret = false;
		
		MaintenanceController controller = EjbConnectionManager.getConnectionManager().getMaintenanceController();
		
        String[] args = { data.getMaintenance_id() };
		try {
			controller.addMaintenance(data, schedule);
			ret = true;
		} catch (RemoteException e) {
			if(e instanceof AccessException){
				// アクセス権なしの場合、エラーダイアログを表示する
	            MessageDialog.openInformation(null, Messages.getString("message"),
	                    Messages.getString("message.accesscontrol.16"));
			}
		} catch (CreateException e) {
			if(e instanceof DuplicateKeyException){
				// メンテナンスIDが重複している場合、エラーダイアログを表示する
	            MessageDialog.openInformation(
	            		null, 
	            		Messages.getString("message"),
	                    Messages.getString("message.maintenance.11", args));
	            return ret;
			}
		} catch (NamingException e) {
		} catch (IllegalStateException e) {
		} catch (SystemException e) {
		} catch (NotSupportedException e) {
		} catch (RollbackException e) {
		} catch (HeuristicMixedException e) {
		} catch (HeuristicRollbackException e) {
		} catch (SchedulerException e) {
		} catch (ParseException e) {
		} catch (HinemosUnknownException e) {
		}
		
		if(ret){
        	MessageDialog.openInformation(
        			null, 
        			Messages.getString("successful"), 
        			Messages.getString("message.maintenance.1", args));
		}
		else{
        	MessageDialog.openError(
        			null, 
        			Messages.getString("failed"), 
        			Messages.getString("message.maintenance.2", args));
		}
    	
    	return ret;
	}
	
}
