/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.logtransfer.composite;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;

import com.clustercontrol.composite.CommonTableViewer;
import com.clustercontrol.logtransfer.action.GetLogTransfer;
import com.clustercontrol.logtransfer.action.GetLogTransferListTableDefine;
import com.clustercontrol.logtransfer.bean.LogTransferTabelDefine;
;

/**
 * ログ転送一覧コンポジットクラス<BR>
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public class LogTransferListComposite extends Composite {
	
	// ----- instance フィールド ----- //
	
	/** テーブルビューア */
	private CommonTableViewer tableViewer = null;
	
	// ----- コンストラクタ ----- //
	
	/**
	 * インスタンスを返します。
	 * 
	 * @param parent 親のコンポジット
	 * @param style スタイル
	 */
	public LogTransferListComposite(Composite parent, int style) {
		super(parent, style);
		
		this.initialize();
	}
	
	// ----- instance メソッド ----- //
	
	/**
	 * コンポジットを生成・構築します。
	 */
	private void initialize() {
		GridLayout layout = new GridLayout(1, true);
		this.setLayout(layout);
		layout.marginHeight = 0;
		layout.marginWidth = 0;
		
		Table table = new Table(this, SWT.MULTI | SWT.H_SCROLL | SWT.V_SCROLL | SWT.FULL_SELECTION);
		table.setHeaderVisible(true);
		table.setLinesVisible(true);
		
		GridData gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.verticalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		gridData.grabExcessVerticalSpace = true;
		table.setLayoutData(gridData);
		
		// テーブルビューアの作成
		this.tableViewer = new CommonTableViewer(table);
		this.tableViewer.createTableColumn(GetLogTransferListTableDefine.get(),
				LogTransferTabelDefine.SORT_COLUMN_INDEX,
				LogTransferTabelDefine.SORT_ORDER);
		
		gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.verticalAlignment = GridData.FILL;
		
		this.update();
	}
	
	/**
	 * tableViewerを返します。
	 * 
	 * @return tableViewer
	 */
	public CommonTableViewer getTableViewer() {
		return this.tableViewer;
	}
	
	/**
	 * コンポジットを更新します。
	 * <p>
	 * 
	 */
	@Override
	public void update() {
		// データ取得
		ArrayList list = new GetLogTransfer().getLogTransferList();
		
		if(list == null)
			list = new ArrayList();
		
		// テーブル更新
		this.tableViewer.setInput(list);
	}
	
	/**
     * 選択された行の監視項目IDを取得する
     * 
     * @return 
     */
    public ArrayList<String> getSelectionData() {
    	
    	ArrayList<String> data = new ArrayList<String>();
    	
    	//選択されたアイテムを取得
    	StructuredSelection selection = 
    		(StructuredSelection)tableViewer.getSelection();
    	List list = selection.toList();
    	
    	if (list != null) {
    		for(int index = 0; index < list.size(); index++){
    			
    			ArrayList info = (ArrayList)list.get(index);
    			if (info != null && info.size() > 0) {
    				String transferId = (String)info.get(LogTransferTabelDefine.TRANSFER_ID);
    				data.add(transferId);
    			}
    		}
    	}
    	
    	return data;
    }
}