/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.view.action;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;

import com.clustercontrol.jobmanagement.action.GetJobOperationProperty;
import com.clustercontrol.jobmanagement.action.OperationJob;
import com.clustercontrol.jobmanagement.composite.DetailComposite;
import com.clustercontrol.jobmanagement.composite.HistoryComposite;
import com.clustercontrol.jobmanagement.composite.NodeDetailComposite;
import com.clustercontrol.jobmanagement.dialog.JobOperationDialog;
import com.clustercontrol.jobmanagement.view.JobDetailView;
import com.clustercontrol.jobmanagement.view.JobHistoryView;
import com.clustercontrol.jobmanagement.view.JobNodeDetailView;
import com.clustercontrol.util.Messages;

/**
 * ジョブ[履歴]・ジョブ[ジョブ詳細]・ジョブ[ノード詳細]ビューの「開始」のクライアント側アクションクラス<BR>
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class StartJobAction implements IViewActionDelegate {
	/** アクションID */
    public static final String ID = "com.clustercontrol.jobmanagement.view.action.StartJobAction";
    /** ビュー */
    protected IViewPart m_view;

    /**
     * ビューを保持します。ワークベンチにロードされた際に呼ばれます。
     * 
     * @param view ビューのインスタンス
     * 
     * @see org.eclipse.ui.IViewActionDelegate#init(org.eclipse.ui.IViewPart)
     */
    public void init(IViewPart view) {
        m_view = view;
    }

    /**
     * ジョブ[履歴]・ジョブ[ジョブ詳細]・ジョブ[ノード詳細]ビューの「開始」が押された場合に、ジョブの開始操作を行います。
     * <p>
	 * <ol>
	 * <li>ジョブ[履歴]・ジョブ[ジョブ詳細]ビューの場合、ビューからセッションID・ジョブIDを取得します。</li>
	 * <li>ジョブ[ノード詳細]ビューの場合、ビューから、セッションID・ジョブID・ファシリティIDを取得します。</li>
	 * <li>ジョブ開始操作用プロパティを取得します。</li>
	 * <li>ジョブ[開始]ダイアログを表示します。</li>
	 * <li>ジョブ[開始]ダイアログからジョブ開始操作用プロパティを取得します。</li>
	 * <li>ジョブ開始操作用プロパティを元にジョブ開始操作を行います。</li>
	 * </ol>
     * 
     * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
     * @see com.clustercontrol.jobmanagement.view.JobHistoryView
     * @see com.clustercontrol.jobmanagement.view.JobDetailView
     * @see com.clustercontrol.jobmanagement.view.JobNodeDetailView
     * @see com.clustercontrol.jobmanagement.dialog.JobOperationDialog
     * @see com.clustercontrol.jobmanagement.action.GetJobOperationProperty#getStartProperty(String, String, String)
     * @see com.clustercontrol.jobmanagement.action.OperationJob#operationJob(Property)
     */
    public void run(IAction action) {
        String sessionId = null;
        String jobunitId = null;
        String jobId = null;
        String facilityId = null;

        if (m_view instanceof JobHistoryView) { // ボタンが押された場合
            JobHistoryView view = (JobHistoryView) m_view
                    .getAdapter(JobHistoryView.class);
            HistoryComposite historyComposite = view.getComposite();
            //セッションID取得
            sessionId = historyComposite.getSessionId();
            //ジョブユニットID取得
            jobunitId = historyComposite.getJobunitId();
            //ジョブID取得
            jobId = historyComposite.getJobId();
        } else if (m_view instanceof JobDetailView) { // ボタンが押された場合
            JobDetailView view = (JobDetailView) m_view
                    .getAdapter(JobDetailView.class);
            DetailComposite detailComposite = view.getComposite();
            //セッションID取得
            sessionId = detailComposite.getSessionId();
            //ジョブユニットID取得
            jobunitId = detailComposite.getJobunitId();
            //ジョブID取得
            jobId = detailComposite.getJobId();
        } else if (m_view instanceof JobNodeDetailView) { // ボタンが押された場合
            JobNodeDetailView view = (JobNodeDetailView) m_view
                    .getAdapter(JobNodeDetailView.class);
            NodeDetailComposite nodeDetailComposite = view.getComposite();
            //セッションID取得
            sessionId = nodeDetailComposite.getSessionId();
            //ジョブユニットID取得
            jobunitId = nodeDetailComposite.getJobunitId();
            //ジョブID取得
            jobId = nodeDetailComposite.getJobId();
            //ファシリティID取得
            facilityId = nodeDetailComposite.getFacilityId();
            if (facilityId == null) {
                sessionId = null;
                jobunitId = null;
                jobId = null;
            }
        }

        if (sessionId != null && sessionId.length() > 0 && jobunitId != null
				&& jobunitId.length() > 0 && jobId != null
				&& jobId.length() > 0) {

            JobOperationDialog dialog = new JobOperationDialog(PlatformUI
                    .getWorkbench().getActiveWorkbenchWindow().getShell());

            //プロパティ設定
            dialog.setProperty(new GetJobOperationProperty().getStartProperty(
                    sessionId, jobunitId, jobId, facilityId));
            dialog.setTitleText(Messages.getString("job") + "["
                    + Messages.getString("start") + "]");

            //ダイアログ表示
            if (dialog.open() == IDialogConstants.OK_ID) {
                //ジョブ開始
                OperationJob operation = new OperationJob();
                operation.operationJob(dialog.getProperty());
            }
        }
    }

    /* (non-Javadoc)
     * @see org.eclipse.ui.IActionDelegate#selectionChanged(org.eclipse.jface.action.IAction, org.eclipse.jface.viewers.ISelection)
     */
    public void selectionChanged(IAction action, ISelection selection) {

    }
}