/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.dialog;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;

import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

import com.clustercontrol.bean.JudgmentObjectConstant;
import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.PropertyConstant;
import com.clustercontrol.composite.PropertySheet;
import com.clustercontrol.dialog.CommonDialog;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.jobmanagement.action.WaitRuleProperty;
import com.clustercontrol.jobmanagement.bean.JobTreeItem;
import com.clustercontrol.jobmanagement.bean.WaitRuleTableDefine;
import com.clustercontrol.util.Messages;
import com.clustercontrol.util.PropertyUtil;

/**
 * ジョブ開始条件ダイアログクラス
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class WaitRuleDialog extends CommonDialog {
    /** プロパティシート */
    protected PropertySheet m_viewer = null;
    
    /** ダイアログのサイズの初期値 */
//    private final int sizeX = 500;
    private final int sizeY = 400;
    
    /** シェル */
    private Shell m_shell = null;
    /** 判定対象情報 */
    private ArrayList m_startCondition = null;
    /** 親ジョブID */
    private String m_parentJobId = null;
    /** ジョブID */
    private String m_jobId = null;
    /** ジョブユニットのジョブID */
    private String m_jobunitId = null;
    

    /**
     * コンストラクタ
     * 
     * @param parent 親シェル
     * @param parentJobId 親ジョブID
     * @param jobId ジョブID
     */
    public WaitRuleDialog(Shell parent, String parentJobId, String jobId, String jobunitId) {
        super(parent);
        m_parentJobId = parentJobId;
        m_jobId = jobId;
        m_jobunitId = jobunitId;
    }

    /**
     * ダイアログエリアを生成します。
     * 
     * @param parent 親コンポジット
     * 
     * @see com.clustercontrol.jobmanagement.action.WaitRuleProperty#getProperty(String, String, int)
     * @see com.clustercontrol.bean.JudgmentObjectConstant
     */
    @Override
	protected void customizeDialog(Composite parent) {
        m_shell = this.getShell();

        parent.getShell().setText(Messages.getString("wait.rule"));

        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        parent.setLayout(layout);

        Label tableTitle = new Label(parent, SWT.NONE);
        tableTitle.setText(Messages.getString("attribute") + " : ");
        GridData gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        tableTitle.setLayoutData(gridData);

        TableTree table = new TableTree(parent, SWT.BORDER | SWT.H_SCROLL
                | SWT.V_SCROLL | SWT.FULL_SELECTION | SWT.MULTI);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.verticalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 1;
        table.setLayoutData(gridData);

        m_viewer = new PropertySheet(table);

        m_viewer.setInput(new WaitRuleProperty().getProperty(m_parentJobId, m_jobId, m_jobunitId, JudgmentObjectConstant.TYPE_JOB_END_STAUS));

        Label line = new Label(parent, SWT.SEPARATOR | SWT.HORIZONTAL);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        line.setLayoutData(gridData);

        // 画面中央に
        Display display = m_shell.getDisplay();
        m_shell.setLocation(
                (display.getBounds().width - m_shell.getSize().x) / 2, (display
                        .getBounds().height - m_shell.getSize().y) / 2);
        
        //ダイアログのサイズ調整（pack:resize to be its preferred size）
        m_shell.pack();
        m_shell.setSize(new Point(m_shell.getSize().x, sizeY ));

        //開始条件反映
        reflectStartCondition();

        m_viewer.expandAll();
    }

    /**
     * 判定対象情報をプロパティシートに反映します。
     * 
     * @see com.clustercontrol.jobmanagement.action.WaitRuleProperty
     * @see com.clustercontrol.jobmanagement.action.WaitRuleProperty#getProperty(String, String, int)
     * @see com.clustercontrol.bean.JudgmentObjectConstant
     * @see com.clustercontrol.util.PropertyUtil
     */
    private void reflectStartCondition() {
        Property property = null;

        if (m_startCondition instanceof ArrayList) {
            //判定対象を設定
            Integer type = (Integer) m_startCondition
                    .get(WaitRuleTableDefine.JUDGMENT_OBJECT);

            if (type.intValue() == JudgmentObjectConstant.TYPE_JOB_END_STAUS) {
                //判定対象がジョブの場合
                property = new WaitRuleProperty().getProperty(m_parentJobId, m_jobId, m_jobunitId, JudgmentObjectConstant.TYPE_JOB_END_STAUS);
                ArrayList propertyList = PropertyUtil.getProperty(property,
                        WaitRuleProperty.ID_JUDGMENT_OBJECT);
                Property judgmentObject = (Property) propertyList.get(0);
                Object values[][] = judgmentObject.getSelectValues();
                judgmentObject.setValue(JudgmentObjectConstant.STRING_JOB_END_STAUS);

                HashMap map = (HashMap) values[PropertyConstant.SELECT_VALUE][JudgmentObjectConstant.TYPE_JOB_END_STAUS];
                ArrayList list = (ArrayList) map.get("property");

                //ジョブIDを設定
                String jobId = (String) m_startCondition
                        .get(WaitRuleTableDefine.JOB_ID);
                ((Property) list.get(0)).setValue(jobId);

                //条件値
                String value = (String) m_startCondition
                        .get(WaitRuleTableDefine.START_VALUE);
                ((Property) list.get(1)).setValue(value);
            }
            else if (type.intValue() == JudgmentObjectConstant.TYPE_JOB_END_VALUE) {
                //判定対象がジョブの場合
                property = new WaitRuleProperty().getProperty(m_parentJobId, m_jobId, m_jobunitId, JudgmentObjectConstant.TYPE_JOB_END_VALUE);
                ArrayList propertyList = PropertyUtil.getProperty(property,
                        WaitRuleProperty.ID_JUDGMENT_OBJECT);
                Property judgmentObject = (Property) propertyList.get(0);
                Object values[][] = judgmentObject.getSelectValues();
                judgmentObject.setValue(JudgmentObjectConstant.STRING_JOB_END_VALUE);

                HashMap map = (HashMap) values[PropertyConstant.SELECT_VALUE][JudgmentObjectConstant.TYPE_JOB_END_VALUE];
                ArrayList list = (ArrayList) map.get("property");

                //ジョブIDを設定
                String jobId = (String) m_startCondition
                        .get(WaitRuleTableDefine.JOB_ID);
                ((Property) list.get(0)).setValue(jobId);

                //条件値
                Integer value = (Integer) m_startCondition
                        .get(WaitRuleTableDefine.START_VALUE);
                ((Property) list.get(1)).setValue(value);
            }
            else {
                //判定対象が時刻の場合
                property = new WaitRuleProperty().getProperty(m_parentJobId, m_jobId, m_jobunitId, JudgmentObjectConstant.TYPE_TIME);
                ArrayList propertyList = PropertyUtil.getProperty(property,
                        WaitRuleProperty.ID_JUDGMENT_OBJECT);
                Property judgmentObject = (Property) propertyList.get(0);
                Object values[][] = judgmentObject.getSelectValues();
                judgmentObject.setValue(JudgmentObjectConstant.STRING_TIME);

                HashMap map = (HashMap) values[PropertyConstant.SELECT_VALUE][JudgmentObjectConstant.TYPE_TIME];
                ArrayList list = (ArrayList) map.get("property");

                //開始時刻
                Date time = (Date) m_startCondition
                        .get(WaitRuleTableDefine.START_VALUE);
                ((Property) list.get(0)).setValue(time);
            }
            m_viewer.setInput(property);

            //ビュー更新
            m_viewer.refresh();
        }
    }

    /**
     * ダイアログの情報から判定対象情報を作成します。
     * 
     * @see com.clustercontrol.jobmanagement.action.WaitRuleProperty
     * @see com.clustercontrol.bean.JudgmentObjectConstant
     * @see com.clustercontrol.util.PropertyUtil
     */
    @SuppressWarnings("unchecked")
	private ValidateResult createStartCondition() {
        ValidateResult result = null;

        m_startCondition = new ArrayList();

        Property property = (Property) m_viewer.getInput();

        //判定対象を取得
        ArrayList values = PropertyUtil.getPropertyValue(property,
                WaitRuleProperty.ID_JUDGMENT_OBJECT);
        String type = (String) values.get(0);
        m_startCondition.add(new Integer(JudgmentObjectConstant
                .stringToType(type)));

        if (type.equals(JudgmentObjectConstant.STRING_JOB_END_STAUS)) {
            //ジョブID
            String jobId = "";
            values = PropertyUtil.getPropertyValue(property,
                    WaitRuleProperty.ID_JOB_ID);
            if (values.get(0) instanceof JobTreeItem) {
                JobTreeItem item = (JobTreeItem) values.get(0);
                jobId = item.getData().getId();
            } else if (values.get(0) instanceof String) {
                jobId = (String) values.get(0);
            }
            if (jobId == null || jobId.length() == 0) {
                result = new ValidateResult();
                result.setValid(false);
                result.setID(Messages.getString("message.hinemos.1"));
                result.setMessage(Messages.getString("message.job.22"));
                return result;
            }
            m_startCondition.add(jobId);

            //条件値
            values = PropertyUtil.getPropertyValue(property,
                    WaitRuleProperty.ID_CONDITION_END_STATUS);
            String value = (String) values.get(0);
            if (value == null || value.length() == 0) {
                result = new ValidateResult();
                result.setValid(false);
                result.setID(Messages.getString("message.hinemos.1"));
                result.setMessage(Messages.getString("message.job.17"));
                return result;
            }
            m_startCondition.add(value);
        }
        else if (type.equals(JudgmentObjectConstant.STRING_JOB_END_VALUE)) {
            //ジョブID
            String jobId = "";
            values = PropertyUtil.getPropertyValue(property,
                    WaitRuleProperty.ID_JOB_ID);
            if (values.get(0) instanceof JobTreeItem) {
                JobTreeItem item = (JobTreeItem) values.get(0);
                jobId = item.getData().getId();
            } else if (values.get(0) instanceof String) {
                jobId = (String) values.get(0);
            }
            if (jobId == null || jobId.length() == 0) {
                result = new ValidateResult();
                result.setValid(false);
                result.setID(Messages.getString("message.hinemos.1"));
                result.setMessage(Messages.getString("message.job.22"));
                return result;
            }
            m_startCondition.add(jobId);

            //条件値
            values = PropertyUtil.getPropertyValue(property,
                    WaitRuleProperty.ID_CONDITION_END_VALUE);
            Integer value = (Integer) values.get(0);
            if (value == null ) {
                result = new ValidateResult();
                result.setValid(false);
                result.setID(Messages.getString("message.hinemos.1"));
                result.setMessage(Messages.getString("message.job.17"));
                return result;
            }
            m_startCondition.add(value);
        }
        else {
            //ジョブID
            m_startCondition.add("");

            //開始時刻取得
            values = PropertyUtil.getPropertyValue(property,
                    WaitRuleProperty.ID_TIME);
            Date startTime = null;
            if(values.get(0) instanceof Date)
            	startTime = (Date) values.get(0);
            if (startTime == null) {
                result = new ValidateResult();
                result.setValid(false);
                result.setID(Messages.getString("message.hinemos.1"));
                result.setMessage(Messages.getString("message.job.18"));
                return result;
            }
            m_startCondition.add(startTime);
        }

        return null;
    }

    /**
     * ダイアログの初期サイズを返します。
     * 
     * @return 初期サイズ
     * 
     * @see org.eclipse.jface.window.Window#getInitialSize()
     */
    @Override
	protected Point getInitialSize() {
        return new Point(350, 400);
    }

    /**
     * 判定対象情報を設定する
     * 
     * @param list 判定対象情報
     */
    public void setInputData(ArrayList list) {
        m_startCondition = list;
    }

    /**
     * 入力値を返します。
     * 
     * @return 判定対象情報
     */
    public ArrayList getInputData() {
        return m_startCondition;
    }

    /**
     * ＯＫボタンテキスト取得
     * 
     * @return ＯＫボタンのテキスト
     */
    @Override
	protected String getOkButtonText() {
        return Messages.getString("ok");
    }

    /**
     * キャンセルボタンテキスト取得
     * 
     * @return キャンセルボタンのテキスト
     */
    @Override
	protected String getCancelButtonText() {
        return Messages.getString("cancel");
    }

	/**
	 * 入力値チェックをします。
	 * 
	 * @return 検証結果
	 * 
	 * @see com.clustercontrol.dialog.CommonDialog#validate()
	 */
    @Override
	protected ValidateResult validate() {
        ValidateResult result = null;

        result = createStartCondition();
        if (result != null) {
            return result;
        }

        return null;
    }
}