/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.composite;

import java.util.ArrayList;

import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;

import com.clustercontrol.composite.CommonTableViewer;
import com.clustercontrol.jobmanagement.action.GetSchedule;
import com.clustercontrol.jobmanagement.action.GetScheduleTableDefine;
import com.clustercontrol.jobmanagement.bean.JobSchedule;
import com.clustercontrol.jobmanagement.bean.ScheduleTableDefine;
import com.clustercontrol.jobmanagement.composite.action.ScheduleSelectionChangedListener;

/**
 * ジョブ[スケジュール]ビュー用のコンポジットクラスです。
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class ScheduleListComposite extends Composite {
	/** テーブルビューア */
    protected CommonTableViewer m_viewer = null;
    /** 選択アイテム */
    protected ArrayList m_selectItem = null;

    /**
     * コンストラクタ
     * 
     * @param parent 親のコンポジット
     * @param style スタイル
     * 
     * @see org.eclipse.swt.SWT
     * @see org.eclipse.swt.widgets.Composite#Composite(Composite parent, int style)
     * @see #initialize()
     */
    public ScheduleListComposite(Composite parent, int style) {
        super(parent, style);
        initialize();
    }

    /**
     * コンポジットを構築します。
     */
    private void initialize() {
        GridLayout layout = new GridLayout(1, true);
        this.setLayout(layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;

        Table table = new Table(this, SWT.H_SCROLL | SWT.V_SCROLL
                | SWT.FULL_SELECTION | SWT.SINGLE);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);

        GridData gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.verticalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 1;
        table.setLayoutData(gridData);

        m_viewer = new CommonTableViewer(table);
        m_viewer.createTableColumn(GetScheduleTableDefine.get(),
                ScheduleTableDefine.SORT_COLUMN_INDEX,
                ScheduleTableDefine.SORT_ORDER);

        m_viewer
                .addSelectionChangedListener(new ScheduleSelectionChangedListener(
                        this));
    }

    /**
     * テーブルビューアーを更新します。<BR>
     * スケジュール一覧情報を取得し、共通テーブルビューアーにセットします。
     * <p>
	 * <ol>
	 * <li>スケジュール一覧情報を取得します。</li>
	 * <li>共通テーブルビューアーにスケジュール一覧情報をセットします。</li>
	 * </ol>
     * 
     * @see #getJobSchedule()
     */
    @Override
	public void update() {
        ArrayList<Object> listInput = new ArrayList<Object>();
    	for (JobSchedule schedule : getJobSchedule()) {
    		ArrayList<Object> a = new ArrayList<Object>();
    		a.add(schedule.getId());
    		a.add(schedule.getName());
    		a.add(schedule.getJobId());
    		a.add(schedule.getJobName());
    		a.add(schedule.getJobunitId());
    		a.add(schedule.getCalendarId());
    		a.add(schedule.getSchedule());
    		a.add(schedule.getValid());
    		a.add(schedule.getCreateUser());
    		a.add(schedule.getCreateTime());
    		a.add(schedule.getUpdateUser());
    		a.add(schedule.getUpdateTime());
    		listInput.add(a);
    	}
        m_viewer.setInput(listInput);
    }

    /**
     * スケジュール一覧情報を取得します。
     * 
     * @return スケジュール一覧情報
     * 
     * @see com.clustercontrol.jobmanagement.action.GetSchedule#getSchedule()
     */
    private ArrayList<JobSchedule> getJobSchedule() {
        ArrayList<JobSchedule> JobSchedule = null;

        //スケジュール情報取得
        GetSchedule getSchedule = new GetSchedule();
        JobSchedule = getSchedule.getSchedule();

        return JobSchedule;
    }

    /**
     * このコンポジットが利用するテーブルビューアを返します。
     * 
     * @return テーブルビューア
     */
    public TableViewer getTableViewer() {
        return m_viewer;
    }

    /**
     * このコンポジットが利用するテーブルを返します。
     * 
     * @return テーブル
     */
    public Table getTable() {
        return m_viewer.getTable();
    }

    /**
     * 選択アイテムを返します。
     * 
     * @return 選択アイテム
     */
    public ArrayList getSelectItem() {
        return m_selectItem;
    }

    /**
     * 選択アイテムを設定します。
     * 
     * @param selectItem 選択アイテム
     */
    public void setSelectItem(ArrayList selectItem) {
        this.m_selectItem = selectItem;
    }
}