/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.action;

import java.rmi.AccessException;
import java.rmi.RemoteException;

import org.eclipse.jface.dialogs.MessageDialog;

import com.clustercontrol.HinemosUnknownException;
import com.clustercontrol.JobInfoNotFoundException;
import com.clustercontrol.NotifyNotFoundException;
import com.clustercontrol.jobmanagement.bean.JobTreeItem;
import com.clustercontrol.jobmanagement.ejb.session.JobController;
import com.clustercontrol.jobmanagement.util.EjbConnectionManager;
import com.clustercontrol.util.Messages;

/**
 * セッションジョブ情報を取得するクライアント側アクションクラス<BR>
 * 
 * マネージャにSessionBean経由でアクセスし、<BR>
 * セッションジョブ情報（ジョブツリーアイテム）を取得する
 * 
 * @version 3.0.0
 * @since 2.0.0
 */
public class GetSessionJobInfo {
	
	/**
	 * マネージャにSessionBean経由でアクセスし、<BR>
	 * セッションジョブ情報（ジョブツリーアイテム）を取得する
	 * 
	 * @param sessionId セッションID
	 * @param jobunitId 所属ジョブユニットのジョブID
	 * @param jobId ジョブID
	 * @return セッションジョブ情報（ジョブツリーアイテム）
	 * 
	 * @see com.clustercontrol.jobmanagement.ejb.session.JobController
	 * @see com.clustercontrol.jobmanagement.util.EjbConnectionManager
	 * @see com.clustercontrol.jobmanagement.ejb.session.JobControllerBean#getSessionJobInfo(java.lang.String, java.lang.String)
	 */
	public JobTreeItem getJobTree(String sessionId, String jobunitId, String jobId) {
		JobController job = 
			EjbConnectionManager.getConnectionManager().getJobController();
		
		JobTreeItem item = null;
		try {
			item = job.getSessionJobInfo(sessionId, jobunitId, jobId);
		} catch (RemoteException e) {
			if(e instanceof AccessException){
				// アクセス権なしの場合、エラーダイアログを表示する
				MessageDialog.openInformation(null, Messages.getString("message"),
						Messages.getString("message.accesscontrol.16"));
			}
			e.printStackTrace();
		} catch (HinemosUnknownException e) {
			e.printStackTrace();
		} catch (NotifyNotFoundException e) {
			e.printStackTrace();
		} catch (JobInfoNotFoundException e) {
			e.printStackTrace();
		}
		return item;
	}
}
