/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.action;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

import org.eclipse.swt.SWT;

import com.clustercontrol.bean.TableColumnInfo;
import com.clustercontrol.calendar.bean.ScheduleTableConstant;

/**
 * ジョブ[実行予定]ビューの右側のテーブル定義を取得するクライアント側アクションクラス<BR>
 * 
 * マネージャにSessionBean経由でアクセスし、右側のテーブル定義を取得する
 *
 * @version 2.0.0
 * @since 2.0.0
 */
public class GetRunScheduleTableDefine {
	
	/**
	 * マネージャにSessionBean経由でアクセスし、<BR>
	 * ジョブ[実行予定]ビューの右側のテーブル定義を取得する
	 * 
	 * @return テーブル定義情報（{@link com.clustercontrol.bean.TableColumnInfo}のリスト）
	 */
	public static ArrayList<TableColumnInfo> get(Date base) {
		//テーブル定義配列
		ArrayList<TableColumnInfo> tableDefine = new ArrayList<TableColumnInfo>();
		Locale locale = Locale.getDefault();
		
		tableDefine.add(0, 
				new TableColumnInfo("", TableColumnInfo.NONE, 0, SWT.LEFT));
		for(int i = 0; i < ScheduleTableConstant.DAYS; i++){
			Calendar baseCalendar = Calendar.getInstance();
			baseCalendar.setTime(base);
			baseCalendar.add(Calendar.DAY_OF_MONTH, i);
			Date work = baseCalendar.getTime();
			tableDefine.add(i + 1, 
					new TableColumnInfo(
							DateFormat.getDateInstance(DateFormat.SHORT, locale).format(work), 
							TableColumnInfo.SCHEDULE_ON_OFF, 70, SWT.LEFT));			
		}
		
		return tableDefine;
	}
}
