/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.action;

import java.util.ArrayList;
import java.util.Locale;

import org.eclipse.swt.SWT;

import com.clustercontrol.bean.TableColumnInfo;
import com.clustercontrol.jobmanagement.bean.RunScheduleListTableDefine;
import com.clustercontrol.util.Messages;

/**
 * ジョブ[実行予定]ビューの左側のテーブル定義を取得するクライアント側アクションクラス<BR>
 * 
 * マネージャにSessionBean経由でアクセスし、左側のテーブル定義を取得する
 *
 * @version 2.0.0
 * @since 2.0.0
 */
public class GetRunScheduleListTableDefine {
	
	/**
	 * マネージャにSessionBean経由でアクセスし、<BR>
	 * ジョブ[実行予定]ビューの左側のテーブル定義を取得する
	 * 
	 * @return テーブル定義情報（{@link com.clustercontrol.bean.TableColumnInfo}のリスト）
	 */
	public static ArrayList<TableColumnInfo> get() {
		//テーブル定義配列
		ArrayList<TableColumnInfo> tableDefine = new ArrayList<TableColumnInfo>();
		Locale locale = Locale.getDefault();

		tableDefine.add(RunScheduleListTableDefine.SCHE_ID, 
				new TableColumnInfo(Messages.getString("schedule.id", locale), TableColumnInfo.NONE, 80, SWT.LEFT));
		tableDefine.add(RunScheduleListTableDefine.SCHE_NAME, 
				new TableColumnInfo(Messages.getString("schedule.name", locale), TableColumnInfo.NONE, 150, SWT.LEFT));
		tableDefine.add(RunScheduleListTableDefine.JOB_ID, 
				new TableColumnInfo(Messages.getString("job.id", locale), TableColumnInfo.NONE, 80, SWT.LEFT));
		tableDefine.add(RunScheduleListTableDefine.JOB_NAME, 
				new TableColumnInfo(Messages.getString("job.name", locale), TableColumnInfo.NONE, 150, SWT.LEFT));
		tableDefine.add(RunScheduleListTableDefine.JOBUNIT_ID, 
				new TableColumnInfo(Messages.getString("jobunit.id", locale), TableColumnInfo.NONE, 100, SWT.LEFT));
		tableDefine.add(RunScheduleListTableDefine.CALENDAR_ID, 
				new TableColumnInfo(Messages.getString("calendar.id", locale), TableColumnInfo.NONE, 80, SWT.LEFT));
		tableDefine.add(RunScheduleListTableDefine.CALENDAR_ID + 1, 
				new TableColumnInfo("", TableColumnInfo.CHECKBOX, 0, SWT.LEFT));

		return tableDefine;
	}
}
