/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.action;

import java.util.ArrayList;
import java.util.Locale;

import org.eclipse.swt.SWT;

import com.clustercontrol.bean.TableColumnInfo;
import com.clustercontrol.jobmanagement.bean.HistoryTableDefine;
import com.clustercontrol.util.Messages;

/**
 * ジョブ[履歴]ビューのテーブル定義を取得するクライアント側アクションクラス<BR>
 * 
 * マネージャにSessionBean経由でアクセスし、テーブル定義を取得する
 *
 * @version 1.0.0
 * @since 1.0.0
 */
public class GetHistoryTableDefine {
	
	/**
	 * マネージャにSessionBean経由でアクセスし、<BR>
	 * ジョブ[履歴]ビューのテーブル定義を取得する
	 * 
	 * @return テーブル定義情報（{@link com.clustercontrol.bean.TableColumnInfo}のリスト）
	 */
	public static ArrayList<TableColumnInfo> get() {
		//テーブル定義配列
		ArrayList<TableColumnInfo> tableDefine = new ArrayList<TableColumnInfo>();
		Locale locale = Locale.getDefault();

		tableDefine.add(HistoryTableDefine.STATUS, 
				new TableColumnInfo(Messages.getString("run.status", locale), TableColumnInfo.STATE, 80, SWT.LEFT));
		tableDefine.add(HistoryTableDefine.END_STATUS, 
				new TableColumnInfo(Messages.getString("end.status", locale), TableColumnInfo.END_STATUS, 80, SWT.LEFT));
		tableDefine.add(HistoryTableDefine.END_VALUE, 
				new TableColumnInfo(Messages.getString("end.value", locale), TableColumnInfo.NONE, 50, SWT.LEFT));
		tableDefine.add(HistoryTableDefine.SESSION_ID, 
				new TableColumnInfo(Messages.getString("session.id", locale), TableColumnInfo.NONE, 140, SWT.LEFT));
		tableDefine.add(HistoryTableDefine.JOB_ID, 
				new TableColumnInfo(Messages.getString("job.id", locale), TableColumnInfo.NONE, 100, SWT.LEFT));
		tableDefine.add(HistoryTableDefine.JOB_NAME, 
				new TableColumnInfo(Messages.getString("job.name", locale), TableColumnInfo.NONE, 150, SWT.LEFT));
		tableDefine.add(HistoryTableDefine.JOBUNIT_ID, 
				new TableColumnInfo(Messages.getString("jobunit.id", locale), TableColumnInfo.NONE, 100, SWT.LEFT));
		tableDefine.add(HistoryTableDefine.JOB_TYPE, 
				new TableColumnInfo(Messages.getString("type", locale), TableColumnInfo.JOB, 110, SWT.LEFT));
		tableDefine.add(HistoryTableDefine.FACILITY_ID, 
				new TableColumnInfo(Messages.getString("facility.id", locale), TableColumnInfo.NONE, 100, SWT.LEFT));
		tableDefine.add(HistoryTableDefine.SCOPE, 
				new TableColumnInfo(Messages.getString("scope", locale), TableColumnInfo.FACILITY, 150, SWT.LEFT));
		tableDefine.add(HistoryTableDefine.SCHEDULED_START_TIME, 
				new TableColumnInfo(Messages.getString("scheduled.start.time", locale), TableColumnInfo.NONE, 150, SWT.LEFT));
		tableDefine.add(HistoryTableDefine.START_RERUN_TIME, 
				new TableColumnInfo(Messages.getString("start.rerun.time", locale), TableColumnInfo.NONE, 150, SWT.LEFT));
		tableDefine.add(HistoryTableDefine.END_SUSPEND_TIME, 
				new TableColumnInfo(Messages.getString("end.suspend.time", locale), TableColumnInfo.NONE, 150, SWT.LEFT));
		tableDefine.add(HistoryTableDefine.TRIGGER_TYPE,
				new TableColumnInfo(Messages.getString("trigger.type", locale), TableColumnInfo.NONE, 70, SWT.LEFT));
		tableDefine.add(HistoryTableDefine.TRIGGER_INFO,
				new TableColumnInfo(Messages.getString("trigger.info", locale), TableColumnInfo.NONE, 140, SWT.LEFT));

		return tableDefine;
	}
}
