/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.http.action;

import java.rmi.AccessException;
import java.rmi.RemoteException;
import java.util.ArrayList;

import org.eclipse.jface.dialogs.MessageDialog;

import com.clustercontrol.HinemosUnknownException;
import com.clustercontrol.MonitorNotFoundException;
import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.http.ejb.session.MonitorHttpController;
import com.clustercontrol.http.util.EjbConnectionManager;
import com.clustercontrol.util.Messages;

/**
 * HTTP監視設定情報を取得するクライアント側アクションクラス<BR>
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public class GetHttp {

    /**
     * HTTP監視情報をマネージャから取得します。<BR>
     * 
     * @param monitorId 監視項目ID
     * @return HTTP監視情報
     */
    public MonitorInfo getHttp(String monitorId) {
    	
    	MonitorHttpController http = EjbConnectionManager.getConnectionManager().getHttpController();

    	MonitorInfo info = null;

    	try {
			info = http.getHttpInfo(monitorId);
		} catch (RemoteException e) {
			if(e instanceof AccessException){
				// アクセス権なしの場合、エラーダイアログを表示する
	            MessageDialog.openInformation(null, Messages.getString("message"),
	                    Messages.getString("message.accesscontrol.16"));
			}
		} catch (MonitorNotFoundException e) {
		} catch (HinemosUnknownException e) {
		}

        return info;
    }
    
    /**
     * HTTP監視一覧を返します。
     * 
     * @return HTTP監視一覧
     */
    public ArrayList<MonitorInfo> getHttpList() {
    	
    	MonitorHttpController http = EjbConnectionManager.getConnectionManager().getHttpController();

        ArrayList<MonitorInfo> records = null;
        
        try {
			records = http.getHttpList();
		} catch (RemoteException e) {
			if(e instanceof AccessException){
				// アクセス権なしの場合、エラーダイアログを表示する
	            MessageDialog.openInformation(null, Messages.getString("message"),
	                    Messages.getString("message.accesscontrol.16"));
			}
		} catch (MonitorNotFoundException e) {
		} catch (HinemosUnknownException e) {
		}

        return records;
    }
}