/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.hinemosagent.action;

import java.rmi.AccessException;
import java.rmi.RemoteException;
import java.util.ArrayList;

import org.eclipse.jface.dialogs.MessageDialog;

import com.clustercontrol.HinemosUnknownException;
import com.clustercontrol.MonitorNotFoundException;
import com.clustercontrol.hinemosagent.ejb.session.MonitorAgentController;
import com.clustercontrol.hinemosagent.util.EjbConnectionManager;
import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.util.Messages;

/**
 * Hinemos Agent監視を取得するクラス<BR>
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class GetAgent {

    /**
     * Hinemos Agent監視情報を取得します。<BR>
     * 
     * @param monitorId 状態監視ID
     * @return Hinemos Agent監視情報
     */
    public MonitorInfo getAgent(String monitorId) {
    	
    	MonitorAgentController agent = EjbConnectionManager.getConnectionManager().getAgentController();

    	MonitorInfo info = null;

    	try {
			info = agent.getAgentInfo(monitorId);
		} catch (RemoteException e) {
			if(e instanceof AccessException){
				// アクセス権なしの場合、エラーダイアログを表示する
	            MessageDialog.openInformation(null, Messages.getString("message"),
	                    Messages.getString("message.accesscontrol.16"));
			}
		} catch (MonitorNotFoundException e) {
			e.printStackTrace();
		} catch (HinemosUnknownException e) {
			e.printStackTrace();
		}

        return info;
    }
    
    /**
     * Hinemos Agent監視一覧を返します。
     * 
     * @return Hinemos Agent監視一覧
     */
    public ArrayList<MonitorInfo> getAgentList() {
    	
    	MonitorAgentController agent = EjbConnectionManager.getConnectionManager().getAgentController();

        ArrayList<MonitorInfo> records = null;
        
        try {
			records = agent.getAgentList();
		} catch (RemoteException e) {
			if(e instanceof AccessException){
				// アクセス権なしの場合、エラーダイアログを表示する
	            MessageDialog.openInformation(null, Messages.getString("message"),
	                    Messages.getString("message.accesscontrol.16"));
			}
		} catch (MonitorNotFoundException e) {
		} catch (HinemosUnknownException e) {
		}

        return records;
    }
}