/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.hinemosagent.action;

import java.rmi.AccessException;
import java.rmi.RemoteException;

import org.eclipse.jface.dialogs.MessageDialog;

import com.clustercontrol.HinemosUnknownException;
import com.clustercontrol.MonitorNotFoundException;
import com.clustercontrol.hinemosagent.ejb.session.MonitorAgentController;
import com.clustercontrol.hinemosagent.util.EjbConnectionManager;
import com.clustercontrol.util.Messages;

/**
 * Hinemos Agent監視情報をマネージャから削除するクラス<BR>
 * 
 * @version 3.0.0
 * @since 2.0.0
 */
public class DeleteAgent {

    /**
     * Hinemos Agent監視情報を削除します。<BR>
     * 
     * @param monitorId 状態監視ID
     * @return 削除に成功した場合、true
     */
    public boolean delete(String monitorId) {
    	
    	MonitorAgentController agent = EjbConnectionManager.getConnectionManager().getAgentController();

        boolean result = false;
  
    	try {
			result = agent.deleteAgent(monitorId);
			return result;
		} catch (MonitorNotFoundException e) {
		} catch (HinemosUnknownException e) {
		} catch (RemoteException e) {
			if(e instanceof AccessException){
				// アクセス権なしの場合、エラーダイアログを表示する
	            MessageDialog.openInformation(null, Messages.getString("message"),
	                    Messages.getString("message.accesscontrol.16"));
			}
		}

        return false;
    }
}