/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.collectiverun.view;

import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;

import com.clustercontrol.collectiverun.composite.ParameterViewComposite;
import com.clustercontrol.collectiverun.view.action.CollectiveRunAction;
import com.clustercontrol.view.CommonViewPart;

/**
 * 一括制御[パラメータ]ビュークラス
 * 
 * @version 1.0.0
 * @since 1.0.0
 *  
 */

public class ParameterView extends CommonViewPart {
    public static final String ID = "com.clustercontrol.collectiverun.view.ParameterView";

    // ----- instance フィールド ----- //

    /** パラメータコンポジット */
    private ParameterViewComposite propertySheet = null;

    /**
     * コンストラクタ
     * 
     * @since 1.0.0
     */
    public ParameterView() {
        super();
    }

    /**
     * ViewPartへのコントロール作成処理
     * 
     * @since 1.0.0
     * @see org.eclipse.ui.IWorkbenchPart#createPartControl(org.eclipse.swt.widgets.Composite)
     */
    @Override
	public void createPartControl(Composite parent) {
        GridLayout layout = new GridLayout(1, true);
        parent.setLayout(layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;

        propertySheet = new ParameterViewComposite(parent, SWT.NONE);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.verticalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        propertySheet.setLayoutData(gridData);
        
        //ポップアップメニュー作成
        createContextMenu();
    }
    
    /**
     * ポップアップメニュー作成
     * 
     *  
     */
    protected void createContextMenu() {
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener() {
            /*
             * (non-Javadoc)
             * 
             * @see org.eclipse.jface.action.IMenuListener#menuAboutToShow(org.eclipse.jface.action.IMenuManager)
             */
            public void menuAboutToShow(IMenuManager manager) {
                //メニュー項目設定
                fillContextMenu(manager);
            }
        });
        
        Menu menu = menuManager.createContextMenu(propertySheet.getTableTree());
        propertySheet.getTableTree().setMenu(menu);
    }

    /**
     * メニュー項目追加
     * 
     * @param manager
     */
    protected void fillContextMenu(IMenuManager manager) {
        //ビューのアクションのインスタンスを取得
        IToolBarManager toolbar = this.getViewSite().getActionBars()
                .getToolBarManager();
        ActionContributionItem collectiveRunAction = (ActionContributionItem) toolbar
                .find(CollectiveRunAction.ID);

        //ポップアップメニューにアクションを追加
        manager.add(collectiveRunAction.getAction());
    }

    /**
     * パラメータコンポジット取得
     * 
     * @return ParameterComposite
     *  
     */
    public ParameterViewComposite getComposite() {
        return this.propertySheet;
    }

    /**
     * 更新処理
     *  
     */
    public void update() {
        propertySheet.update();
    }

    /**
     * アダプターとして要求された場合、自身のインスタンスを渡します。
     * 
     * @param cls
     *            クラスのインスタンス
     * @return 自身のインスタンス
     */
    @Override
	public Object getAdapter(Class cls) {
        if (cls.isInstance(this)) {
            return this;
        } else {
            return super.getAdapter(cls);
        }
    }
}