/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.calendar.view;

import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;

import com.clustercontrol.calendar.composite.AddInfoListComposite;
import com.clustercontrol.calendar.composite.action.AddInfoListSelectionChangedListener;
import com.clustercontrol.calendar.view.action.AddInfoAddAction;
import com.clustercontrol.calendar.view.action.AddInfoDeleteAction;
import com.clustercontrol.calendar.view.action.AddInfoModifyAction;
import com.clustercontrol.view.CommonViewPart;

/**
 * カレンダ追加情報一覧ビュークラス<BR>
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class AddInfoListView extends CommonViewPart {
	public static final String ID = "com.clustercontrol.calendar.view.AddInfoListView";
	
	private AddInfoListComposite m_addList = null;
	
	/**
	 * コンストラクタ
	 */
	public AddInfoListView() {
		super();
	}
	
	/**
	 * ViewPartへのコントロール作成処理<BR>
	 * 
	 * @see org.eclipse.ui.IWorkbenchPart#createPartControl(org.eclipse.swt.widgets.Composite)
	 */
	@Override
	public void createPartControl(Composite parent) {
		GridLayout layout = new GridLayout(1, true);
		parent.setLayout(layout);
		layout.marginHeight = 0;
		layout.marginWidth = 0;
		
		m_addList = new AddInfoListComposite(parent, SWT.NONE);
		GridData gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.verticalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		gridData.grabExcessVerticalSpace = true;
		m_addList.setLayoutData(gridData);
		
		//ポップアップメニュー作成
		createContextMenu();
		
		// ボタン（アクション）を制御するリスナーを登録        
		this.m_addList.getTableViewer().addSelectionChangedListener(
				new AddInfoListSelectionChangedListener());
		
		//ビューを更新
		this.update(null);
	}
	
	/**
	 * ポップアップメニュー作成<BR>
	 * 
	 *  
	 */
	protected void createContextMenu() {
		MenuManager menuManager = new MenuManager();
		menuManager.setRemoveAllWhenShown(true);
		menuManager.addMenuListener(new IMenuListener() {
			/*
			 * (non-Javadoc)
			 * 
			 * @see org.eclipse.jface.action.IMenuListener#menuAboutToShow(org.eclipse.jface.action.IMenuManager)
			 */
			public void menuAboutToShow(IMenuManager manager) {
				//メニュー項目設定
				fillContextMenu(manager);
			}
		});
		
		Menu menu = menuManager.createContextMenu(m_addList.getTable());
		m_addList.getTable().setMenu(menu);
	}
	
	/**
	 * メニュー項目追加<BR>
	 * 
	 * @param manager
	 */
	protected void fillContextMenu(IMenuManager manager) {
		//ビューのアクションのインスタンスを取得
		IToolBarManager toolbar = this.getViewSite().getActionBars()
		.getToolBarManager();
		ActionContributionItem add = 
			(ActionContributionItem) toolbar.find(AddInfoAddAction.ID);
		ActionContributionItem modify = 
			(ActionContributionItem) toolbar.find(AddInfoModifyAction.ID);
		ActionContributionItem delete = 
			(ActionContributionItem) toolbar.find(AddInfoDeleteAction.ID);
		
		//ポップアップメニューにアクションを追加
		manager.add(add.getAction());
		manager.add(modify.getAction());
		manager.add(delete.getAction());
	}
	
	/**
	 * カレンダ追加情報一覧ビュー更新<BR>
	 */
	public void update(String calendarId) {
		m_addList.update(calendarId);
	}
	
	/**
	 * コンポジット取得処理
	 * 
	 * @return
	 */
	public AddInfoListComposite getComposite() {
		return m_addList;
	}
	
	/**
	 * ビューのアクションの有効/無効を設定します。
	 * 
	 * @param num 選択イベント数
	 * @param selection ボタン（アクション）を有効にするための情報
	 * @param flg AddInfoAddActionボタンの有効/無効の選定
	 */
	public void setEnabledAction(int num, ISelection selection, boolean flg) {
		//ビューアクションの使用可/不可を設定
		super.setEnabledAction(AddInfoAddAction.ID, selection);
		super.setEnabledAction(AddInfoModifyAction.ID, selection);
		super.setEnabledAction(AddInfoDeleteAction.ID, selection);
		
		//デフォルト設定
		super.setEnabledAction(AddInfoAddAction.ID, false);
		super.setEnabledAction(AddInfoModifyAction.ID, false);
		super.setEnabledAction(AddInfoDeleteAction.ID, false);
		
		//AddInfoAddActionボタンの設定
		if (flg) {
			super.setEnabledAction(AddInfoAddAction.ID, true);
		}
			
		if (num > 0){
			super.setEnabledAction(AddInfoModifyAction.ID, true);
			super.setEnabledAction(AddInfoDeleteAction.ID, true);
		} else {
			super.setEnabledAction(AddInfoModifyAction.ID, false);
			super.setEnabledAction(AddInfoDeleteAction.ID, false);
		}
	}
}