/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.accesscontrol.view.action;

import java.util.List;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

import com.clustercontrol.accesscontrol.action.DeleteUserProperty;
import com.clustercontrol.accesscontrol.bean.UserListTableDefine;
import com.clustercontrol.accesscontrol.view.UserListView;
import com.clustercontrol.util.Messages;

/**
 * アクセス[ユーザ]ビューの「削除」のアクションクラス<BR>
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class UserDeleteAction implements IViewActionDelegate {
	/** アクションID */
	public static final String ID = "com.clustercontrol.accesscontrol.view.action.UserDeleteAction";
	/** ビュー */
    private IViewPart viewPart;

    /**
     * ビューを保持します。ワークベンチにロードされた際に呼ばれます。
     * 
     * @param view ビューのインスタンス
     * 
     * @see org.eclipse.ui.IViewActionDelegate#init(org.eclipse.ui.IViewPart)
     */
    public void init(IViewPart viewPart) {
        this.viewPart = viewPart;
    }

    /**
     * アクセス[ユーザ]ビューの「削除」が押された場合に、<BR>
     * ユーザを削除します。
     * <p>
	 * <ol>
	 * <li>アクセス[ユーザ]ビューから選択されているユーザのユーザIDを取得します。</li>
	 * <li>ユーザIDが一致するユーザを削除します。</li>
	 * <li>アクセス[ユーザ]ビューを更新します。</li>
	 * </ol>
     * 
     * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
     * @see com.clustercontrol.accesscontrol.view.UserListView
     * @see com.clustercontrol.accesscontrol.action.DeleteUserProperty#delete(String)
     */
    public void run(IAction action) {
        // ユーザ一覧より、選択されているユーザのUIDを取得

        UserListView view = (UserListView) this.viewPart
                .getAdapter(UserListView.class);

        StructuredSelection selection = (StructuredSelection) view
                .getComposite().getTableViewer().getSelection();

        List list = (List) selection.getFirstElement();
        String uid = null;
        if (list != null) {
            uid = (String) list.get(UserListTableDefine.UID);
        }
        
        
        if (uid != null) {
            // 確認ダイアログにて変更が選択された場合、削除処理を行う。
            String[] args = { uid };
            if (MessageDialog.openConfirm(
        			null, 
        			Messages.getString("confirmed"), 
        			Messages.getString("message.accesscontrol.13", args))) {

                DeleteUserProperty deleteUser = new DeleteUserProperty();
                
                if (!deleteUser.useCheck(uid)) {
                	
                    if (deleteUser.delete(uid)) {
                        // 成功報告ダイアログを生成
                    	MessageDialog.openInformation(
                    			null, 
                    			Messages.getString("successful"), 
                    			Messages.getString("message.accesscontrol.11"));
                    } else {
                        // 失敗報告ダイアログを生成
                    	MessageDialog.openError(
                    			null, 
                    			Messages.getString("failed"), 
                    			Messages.getString("message.accesscontrol.12"));
                    }
                	
                }
                // ビューを更新
                view.update();
            }
        }
    }

    /* (non-Javadoc)
     * @see org.eclipse.ui.IActionDelegate#selectionChanged(org.eclipse.jface.action.IAction, org.eclipse.jface.viewers.ISelection)
     */
    public void selectionChanged(IAction action, ISelection selection) {
    }
}