/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.accesscontrol.action;

import java.rmi.AccessException;
import java.rmi.RemoteException;
import java.util.Locale;

import javax.ejb.FinderException;
import javax.naming.NamingException;

import org.eclipse.jface.dialogs.MessageDialog;

import com.clustercontrol.accesscontrol.bean.UserRoleList;
import com.clustercontrol.accesscontrol.ejb.session.AccessController;
import com.clustercontrol.accesscontrol.util.EjbConnectionManager;
import com.clustercontrol.bean.Property;
import com.clustercontrol.util.Messages;

/**
 * ユーザ用プロパティを取得するクライアント側アクションクラス<BR>
 * 
 * ロケールの関係があるので、ダイアログ生成情報も
 * マネージャから取得します。
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class GetUserProperty {

	/**
	 * マネージャにSessionBean経由でアクセスし、<BR>
	 * ユーザ用プロパティを取得します。
	 * 
	 * @param uid ユーザID
	 * @param mode 編集モード
	 * @return ユーザ用プロパティ
	 * 
	 * @see com.clustercontrol.bean.PropertyConstant
	 * @see com.clustercontrol.accesscontrol.util.EjbConnectionManager
	 * @see com.clustercontrol.accesscontrol.ejb.session.AccessController#getUserProperty(java.lang.String, int, java.util.Locale)
	 */
	public Property getProperty(String uid, int mode) {
		AccessController access = EjbConnectionManager
		.getConnectionManager().getAccessController();

		Property property = null;
		try {
			property = access.getUserProperty(uid, mode, Locale.getDefault());
		} catch (RemoteException e) {
			if(e instanceof AccessException){
				// アクセス権なしの場合、エラーダイアログを表示する
				MessageDialog.openInformation(null, Messages.getString("message"),
						Messages.getString("message.accesscontrol.16"));
			}
		} catch (FinderException e) {
		} catch (NamingException e) {
		}
		return property;
	}

	/**
	 * マネージャにSessionBean経由でアクセスし、<BR>
	 * ユーザ用プロパティを取得します。
	 * 
	 * @param uid ユーザID
	 * @param mode 編集モード
	 * @return ユーザ用プロパティ
	 * 
	 * @see com.clustercontrol.bean.PropertyConstant
	 * @see com.clustercontrol.accesscontrol.util.EjbConnectionManager
	 * @see com.clustercontrol.accesscontrol.ejb.session.AccessController#getUserProperty(java.lang.String, int, java.util.Locale)
	 */
	public UserRoleList getUserRoleList() {
		AccessController access = EjbConnectionManager
		.getConnectionManager().getAccessController();

		UserRoleList list = null;
		try {
			list = access.getUserRoleList();
		} catch (RemoteException e) {
			if(e instanceof AccessException){
				// アクセス権なしの場合、エラーダイアログを表示する
				MessageDialog.openInformation(null, Messages.getString("message"),
						Messages.getString("message.accesscontrol.16"));
			}
		}
		return list;
	}
}