/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.util;

import java.rmi.RemoteException;

import javax.ejb.CreateException;
import javax.naming.NamingException;

import org.jnp.interfaces.NamingContext;

import com.clustercontrol.repository.ejb.session.RepositoryController;
import com.clustercontrol.repository.ejb.session.RepositoryControllerHome;

/**
 * EJBとのコネクションを管理するクラス<BR>
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class EjbConnectionManager {
    private static EjbConnectionManager m_instance = null;
    private NamingContext m_ctx = null;

    /**
     * このオブジェクトを取得します。 シングルトン
     * 
     * @return ConnectionManager コネクションマネージャ
     */
    public static EjbConnectionManager getConnectionManager() {
        if (m_instance == null) {
            m_instance = new EjbConnectionManager();
        }
        return m_instance;
    }

    private EjbConnectionManager() {

    }

    /**
     * RepositoryCollectorを取得します。
     * 
     * @return RepositoryCollector
     */
    public synchronized RepositoryController getRepositoryController() {
        try {
            m_ctx = LoginManager.getContextManager().getNamingContext();
            
            //if(LoginManager.getContextManager().isLogin()){
            //	System.out.println("util.getRepositoryController() login OK");
            //	System.out.println("util.getRepositoryController() userId = " + LoginManager.getContextManager().getUserId());
            //}
            //else{
            //	System.out.println("util.getRepositoryController() login NG");
            //}
        } catch (NamingException e) {
            return null;
        }

        RepositoryControllerHome home;
        try {
            home = (RepositoryControllerHome) m_ctx
                    .lookup(RepositoryControllerHome.JNDI_NAME);
            return home.create();
        } catch (NamingException e) {
        } catch (RemoteException e) {
        } catch (CreateException e) {
        }
        m_ctx = null;
        return null;
    }
}