/*
 
Copyright (C) since 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.repository.bean;

/**
 * リポジトリ機能－VMノードの追加・編集を行うテーブル定義クラスです。<BR>
 * 
 * クライアントにおける割り当てスコープのテーブルのカラムの並び順を
 * 規定します。
 * 
 * @version 3.1.0
 * @since 3.1.0
 */
public class VmNodeListTabelDefine {
	
	
	/** 処理チェックボックス。 */
	public static final int SELECTION = 0;
	
	
	
    /**リポジトリ登録情報 */
    public static final int REGISTRATION = 1;

    /** 設定管理ノード */
    public static final int SETTING_MANAGE_NODE = 2;

    /** 最新管理ノード */
    public static final int NEW_MANAGE_NODE = 3;
    
    
    
    
    /** ファシリティID */
    public static final int FACILITY_ID = 4;

    /** ファシリティ名 */
    public static final int FACILITY_NAME = 5;

    /** プラットフォーム */
    public static final int PLATFORM = 6;

    /** ノード名 */
    public static final int NODE_NAME = 7;

    /** 仮想マシン名 */
    public static final int VM_NAME = 8; // このテーブルのキー(ホストノードに対してVM名は一意に定まる)

    /** 仮想マシンID */
    public static final int VM_ID = 9; // このテーブルのキー(ホストノードに対してVM名は一意に定まる)

    
    /** IP ADDRESS v4 */
    public static final int IP_ADDRESS_V4 = 10;
    
    /** IP ADDRESS v6 */
    public static final int IP_ADDRESS_V6 = 11;
    
    
    
    
    /** 初期表示時ソートカラム */
    public static final int SORT_COLUMN_INDEX = REGISTRATION;

    /** 初期表示時ソートオーダー */
    public static final int SORT_ORDER = 1;
}