/* 
  
Copyright (C) since 2009 NTT DATA Corporation 
  
This program is free software; you can redistribute it and/or 
Modify it under the terms of the GNU General Public License  
as published by the Free Software Foundation, version 2. 
  
This program is distributed in the hope that it will be 
 useful, but WITHOUT ANY WARRANTY; without even the implied  
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR  
 PURPOSE.  See the GNU General Public License for more details. 
  
*/ 
package com.clustercontrol.repository.bean;

import java.io.Serializable;
import java.util.ArrayList;

import com.clustercontrol.repository.bean.NodeDeviceInfo;
import com.clustercontrol.repository.bean.NodeFilesystemInfo;
import com.clustercontrol.repository.bean.NodeHostnameInfo;
import com.clustercontrol.repository.bean.NodeNoteInfo;

/**
 * このクラスはノード詳細のクラスです。
 * ノードの詳細を保持するために使用されます。
 * @since 0.8
 */
public class NodeInfo extends FacilityInfo implements Serializable
{
	private static final long serialVersionUID = -4120880233299545923L;
	
	private java.lang.String platformFamily = "";
	private java.lang.String hardwareType = "";
	private java.lang.String iconImage = "";
	private java.lang.Integer snmpPort = new Integer(161);
	private java.lang.String snmpCommunity = "public";
	private java.lang.String snmpVersion = "2c";
	private java.lang.Integer snmpTimeout = new Integer(3000);
	private java.lang.Integer snmpRetryCount = new Integer(3);
	private java.lang.String snmpProxy = "";
	private java.lang.String wbemUser = "root";
	private java.lang.String wbemUserPassword = "";
	private java.lang.Integer wbemPort = new Integer(5988);
	private java.lang.String wbemProtocol = "http";
	private java.lang.Integer wbemTimeout = new Integer(3000);
	private java.lang.Integer wbemRetryCount = new Integer(3);
	private java.lang.Boolean dhcpClient = Boolean.FALSE;
	private java.lang.Integer ipAddressType = new Integer(-1);
	private java.lang.Integer ipAddressVersion = new Integer(-1);
	private java.lang.String ipAddressV4 = "";
	private java.lang.String ipAddressV6 = "";
	private java.lang.String nodeName = "";
	private java.lang.String osName = "";
	private java.lang.String osRelease = "";
	private java.lang.String osVersion = "";
	private java.lang.String characterSet = "";
	private java.lang.String virtualizationNodeType = "";
	private java.lang.String vmManagementNode = "";
	private java.lang.Integer vmIndex = new Integer(-1);
	private java.lang.String vmName = "";
	private java.lang.String virtualizationSolution = "";
	private java.lang.String vmId = "";
	private java.lang.String vmUser = "";
	private java.lang.String vmUserPassword = "";
	private java.lang.String vmProtocol = "";
	private java.lang.String administrator = "";
	private java.lang.String contact = "";

	private ArrayList<NodeDeviceInfo> nodeDeviceInfo;
	private ArrayList<NodeFilesystemInfo> nodeFilesystemInfo;
	private ArrayList<NodeHostnameInfo> nodeHostnameInfo;
	private ArrayList<NodeNoteInfo> nodeNoteInfo;

	public NodeInfo() {}
	
	/**
	 * コンストラクタです。
	 * ファシリティIDとファシリティ名は引数で与えます。
	 * ファシリティ種別は1、表示ソート順は100に設定されます。
	 * @param facilityId
	 * @param facilityName
	 */
	public NodeInfo(String facilityId, String facilityName)
	{
		super();
		
		setFacilityId(facilityId);
		setFacilityName(facilityName);
		
		/*
		 * デフォルト値
		 */
		// 0 - scope, 1 - node
		setFacilityType(1);
		
		// 100 - node, 200 - scope
		// 10000 - display_sort_order, 11000 - REGISTERED, 12000 - UNREGISTERED
		setDisplaySortOrder(100);

		/*
		setDescription(description);
		setCreateUserId(createUserId);
		setCreateDatetime(createDatetime);
		setModifyUserId(modifyUserId);
		setModifyDatetime(modifyDatetime);
		*/
	}

	/**
	 * プラットフォームのgetterです。
	 * @return String
	 */
	public java.lang.String getPlatformFamily()
	{
		return this.platformFamily;
	}
	
	/**
	 * プラットフォームのsetterです。
	 * @param platformFamily
	 */
	public void setPlatformFamily( java.lang.String platformFamily )
	{
		this.platformFamily = platformFamily;
	}

	/**
	 * H/Wのgetterです。
	 * @return String
	 */
	public java.lang.String getHardwareType()
	{
		return this.hardwareType;
	}
	
	/**
	 * H/Wのsetterです。
	 * @param hardwareType
	 */
	public void setHardwareType( java.lang.String hardwareType )
	{
		this.hardwareType = hardwareType;
	}

	/**
	 * 画面アイコンイメージのgetterです。
	 * @return String
	 */
	public java.lang.String getIconImage()
	{
		return this.iconImage;
	}
	
	/**
	 * 画面アイコンイメージのsetterです。
	 * @param iconImage
	 */
	public void setIconImage( java.lang.String iconImage )
	{
		this.iconImage = iconImage;
	}

	/**
	 * SNMP->ポート番号のgetterです。
	 * @return Integer
	 */
	public java.lang.Integer getSnmpPort()
	{
		return this.snmpPort;
	}
	
	/**
	 * SNMP->ポート番号のsetterです。
	 * @param snmpPort
	 */
	public void setSnmpPort( java.lang.Integer snmpPort )
	{
		this.snmpPort = snmpPort;
	}

	/**
	 * SNMP->コミュニティ名のgetterです。
	 * @return String
	 */
	public java.lang.String getSnmpCommunity()
	{
		return this.snmpCommunity;
	}
	
	/**
	 * SNMP->コミュニティ名のsetterです。
	 * @param snmpCommunity
	 */
	public void setSnmpCommunity( java.lang.String snmpCommunity )
	{
		this.snmpCommunity = snmpCommunity;
	}

	/**
	 * SNMP->バージョンのgetterです。
	 * @return String
	 */
	public java.lang.String getSnmpVersion()
	{
		return this.snmpVersion;
	}
	
	/**
	 * SNMP->バージョンのsetterです。
	 * @param snmpVersion
	 */
	public void setSnmpVersion( java.lang.String snmpVersion )
	{
		this.snmpVersion = snmpVersion;
	}

	/**
	 * SNMP->SNMP タイムアウトのgetterです。
	 * @return Integer
	 */
	public java.lang.Integer getSnmpTimeout()
	{
		return this.snmpTimeout;
	}
	
	/**
	 * SNMP->SNMP タイムアウトのsetterです。
	 * @param snmpTimeout
	 */
	public void setSnmpTimeout( java.lang.Integer snmpTimeout )
	{
		this.snmpTimeout = snmpTimeout;
	}

	/**
	 * SNMP->SNMP リトライ回数のgetterです。
	 * @return Integer
	 */
	public java.lang.Integer getSnmpRetryCount()
	{
		return this.snmpRetryCount;
	}
	
	/**
	 * SNMP->SNMP リトライ回数のsetterです。
	 * @param snmpRetryCount
	 */
	public void setSnmpRetryCount( java.lang.Integer snmpRetryCount )
	{
		this.snmpRetryCount = snmpRetryCount;
	}

	/**
	 * SNMP->SNMP プロキシのgetterです。
	 * @return String
	 */
	public java.lang.String getSnmpProxy()
	{
		return this.snmpProxy;
	}
	
	/**
	 * SNMP->SNMP プロキシのsetterです。
	 * @param snmpProxy
	 */
	public void setSnmpProxy( java.lang.String snmpProxy )
	{
		this.snmpProxy = snmpProxy;
	}

	/**
	 * WBEM->接続ユーザ名のgetterです。
	 * @return String
	 */
	public java.lang.String getWbemUser()
	{
		return this.wbemUser;
	}
	
	/**
	 * WBEM->接続ユーザ名のsetterです。
	 * @param wbemUser
	 */
	public void setWbemUser( java.lang.String wbemUser )
	{
		this.wbemUser = wbemUser;
	}

	/**
	 * WBEM->接続ユーザパスワードのgetterです。
	 * @return String
	 */
	public java.lang.String getWbemUserPassword()
	{
		return this.wbemUserPassword;
	}
	
	/**
	 * WBEM->接続ユーザパスワードのsetterです。
	 * @param wbemUserPassword
	 */
	public void setWbemUserPassword( java.lang.String wbemUserPassword )
	{
		this.wbemUserPassword = wbemUserPassword;
	}

	/**
	 * WBEM->WBEM ポート番号のgetterです。
	 * @return Integer
	 */
	public java.lang.Integer getWbemPort()
	{
		return this.wbemPort;
	}
	
	/**
	 * WBEM->WBEM ポート番号のsetterです。
	 * @param wbemPort
	 */
	public void setWbemPort( java.lang.Integer wbemPort )
	{
		this.wbemPort = wbemPort;
	}

	/**
	 * WBEM->WBEM プロトコルのgetterです。
	 * @return String
	 */
	public java.lang.String getWbemProtocol()
	{
		return this.wbemProtocol;
	}
	
	/**
	 * WBEM->WBEM プロトコルのsetterです。
	 * @param wbemProtocol
	 */
	public void setWbemProtocol( java.lang.String wbemProtocol )
	{
		this.wbemProtocol = wbemProtocol;
	}

	/**
	 * WBEM->WBEM タイムアウトのgetterです。
	 * @return Integer
	 */
	public java.lang.Integer getWbemTimeout()
	{
		return this.wbemTimeout;
	}
	
	/**
	 * WBEM->WBEM タイムアウトのsetterです。
	 * @param wbemTimeout
	 */
	public void setWbemTimeout( java.lang.Integer wbemTimeout )
	{
		this.wbemTimeout = wbemTimeout;
	}

	/**
	 * WBEM->WBEM リトライ回数のgetterです。
	 * @return Integer
	 */
	public java.lang.Integer getWbemRetryCount()
	{
		return this.wbemRetryCount;
	}
	
	/**
	 * WBEM->WBEM リトライ回数のsetterです。
	 * @param wbemRetryCount
	 */
	public void setWbemRetryCount( java.lang.Integer wbemRetryCount )
	{
		this.wbemRetryCount = wbemRetryCount;
	}

	/**
	 * WBEMで値取得時に必要となるNameSpaceです。
	 * 現在は固定値を返します。
	 * @return 固定値（root/cimv2）を返す。
	 */
	public String getWbemNameSpace(){
		return "root/cimv2";
	}
	
	/**
	 * DHCPクライアントのgetterです。
	 * @return Boolean
	 */
	public java.lang.Boolean getDhcpClient()
	{
		return this.dhcpClient;
	}
	
	/**
	 * DHCPクライアントのsetterです。
	 * @param dhcpClient
	 */
	public void setDhcpClient( java.lang.Boolean dhcpClient )
	{
		this.dhcpClient = dhcpClient;
	}

	/**
	 * IPアドレス種別のgetterです。
	 * @return Integer
	 */
	public java.lang.Integer getIpAddressType()
	{
		return this.ipAddressType;
	}
	
	/**
	 * IPアドレス種別のsetterです。
	 * @param ipAddressType
	 */
	public void setIpAddressType( java.lang.Integer ipAddressType )
	{
		this.ipAddressType = ipAddressType;
	}

	/**
	 * IPアドレスのバージョンのgetterです。
	 * @return Integer
	 */
	public java.lang.Integer getIpAddressVersion()
	{
		return this.ipAddressVersion;
	}
	
	/**
	 * IPアドレスのバージョンのsetterです。
	 * @param ipAddressVersion
	 */
	public void setIpAddressVersion( java.lang.Integer ipAddressVersion )
	{
		this.ipAddressVersion = ipAddressVersion;
	}

	/**
	 * IPv4のアドレスのgetterです。
	 * @return String
	 */
	public java.lang.String getIpAddressV4()
	{
		return this.ipAddressV4;
	}
	
	/**
	 * IPv4のアドレスのsetterです。
	 * @param ipAddressV4
	 */
	public void setIpAddressV4( java.lang.String ipAddressV4 )
	{
		this.ipAddressV4 = ipAddressV4;
	}

	/**
	 * IPv6のアドレスのgetterです。
	 * @return String
	 */
	public java.lang.String getIpAddressV6()
	{
		return this.ipAddressV6;
	}
	
	/**
	 * IPv6のアドレスのsetterです。
	 * @param ipAddressV6
	 */
	public void setIpAddressV6( java.lang.String ipAddressV6 )
	{
		this.ipAddressV6 = ipAddressV6;
	}

	/**
	 * ノード名のgetterです。
	 * @return String
	 */
	public java.lang.String getNodeName()
	{
		return this.nodeName;
	}
	
	/**
	 * ノード名のsetterです。
	 * @param nodeName
	 */
	public void setNodeName( java.lang.String nodeName )
	{
		this.nodeName = nodeName;
	}

	/**
	 * OS名のgetterです。
	 * @return String
	 */
	public java.lang.String getOsName()
	{
		return this.osName;
	}
	
	/**
	 * OS名のsetterです。
	 * @param osName
	 */
	public void setOsName( java.lang.String osName )
	{
		this.osName = osName;
	}
	
	/**
	 * OSリリースのgetterです。
	 * @return String
	 */
	public java.lang.String getOsRelease()
	{
		return this.osRelease;
	}
	
	/**
	 * OSリリースのsetterです。
	 * @param osRelease
	 */
	public void setOsRelease( java.lang.String osRelease )
	{
		this.osRelease = osRelease;
	}

	/**
	 * OSバージョンのgetterです。
	 * @return String
	 */
	public java.lang.String getOsVersion()
	{
		return this.osVersion;
	}
	
	/**
	 * OSバージョンのgetterです。
	 * @param osVersion
	 */
	public void setOsVersion( java.lang.String osVersion )
	{
		this.osVersion = osVersion;
	}

	/**
	 * 文字セットのgetterです。
	 * @return String
	 */
	public java.lang.String getCharacterSet()
	{
		return this.characterSet;
	}
	
	/**
	 * 文字セットのsetterです。
	 * @param characterSet
	 */
	public void setCharacterSet( java.lang.String characterSet )
	{
		this.characterSet = characterSet;
	}

	/**
	 * 仮想化->ノード種別のgetterです。
	 * @return String
	 */
	public java.lang.String getVirtualizationNodeType()
	{
		return this.virtualizationNodeType;
	}
	
	/**
	 * 仮想化->ノード種別のsetterです。
	 * @param virtualizationNodeType
	 */
	public void setVirtualizationNodeType( java.lang.String virtualizationNodeType )
	{
		this.virtualizationNodeType = virtualizationNodeType;
	}

	/**
	 * 管理ノードのgetterです。
	 * @return String
	 */
	public java.lang.String getVmManagementNode()
	{
		return this.vmManagementNode;
	}
	
	/**
	 * 管理ノードのsetterです。
	 * @param vmManagementNode
	 */
	public void setVmManagementNode( java.lang.String vmManagementNode )
	{
		this.vmManagementNode = vmManagementNode;
	}

	/**
	 * 仮想マシンINDEXのgetterです。
	 * @return Integer
	 */
	public java.lang.Integer getVmIndex()
	{
		return this.vmIndex;
	}
	
	/**
	 * 仮想マシンINDEXのsetterです。
	 * @param vmIndex
	 */
	public void setVmIndex( java.lang.Integer vmIndex )
	{
		this.vmIndex = vmIndex;
	}

	/**
	 * 仮想マシン名のgetterです。
	 * @return String
	 */
	public java.lang.String getVmName()
	{
		return this.vmName;
	}
	
	/**
	 * 仮想マシン名のsetterです。
	 * @param vmName
	 */
	public void setVmName( java.lang.String vmName )
	{
		this.vmName = vmName;
	}

	/**
	 * 仮想化ソリューションのgetterです。
	 * @return String
	 */
	public java.lang.String getVirtualizationSolution()
	{
		return this.virtualizationSolution;
	}
	
	/**
	 * 仮想化ソリューションのsetterです。
	 * @param virtualizationSolution
	 */
	public void setVirtualizationSolution( java.lang.String virtualizationSolution )
	{
		this.virtualizationSolution = virtualizationSolution;
	}

	/**
	 * 仮想マシンIDのgetterです。
	 * @return String
	 */
	public java.lang.String getVmId()
	{
		return this.vmId;
	}
	
	/**
	 * 仮想マシンIDのsetterです。
	 * @param vmId
	 */
	public void setVmId( java.lang.String vmId )
	{
		this.vmId = vmId;
	}

	/**
	 * 仮想化ソフト接続ユーザのgetterです。
	 * @return String
	 */
	public java.lang.String getVmUser()
	{
		return this.vmUser;
	}
	
	/**
	 * 仮想化ソフト接続ユーザのsetterです。
	 * @param vmUser
	 */
	public void setVmUser( java.lang.String vmUser )
	{
		this.vmUser = vmUser;
	}

	/**
	 * 仮想化ソフト接続ユーザパスワードのgetterです。
	 * @return String
	 */
	public java.lang.String getVmUserPassword()
	{
		return this.vmUserPassword;
	}
	
	/**
	 * 仮想化ソフト接続ユーザパスワードのsetterです。
	 * @param vmUserPassword
	 */
	public void setVmUserPassword( java.lang.String vmUserPassword )
	{
		this.vmUserPassword = vmUserPassword;
	}

	/**
	 * 仮想化ソフト接続プロトコルのgetterです。
	 * @return String
	 */
	public java.lang.String getVmProtocol()
	{
		return this.vmProtocol;
	}
	
	/**
	 * 仮想化ソフト接続プロトコルのsetterです。
	 * @param vmProtocol
	 */
	public void setVmProtocol( java.lang.String vmProtocol )
	{
		this.vmProtocol = vmProtocol;
	}

	/**
	 * 管理者のgetterです。
	 * @return String
	 */
	public java.lang.String getAdministrator()
	{
		return this.administrator;
	}
	
	/**
	 * 管理者のsetterです。
	 * @param administrator
	 */
	public void setAdministrator( java.lang.String administrator )
	{
		this.administrator = administrator;
	}

	/**
	 * 連絡先のgetterです。
	 * @return String
	 */
	public java.lang.String getContact()
	{
		return this.contact;
	}
	
	/**
	 * 連絡先のsetterです。
	 * @param contact
	 */
	public void setContact( java.lang.String contact )
	{
		this.contact = contact;
	}

	@Override
	public String toString()
	{
		StringBuffer str = new StringBuffer("");
			
		str.append(super.toString()); 
		
		str.append('{');

		str.append(
				"platformFamily=" + getPlatformFamily() + " " + 
				"hardwareType=" + getHardwareType() + " " +
				"iconImage=" + getIconImage() + " " +
				"snmpPort=" + getSnmpPort() + " " +
				"snmpCommunity=" + getSnmpCommunity() + " " +
				"snmpVersion=" + getSnmpVersion() + " " +
				"snmpTimeout=" + getSnmpTimeout() + " " +
				"snmpRetryCount=" + getSnmpRetryCount() + " " +
				"snmpProxy=" + getSnmpProxy() + " " +
				"wbemUser=" + getWbemUser() + " " +
				"wbemUserPassword=" + getWbemUserPassword() + " " +
				"wbemPort=" + getWbemPort() + " " +
				"wbemProtocol=" + getWbemProtocol() + " " +
				"wbemTimeout=" + getWbemTimeout() + " " +
				"wbemRetryCount=" + getWbemRetryCount() + " " +
				"dhcpClient=" + getDhcpClient() + " " +
				"ipAddressType=" + getIpAddressType() + " " +
				"ipAddressVersion=" + getIpAddressVersion() + " " +
				"ipAddressV4=" + getIpAddressV4() + " " +
				"ipAddressV6=" + getIpAddressV6() + " " +
				"nodeName=" + getNodeName() + " " +
				"osName=" + getOsName() + " " +
				"osRelease=" + getOsRelease() + " " +
				"osVersion=" + getOsVersion() + " " +
				"characterSet=" + getCharacterSet() + " " +
				"virtualizationNodeType=" + getVirtualizationNodeType() + " " +
				"vmManagementNode=" + getVmManagementNode() + " " +
				"vmIndex=" + getVmIndex() + " " +
				"vmName=" + getVmName() + " " +
				"virtualizationSolution=" + getVirtualizationSolution() + " " +
				"vmId=" + getVmId() + " " +
				"vmUser=" + getVmUser() + " " +
				"vmUserPassword=" + getVmUserPassword() + " " +
				"vmProtocol=" + getVmProtocol() + " " +
				"administrator=" + getAdministrator() + " " +
				"contact=" + getContact()
				);
		str.append('}');

		return(str.toString());
	}

	@Override
	public boolean equals( Object pOther )
	{
		if( pOther instanceof NodeInfo )
		{
			NodeInfo lTest = (NodeInfo) pOther;
			boolean lEquals = true;
			
			lEquals = lEquals && super.equals(pOther);
			
			if( this.platformFamily == null )
			{
				lEquals = lEquals && ( lTest.platformFamily == null );
			}
			else
			{
				lEquals = lEquals && this.platformFamily.equals( lTest.platformFamily );
			}
			if( this.hardwareType == null )
			{
				lEquals = lEquals && ( lTest.hardwareType == null );
			}
			else
			{
				lEquals = lEquals && this.hardwareType.equals( lTest.hardwareType );
			}
			if( this.iconImage == null )
			{
				lEquals = lEquals && ( lTest.iconImage == null );
			}
			else
			{
				lEquals = lEquals && this.iconImage.equals( lTest.iconImage );
			}
			if( this.snmpPort == null )
			{
				lEquals = lEquals && ( lTest.snmpPort == null );
			}
			else
			{
				lEquals = lEquals && this.snmpPort.equals( lTest.snmpPort );
			}
			if( this.snmpCommunity == null )
			{
				lEquals = lEquals && ( lTest.snmpCommunity == null );
			}
			else
			{
				lEquals = lEquals && this.snmpCommunity.equals( lTest.snmpCommunity );
			}
			if( this.snmpVersion == null )
			{
				lEquals = lEquals && ( lTest.snmpVersion == null );
			}
			else
			{
				lEquals = lEquals && this.snmpVersion.equals( lTest.snmpVersion );
			}
			if( this.snmpTimeout == null )
			{
				lEquals = lEquals && ( lTest.snmpTimeout == null );
			}
			else
			{
				lEquals = lEquals && this.snmpTimeout.equals( lTest.snmpTimeout );
			}
			if( this.snmpRetryCount == null )
			{
				lEquals = lEquals && ( lTest.snmpRetryCount == null );
			}
			else
			{
				lEquals = lEquals && this.snmpRetryCount.equals( lTest.snmpRetryCount );
			}
			if( this.snmpProxy == null )
			{
				lEquals = lEquals && ( lTest.snmpProxy == null );
			}
			else
			{
				lEquals = lEquals && this.snmpProxy.equals( lTest.snmpProxy );
			}
			if( this.wbemUser == null )
			{
				lEquals = lEquals && ( lTest.wbemUser == null );
			}
			else
			{
				lEquals = lEquals && this.wbemUser.equals( lTest.wbemUser );
			}
			if( this.wbemUserPassword == null )
			{
				lEquals = lEquals && ( lTest.wbemUserPassword == null );
			}
			else
			{
				lEquals = lEquals && this.wbemUserPassword.equals( lTest.wbemUserPassword );
			}
			if( this.wbemPort == null )
			{
				lEquals = lEquals && ( lTest.wbemPort == null );
			}
			else
			{
				lEquals = lEquals && this.wbemPort.equals( lTest.wbemPort );
			}
			if( this.wbemProtocol == null )
			{
				lEquals = lEquals && ( lTest.wbemProtocol == null );
			}
			else
			{
				lEquals = lEquals && this.wbemProtocol.equals( lTest.wbemProtocol );
			}
			if( this.wbemTimeout == null )
			{
				lEquals = lEquals && ( lTest.wbemTimeout == null );
			}
			else
			{
				lEquals = lEquals && this.wbemTimeout.equals( lTest.wbemTimeout );
			}
			if( this.wbemRetryCount == null )
			{
				lEquals = lEquals && ( lTest.wbemRetryCount == null );
			}
			else
			{
				lEquals = lEquals && this.wbemRetryCount.equals( lTest.wbemRetryCount );
			}
			if( this.dhcpClient == null )
			{
				lEquals = lEquals && ( lTest.dhcpClient == null );
			}
			else
			{
				lEquals = lEquals && this.dhcpClient.equals( lTest.dhcpClient );
			}
			if( this.ipAddressType == null )
			{
				lEquals = lEquals && ( lTest.ipAddressType == null );
			}
			else
			{
				lEquals = lEquals && this.ipAddressType.equals( lTest.ipAddressType );
			}
			if( this.ipAddressVersion == null )
			{
				lEquals = lEquals && ( lTest.ipAddressVersion == null );
			}
			else
			{
				lEquals = lEquals && this.ipAddressVersion.equals( lTest.ipAddressVersion );
			}
			if( this.ipAddressV4 == null )
			{
				lEquals = lEquals && ( lTest.ipAddressV4 == null );
			}
			else
			{
				lEquals = lEquals && this.ipAddressV4.equals( lTest.ipAddressV4 );
			}
			if( this.ipAddressV6 == null )
			{
				lEquals = lEquals && ( lTest.ipAddressV6 == null );
			}
			else
			{
				lEquals = lEquals && this.ipAddressV6.equals( lTest.ipAddressV6 );
			}
			if( this.nodeName == null )
			{
				lEquals = lEquals && ( lTest.nodeName == null );
			}
			else
			{
				lEquals = lEquals && this.nodeName.equals( lTest.nodeName );
			}
			if( this.osName == null )
			{
				lEquals = lEquals && ( lTest.osName == null );
			}
			else
			{
				lEquals = lEquals && this.osName.equals( lTest.osName );
			}
			if( this.osRelease == null )
			{
				lEquals = lEquals && ( lTest.osRelease == null );
			}
			else
			{
				lEquals = lEquals && this.osRelease.equals( lTest.osRelease );
			}
			if( this.osVersion == null )
			{
				lEquals = lEquals && ( lTest.osVersion == null );
			}
			else
			{
				lEquals = lEquals && this.osVersion.equals( lTest.osVersion );
			}
			if( this.characterSet == null )
			{
				lEquals = lEquals && ( lTest.characterSet == null );
			}
			else
			{
				lEquals = lEquals && this.characterSet.equals( lTest.characterSet );
			}
			if( this.virtualizationNodeType == null )
			{
				lEquals = lEquals && ( lTest.virtualizationNodeType == null );
			}
			else
			{
				lEquals = lEquals && this.virtualizationNodeType.equals( lTest.virtualizationNodeType );
			}
			if( this.vmManagementNode == null )
			{
				lEquals = lEquals && ( lTest.vmManagementNode == null );
			}
			else
			{
				lEquals = lEquals && this.vmManagementNode.equals( lTest.vmManagementNode );
			}
			if( this.vmIndex == null )
			{
				lEquals = lEquals && ( lTest.vmIndex == null );
			}
			else
			{
				lEquals = lEquals && this.vmIndex.equals( lTest.vmIndex );
			}
			if( this.vmName == null )
			{
				lEquals = lEquals && ( lTest.vmName == null );
			}
			else
			{
				lEquals = lEquals && this.vmName.equals( lTest.vmName );
			}
			if( this.virtualizationSolution == null )
			{
				lEquals = lEquals && ( lTest.virtualizationSolution == null );
			}
			else
			{
				lEquals = lEquals && this.virtualizationSolution.equals( lTest.virtualizationSolution );
			}
			if( this.vmId == null )
			{
				lEquals = lEquals && ( lTest.vmId == null );
			}
			else
			{
				lEquals = lEquals && this.vmId.equals( lTest.vmId );
			}
			if( this.vmUser == null )
			{
				lEquals = lEquals && ( lTest.vmUser == null );
			}
			else
			{
				lEquals = lEquals && this.vmUser.equals( lTest.vmUser );
			}
			if( this.vmUserPassword == null )
			{
				lEquals = lEquals && ( lTest.vmUserPassword == null );
			}
			else
			{
				lEquals = lEquals && this.vmUserPassword.equals( lTest.vmUserPassword );
			}
			if( this.vmProtocol == null )
			{
				lEquals = lEquals && ( lTest.vmProtocol == null );
			}
			else
			{
				lEquals = lEquals && this.vmProtocol.equals( lTest.vmProtocol );
			}
			if( this.administrator == null )
			{
				lEquals = lEquals && ( lTest.administrator == null );
			}
			else
			{
				lEquals = lEquals && this.administrator.equals( lTest.administrator );
			}
			if( this.contact == null )
			{
				lEquals = lEquals && ( lTest.contact == null );
			}
			else
			{
				lEquals = lEquals && this.contact.equals( lTest.contact );
			}

			return lEquals;
		}
		else
		{
			return false;
		}
	}

	@Override
	public int hashCode()
	{
		int result = 17;

		result = 37*result + super.hashCode();

		result = 37*result + ((this.platformFamily != null) ? this.platformFamily.hashCode() : 0);

		result = 37*result + ((this.hardwareType != null) ? this.hardwareType.hashCode() : 0);

		result = 37*result + ((this.iconImage != null) ? this.iconImage.hashCode() : 0);

		result = 37*result + ((this.snmpPort != null) ? this.snmpPort.hashCode() : 0);

		result = 37*result + ((this.snmpCommunity != null) ? this.snmpCommunity.hashCode() : 0);

		result = 37*result + ((this.snmpVersion != null) ? this.snmpVersion.hashCode() : 0);

		result = 37*result + ((this.snmpTimeout != null) ? this.snmpTimeout.hashCode() : 0);

		result = 37*result + ((this.snmpRetryCount != null) ? this.snmpRetryCount.hashCode() : 0);

		result = 37*result + ((this.snmpProxy != null) ? this.snmpProxy.hashCode() : 0);

		result = 37*result + ((this.wbemUser != null) ? this.wbemUser.hashCode() : 0);

		result = 37*result + ((this.wbemUserPassword != null) ? this.wbemUserPassword.hashCode() : 0);

		result = 37*result + ((this.wbemPort != null) ? this.wbemPort.hashCode() : 0);

		result = 37*result + ((this.wbemProtocol != null) ? this.wbemProtocol.hashCode() : 0);

		result = 37*result + ((this.wbemTimeout != null) ? this.wbemTimeout.hashCode() : 0);

		result = 37*result + ((this.wbemRetryCount != null) ? this.wbemRetryCount.hashCode() : 0);

		result = 37*result + ((this.dhcpClient != null) ? this.dhcpClient.hashCode() : 0);

		result = 37*result + ((this.ipAddressType != null) ? this.ipAddressType.hashCode() : 0);

		result = 37*result + ((this.ipAddressVersion != null) ? this.ipAddressVersion.hashCode() : 0);

		result = 37*result + ((this.ipAddressV4 != null) ? this.ipAddressV4.hashCode() : 0);

		result = 37*result + ((this.ipAddressV6 != null) ? this.ipAddressV6.hashCode() : 0);

		result = 37*result + ((this.nodeName != null) ? this.nodeName.hashCode() : 0);

		result = 37*result + ((this.osName != null) ? this.osName.hashCode() : 0);

		result = 37*result + ((this.osRelease != null) ? this.osRelease.hashCode() : 0);

		result = 37*result + ((this.osVersion != null) ? this.osVersion.hashCode() : 0);

		result = 37*result + ((this.characterSet != null) ? this.characterSet.hashCode() : 0);

		result = 37*result + ((this.virtualizationNodeType != null) ? this.virtualizationNodeType.hashCode() : 0);

		result = 37*result + ((this.vmManagementNode != null) ? this.vmManagementNode.hashCode() : 0);

		result = 37*result + ((this.vmIndex != null) ? this.vmIndex.hashCode() : 0);

		result = 37*result + ((this.vmName != null) ? this.vmName.hashCode() : 0);

		result = 37*result + ((this.virtualizationSolution != null) ? this.virtualizationSolution.hashCode() : 0);

		result = 37*result + ((this.vmId != null) ? this.vmId.hashCode() : 0);

		result = 37*result + ((this.vmUser != null) ? this.vmUser.hashCode() : 0);

		result = 37*result + ((this.vmUserPassword != null) ? this.vmUserPassword.hashCode() : 0);

		result = 37*result + ((this.vmProtocol != null) ? this.vmProtocol.hashCode() : 0);

		result = 37*result + ((this.administrator != null) ? this.administrator.hashCode() : 0);

		result = 37*result + ((this.contact != null) ? this.contact.hashCode() : 0);

		return result;
	}

	/**
	 * デバイスのgetter
	 * @return ArrayList<NodeDeviceInfo>
	 */
	public ArrayList<NodeDeviceInfo> getNodeDeviceInfo() {
		return nodeDeviceInfo;
	}
	
	/**
	 * デバイスのsetter
	 * @param nodeDevice
	 */
	public void setNodeDeviceInfo(ArrayList<NodeDeviceInfo> nodeDeviceInfo) {
		this.nodeDeviceInfo = nodeDeviceInfo;
	}
	
	/**
	 * ファイルシステムのgetter
	 * @return ArrayList<NodeFilesystemInfo>
	 */
	public ArrayList<NodeFilesystemInfo> getNodeFilesystemInfo() {
		return nodeFilesystemInfo;
	}
	
	/**
	 * ファイルシステムのsetter
	 * @param nodeFilesystemInfo
	 */
	public void setNodeFilesystemInfo(
			ArrayList<NodeFilesystemInfo> nodeFilesystemInfo) {
		this.nodeFilesystemInfo = nodeFilesystemInfo;
	}
	
	/**
	 * ノード名のgetter
	 * @return ArrayList<NodeHostnameInfo>
	 */
	public ArrayList<NodeHostnameInfo> getNodeHostnameInfo() {
		return nodeHostnameInfo;
	}
	
	/**
	 * ノード名のsetter
	 * @param nodeHostnameInfo
	 */
	public void setNodeHostnameInfo(ArrayList<NodeHostnameInfo> nodeHostnameInfo) {
		this.nodeHostnameInfo = nodeHostnameInfo;
	}
	
	/**
	 * 備考のgetter
	 * @return ArrayList<NodeNoteInfo>
	 */
	public ArrayList<NodeNoteInfo> getNodeNoteInfo() {
		return nodeNoteInfo;
	}
	
	/**
	 * 備考のsetter
	 * @param nodeNoteInfo
	 */
	public void setNodeNoteInfo(ArrayList<NodeNoteInfo> nodeNoteInfo) {
		this.nodeNoteInfo = nodeNoteInfo;
	}

	/**
	 * 利用可能なIPアドレスを返します。
	 * 
	 * @return 利用可能なIPアドレス
	 * @throws UnknownHostException 
	 */
	public String getAvailableIpAddress() {
		// 「IPアドレスのバージョン」により指定されたIPアドレスを設定する。
		Integer ipVersion = getIpAddressVersion();
		String ipAddress = null;
		if(ipVersion != null && ipVersion.intValue() == 6){
			ipAddress = getIpAddressV6();
		} else {
			ipAddress = getIpAddressV4();
		}
		return ipAddress;
	}
}
