/*
 
 Copyright (C) 2009 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 */

package com.clustercontrol.performance.bean;

public class EstimationData {
	private final double _calcDataSize;
	private final double _total;
	private final double _reserved;
	private final double _used;
	
	public EstimationData(long calcDataSize, long total, long reserved, long used) {
		_calcDataSize = calcDataSize;
		_total = total;
		_reserved = reserved;
		_used = used;
	}

	public double getTotalMB() {
		return (double) _total / 1024 / 1024;
	}

	public double getReservedMB() {
		return (double) _reserved / 1024 / 1024;
	}

	public double getUsedMB() {
		return (double) _used / 1024 / 1024;
	}

	public double getFreeMB() {
		return (double)(_total - _reserved) / 1024 / 1024;
	}

	public double getCalcDataSizeMB() {
		return (double) _calcDataSize / 1024 / 1024;
	}
}
