/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.notify.bean;

import java.sql.Timestamp;
import java.util.ArrayList;

/**
 * 通知情報を保持するクラスです。
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class NotifyInfo
implements java.io.Serializable
{
	private static final long serialVersionUID = -4587823656729541121L;
	
	/** 通知ID。 */
	private java.lang.String m_notifyId;
	
	/** 説明。 */
	private java.lang.String m_description;
	
	/**
	 * 通知タイプ
	 * @see com.clustercontrol.bean.NotifyTypeConstant
	 */
	private java.lang.Integer m_notifyType;
	
	/**
	 * 初回通知までのカウント
	 */
	private java.lang.Integer m_initialCount;
	
	/**
	 * 再通知種別
	 */
	private java.lang.Integer m_renotifyType;

	/**
	 * 再通知抑制期間
	 */
	private java.lang.Integer m_renotifyPeriod;

	/** 作成日時。 */
	private java.sql.Timestamp m_regDate;
	
	/** 最終変更日時。 */
	private java.sql.Timestamp m_updateDate;
	
	/** 作成ユーザ　*/
	private String m_regUser;
	
	/** 最終更新ユーザ*/
	private String m_updateUser;
	
	/**有効無効フラグ*/
	private Integer m_validFlg;
	
	/** 通知イベント情報。 */
	private java.util.ArrayList<NotifyInfoDetail> m_notifyInfoDetail;
	
	/**
	 * コンストラクタ。
	 */
	public NotifyInfo() {
	}
	
	/**
	 * コンストラクタ。
	 * 
	 * @param notifyId 通知ID
	 * @param description 説明
	 * @param notiftType 通知タイプ
	 * @param setInitialCount 初回通知が実行されるまでの同一重要度カウンタ
	 * @param renotifyType 再通知種別
	 * @param renotifyPeriod 再通知抑制期間（分）
	 * @param regDate 作成日時
	 * @param updateDate 最終変更日時
	 * @param regUser 作成ユーザ
	 * @param updateUser 最終更新ユーザ
	 * @param validFlg 有効無効フラグ
	 * @param notifyInfoDetail<NotifyInfoDetail> 通知情報詳細
	 * 
	 * @see com.clustercontrol.bean.ValidConstant
	 * @see com.clustercontrol.bean.ExclusionConstant
	 * @see com.clustercontrol.bean.StatusExpirationConstant
	 * @see com.clustercontrol.bean.PriorityConstant
	 * @see com.clustercontrol.bean.StatusValidPeriodConstant
	 */
	public NotifyInfo(
			String notifyId,
			String description,
			Integer notifyType,
			Integer setInitialCount,
			Integer renotifyType,
			Integer renotifyPeriod,
			Timestamp regDate,
			Timestamp updateDate,
			String regUser,
			String updateUser,
			Integer validFlg,
			ArrayList<NotifyInfoDetail> notifyInfoDetail ) {
		
		setNotifyId(notifyId);
		setDescription(description);
		setNotifyType(notifyType);
		setInitialCount(setInitialCount);
		setRenotifyType(renotifyType);
		setRenotifyPeriod(renotifyPeriod);
		setRegDate(regDate);
		setUpdateDate(updateDate);
		setRegUser(regUser);
		setUpdateUser(updateUser);
		setValidFlg(validFlg);
	
		setNotifyInfoDetail(notifyInfoDetail);
	}
	

	/**
	 * コンストラクタ。
	 * 
	 * @param otherData コピー元の通知情報
	 */
	public NotifyInfo( NotifyInfo otherData ) {
		
		setNotifyId(otherData.getNotifyId());
		setDescription(otherData.getDescription());
		setNotifyType(otherData.getNotifyType());
		setInitialCount(otherData.getInitialCount());
		setRenotifyType(otherData.getRenotifyType());
		setRenotifyPeriod(otherData.getRenotifyPeriod());
		setRegDate(otherData.getRegDate());
		setUpdateDate(otherData.getUpdateDate());
		setRegUser(otherData.getRegUser());
		setUpdateUser(otherData.getUpdateUser());
		setNotifyInfoDetail(otherData.getNotifyInfoDetail());
		
	}
	
	/**
	 * 通知IDを返します。
	 * 
	 * @return 通知ID
	 */
	public String getNotifyId() {
		return this.m_notifyId;
	}
	
	/**
	 * 通知IDを設定します。
	 * 
	 * @param notifyId 通知ID
	 */
	public void setNotifyId( String notifyId ) {
		this.m_notifyId = notifyId;
	}
	
	/**
	 * 説明を返します。
	 * 
	 * @return 説明
	 */
	public String getDescription() {
		return this.m_description;
	}
	
	/**
	 * 説明を設定します。
	 * 
	 * @param description 説明
	 */
	public void setDescription( String description ) {
		this.m_description = description;
	}
	

	/**
	 * 通知タイプを取得します。
	 * @return
	 */
	public Integer getNotifyType(){
		
		return this.m_notifyType;
	}
	
	/**
	 * 通知タイプを設定します。
	 * 
	 * @param notifyType
	 */
	public void setNotifyType(Integer notifyType){
		this.m_notifyType=notifyType;
	}
	
	/**
	 * 初回通知するまでのカウント（この数以上同じ重要度の監視結果が連続した場合に始めて通知）を返します。
	 * 
	 * @return initialCount 初回通知するまでのカウント
	 */
	public Integer getInitialCount() {
		return this.m_initialCount;
	}
	
	/**
	 * 初回通知を設定します。
	 * 
	 * @param initialCount 抑制期間（分）
	 */
	public void setInitialCount( Integer initialCount ) {
		this.m_initialCount = initialCount;
	}
	
	/**
	 * 作成日時を返します。
	 * 
	 * @return 作成日時
	 */
	public java.sql.Timestamp getRegDate() {
		return this.m_regDate;
	}
	
	/**
	 * 作成日時を設定します。
	 * 
	 * @param regDate 作成日時
	 */
	public void setRegDate( java.sql.Timestamp regDate ) {
		this.m_regDate = regDate;
	}
	
	/**
	 * 最終変更日時を返します。
	 * 
	 * @return 最終変更日時
	 */
	public java.sql.Timestamp getUpdateDate() {
		return this.m_updateDate;
	}
	
	/**
	 * 最終変更日時を設定します。
	 * 
	 * @param updateDate 最終変更日時
	 */
	public void setUpdateDate( java.sql.Timestamp updateDate ) {
		this.m_updateDate = updateDate;
	}
	
	/**
	 * 登録ユーザを返します。
	 * 
	 * @return　登録ユーザ
	 */
	public String getRegUser(){	
		return this.m_regUser;
	}
	
   /**
    * 登録ユーザを設定します。
    * 
    * @param regUser
    */
	public void setRegUser(String regUser){
		this.m_regUser=regUser;
		
	}
	
	
	/**
	 * 最終更新ユーザを返します。
	 * 
	 * @return　最終更新ユーザ
	 */
	public String getUpdateUser(){
		
		return this.m_updateUser;
	}
	
   /**
    * 最終更新ユーザを設定します。
    * 
    * @param regUser
    */
	public void setUpdateUser(String updateUser){
		this.m_updateUser=updateUser;
		
	}
	
	
	/**
	 *  通知情報詳細を返します。
	 * 
	 * @return  通知情報詳細
	 * 
	 * @see com.clustercontrol.notify.bean.NotifyEventInfo
	 */
	public java.util.ArrayList<NotifyInfoDetail> getNotifyInfoDetail() {
		return this.m_notifyInfoDetail;
		
	}
	
	/**
	 *  通知情報詳細を設定します。
	 * 
	 * @param notifyInfoDetail 通知情報詳細
	 * 
	 * @see com.clustercontrol.notify.bean.NotifyEventInfo
	 */
	public void setNotifyInfoDetail(java.util.ArrayList<NotifyInfoDetail> notifyInfoDetail) {
		this.m_notifyInfoDetail = notifyInfoDetail;
	}

	/**
	 * 有効無効フラグを返します。
	 * 
	 * @return 有効無効フラグ
	 */
	public Integer getValidFlg() {
		return m_validFlg;
	}

	/**
	 * 有効無効フラグを設定します。
	 * @param vaildFlg
	 */
	public void setValidFlg(Integer validFlg) {
		this.m_validFlg = validFlg;
	}

	/**
	 * 再通知種別を返します。
	 * @return 再通知種別
	 */
	public java.lang.Integer getRenotifyType() {
		return m_renotifyType;
	}

	/**
	 * 再通知種別を設定します。
	 * @param m_renotify_type 再通知種別
	 */
	public void setRenotifyType(java.lang.Integer renotifyType) {
		this.m_renotifyType = renotifyType;
	}

	/**
	 * 再通知抑制期間を返します。
	 * @return 再通知抑制期間
	 */
	public java.lang.Integer getRenotifyPeriod() {
		return m_renotifyPeriod;
	}

	/**
	 * 再通知抑制期間を設定します。
	 * @param m_renotify_period 再通知抑制期間
	 */
	public void setRenotifyPeriod(java.lang.Integer renotifyPeriod) {
		this.m_renotifyPeriod = renotifyPeriod;
	}
}
