/*
 
Copyright (C) 2010 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.bean;

import java.io.Serializable;
import java.util.Date;

/**
 * 
 * ジョブ履歴のフィルタ
 *
 */
public class JobHistoryFilter implements Serializable{
	/**
	 * serialVersionUID
	 */
	private static final long serialVersionUID = -8999967944715277063L;
	
	private Date startFromDate = null;
	private Date startToDate = null;
	private Date endFromDate = null;
	private Date endToDate = null;
	private String jobId = null;
	private Integer status = null;
	private Integer triggerType = null;
	private String triggerInfo = null;
	
	public JobHistoryFilter(Date startFromDate, Date startToDate,
			Date endFromDate, Date endToDate, String jobId, Integer status,
			Integer triggerType, String triggerInfo) {
		super();
		this.startFromDate = startFromDate;
		this.startToDate = startToDate;
		this.endFromDate = endFromDate;
		this.endToDate = endToDate;
		this.jobId = jobId;
		this.status = status;
		this.triggerType = triggerType;
		this.triggerInfo = triggerInfo;
	}
	
	public JobHistoryFilter() {}

	public Date getStartFromDate() {
		return startFromDate;
	}

	public void setStartFromDate(Date startFromDate) {
		this.startFromDate = startFromDate;
	}

	public Date getStartToDate() {
		return startToDate;
	}

	public void setStartToDate(Date startToDate) {
		this.startToDate = startToDate;
	}

	public Date getEndFromDate() {
		return endFromDate;
	}

	public void setEndFromDate(Date endFromDate) {
		this.endFromDate = endFromDate;
	}

	public Date getEndToDate() {
		return endToDate;
	}

	public void setEndToDate(Date endToDate) {
		this.endToDate = endToDate;
	}

	public String getJobId() {
		return jobId;
	}

	public void setJobId(String jobId) {
		this.jobId = jobId;
	}

	public Integer getStatus() {
		return status;
	}

	public void setStatus(Integer status) {
		this.status = status;
	}

	public Integer getTriggerType() {
		return triggerType;
	}

	public void setTriggerType(Integer triggerType) {
		this.triggerType = triggerType;
	}

	public String getTriggerInfo() {
		return triggerInfo;
	}

	public void setTriggerInfo(String triggerInfo) {
		this.triggerInfo = triggerInfo;
	}
	
}
