/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.bean;


/**
 * ジョブ[履歴]ビューのテーブル定義を定数として定義するクラス<BR>
 * 
 * @version 2.4.0
 * @since 1.0.0
 */
public class HistoryTableDefine {

	/** 実行状態 */
	public static final int STATUS = 0;
	/** 終了状態 */
	public static final int END_STATUS = 1;
	/** 終了値 */
	public static final int END_VALUE = 2;
	/** セッションID */
	public static final int SESSION_ID = 3;
	/** ジョブID */
	public static final int JOB_ID = 4;
	/** ジョブ名 */
	public static final int JOB_NAME = 5;
	/** 所属ジョブユニットのジョブID */
	public static final int JOBUNIT_ID = 6;
	/** 種別 */
	public static final int JOB_TYPE = 7;
	/** ファシリティID */
	public static final int FACILITY_ID = 8;
	/** スコープ */
	public static final int SCOPE = 9;
	/** 開始予定日時 */
	public static final int SCHEDULED_START_TIME = 10;
	/** 開始・再実行日時 */
	public static final int START_RERUN_TIME = 11;
	/** 終了・中断日時 */
	public static final int END_SUSPEND_TIME = 12;
	/** 実行契機種別 */
	public static final int TRIGGER_TYPE = 13;
	/** 実行契機情報 */
	public static final int TRIGGER_INFO = 14;
	
	/** 初期表示時ソートカラム */
	public static final int SORT_COLUMN_INDEX = SESSION_ID;
	/** 初期表示時ソートオーダー (昇順=1, 降順=-1) */
	public static final int SORT_ORDER = -1;

}
