/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.agent;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.agent.util.RunHistoryUtil;
import com.clustercontrol.jobmanagement.bean.CommandConstant;
import com.clustercontrol.jobmanagement.bean.RunStatusConstant;
import com.clustercontrol.jobmanagement.message.RunInstructionInfo;
import com.clustercontrol.jobmanagement.message.RunResultInfo;

/**
 * チェックサムを行うスレッドクラス<BR>
 * 
 * 
 *
 * @version 2.1.0
 * @since 2.0.0
 */
public class CheckSumThread extends AgentThread {
	protected static final String ALGORITHM = "MD5";
	
	//ロガー
	private static Log log = LogFactory.getLog(CheckSumThread.class);
	
	/**
	 * コンストラクタ
	 * 
	 * @param props
	 */
	public CheckSumThread(
			RunInstructionInfo info, 
			SendQueue sendQueue, 
			Hashtable<String, Date> runHistory) {
		super(info, sendQueue, runHistory);
	}
	
	/* (non-Javadoc)
	 * @see java.lang.Runnable#run()
	 */
	@Override
	public void run() {
		log.debug("run start");
		
        Date startDate = new Date();
        
        //実行履歴に追加
		RunHistoryUtil.addRunHistory(m_info, m_runHistory, startDate);
		
		//---------------------------
		//-- 開始メッセージ送信
		//---------------------------
		
		//メッセージ作成
		RunResultInfo info = new RunResultInfo();
		info.setSessionId(m_info.getSessionId());
		info.setJobunitId(m_info.getJobunitId());
		info.setJobId(m_info.getJobId());
		info.setFacilityId(m_info.getFacilityId());
		info.setCommand(m_info.getCommand());
		info.setCommandType(m_info.getCommandType());
		info.setStatus(RunStatusConstant.START);
		info.setTime(startDate);
		
		log.info("run SessionID=" + m_info.getSessionId() + ", JobID=" + m_info.getJobId());
		
		//送信
		m_sendQueue.put(info);
		
		if(m_info.getCommand().equals(CommandConstant.GET_CHECKSUM)){
			String checksum = getCheckSum(m_info.getFilePath());
			if(checksum != null){
				info.setStatus(RunStatusConstant.END);
				info.setCheckSum(checksum);
				info.setTime(new Date());
				info.setErrorMessage("");
				info.setMessage("");
				info.setEndValue(0);
			}
			else{
				info.setStatus(RunStatusConstant.ERROR);
				info.setTime(new Date());
				info.setErrorMessage("");
				info.setMessage("");
				info.setEndValue(-1);
			}
		}
		else if(m_info.getCommand().equals(CommandConstant.CHECK_CHECKSUM)){
			String checksum = getCheckSum(m_info.getFilePath());
			if(checksum.equals(m_info.getCheckSum())){
				info.setStatus(RunStatusConstant.END);
				info.setTime(new Date());
				info.setErrorMessage("");
				info.setMessage("");
				info.setEndValue(0);
			}
			else{
				info.setStatus(RunStatusConstant.ERROR);
				info.setTime(new Date());
				info.setErrorMessage("");
				info.setMessage("");
				info.setEndValue(-1);
			}
		}
		
		//送信
		m_sendQueue.put(info);
		
        //実行履歴削除メッセージ送信
        sendDeleteHistory(info);
		
		log.debug("run end");
	}
	
	/**
	 * チェックサム取得
	 * 
	 * @param path
	 * @return
	 */
	protected String getCheckSum(String path) {
		log.debug("get checksum start");
		
		String checksum = null;
		
		try {
			MessageDigest md = MessageDigest.getInstance(ALGORITHM);
			
			FileInputStream inputStream = new FileInputStream(path);
			byte[] readData = new byte[256];
			int len;
			while ((len = inputStream.read(readData)) >=0) {
				md.update(readData, 0, len);
			}
			inputStream.close();
			
			checksum = changeString(md.digest());
			
		} catch (NoSuchAlgorithmException e) {
		} catch (FileNotFoundException e) {
		} catch (IOException e) {
		}
		
		log.debug("get checksum end");
		return checksum;
	}
	
	/**
	 * ハッシュ値を文字列に変換する
	 * 
	 * @param digest
	 * @return
	 */
	protected String changeString(byte[] digest) {
		StringBuilder hashString = new StringBuilder();
		for (int i = 0; i < digest.length; i++) {
			int d = digest[i];
			if (d < 0) {//負の値を補正
				d += 256;
			}
			if (d < 16) {//1けたは2けたする
				hashString.append("0");
			}
			hashString.append(Integer.toString(d, 16));//16進数2けたにする
		}
		return hashString.toString();
	}
}
