
/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.repository.factory;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;

import javax.ejb.FinderException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.SnmpVersionConstant;
import com.clustercontrol.repository.util.DataTable;
import com.clustercontrol.repository.util.SearchNodeProperties;
import com.clustercontrol.repository.util.SnmpPoller;
import com.clustercontrol.util.Messages;
import com.clustercontrol.util.PropertyUtil;
//import com.clustercontrol.sharedtable.bean.DataTable;
//import com.clustercontrol.snmppoller.SnmpPoller;

/**
 * SNMPでノードのデータを作成するクラス<BR>
 * @author miyamoto
 * @version 2.3.0
 * @since 2.1.2
 */

public class SearchNodeBySNMP {
	
	protected static Log m_log = LogFactory.getLog(SearchNodeBySNMP.class);
	
	private static final String OID_NAME      =".1.3.6.1.2.1.1.5.0";
	private static final String OID_DESCR     =".1.3.6.1.2.1.1.1.0";
	private static final String OID_CONTACT   =".1.3.6.1.2.1.1.4.0";
	
	//private static final String OID_DEV_NAME  =".1.3.6.1.2.1.25.3.2.1.3";
	//private static final String OID_DEV_INDEX =".1.3.6.1.2.1.25.3.2.1.1";
	//private static final String OID_DEV_TYPE  =".1.3.6.1.2.1.25.3.2.1.2";
	
	private static final String OID_DISK_INDEX=".1.3.6.1.4.1.2021.13.15.1.1.1";
	private static final String OID_DISK_NAME =".1.3.6.1.4.1.2021.13.15.1.1.2";
	private static final String OID_NIC_INDEX =".1.3.6.1.2.1.2.2.1.1";
	private static final String OID_NIC_NAME  =".1.3.6.1.2.1.2.2.1.2";
	private static final String OID_FILESYSTEM_INDEX = ".1.3.6.1.2.1.25.2.3.1.1";
	private static final String OID_FILESYSTEM_TYPE = ".1.3.6.1.2.1.25.2.3.1.2";
	private static final String OID_FILESYSTEM_NAME=   ".1.3.6.1.2.1.25.2.3.1.3";
	
	
	/**
	 * ノードの情報を探す。
	 * @param pollingData
	 * @param mode
	 * @param locale
	 * @return
	 */
	@SuppressWarnings("unchecked")
	public static  Property searchNode(Hashtable pollingData,int mode, Locale locale) throws FinderException, NamingException, UnknownHostException{
		
		//������� conf/repository_search_node.properties 
		//初期値でとりあえず初期化ե�����ͤ����
		
		SearchNodeProperties pollingProp = SearchNodeProperties.getProperties();
		int port					= pollingProp.getPort();
		int version 				= pollingProp.getVersion();
		String community 			= pollingProp.getCommunity();
		InetAddress ipAddress 	    = pollingProp.getAddress();
		int retries 				= pollingProp.getRetry();
		int timeout 				= pollingProp.getTimeOut();
		ArrayList oidList 		    = pollingProp.getOidList();
		
		
		//クライアントから受け取った設定値で上書き ��������
		try {
			ipAddress = InetAddress.getByName((String) pollingData.get("IPAddress"));		
		} catch (UnknownHostException e) {
			e.printStackTrace();
		}
		port = Integer.parseInt((String)pollingData.get("port"));
		community = (String)pollingData.get("community");
		version = ((Integer)pollingData.get("version")).intValue();
		
		//����DTO��poller����
		DataTable ret = new DataTable();
		SnmpPoller poller = new SnmpPoller();
		
		//pollingします。
		poller.polling(ipAddress, 
				port, 
				version, 
				community, 
				retries,
				timeout, 
				oidList, 
				ret);		
		//ポーリングした結果をつめるメソッドにまわします。�Ƶ�����
		return stractProperty(pollingData, ret, mode,locale);
	}
	
	/**
	 *  ノードのプロパティーを構成します。
	 * @param IPadder
	 * @param ret
	 * @param mode
	 * @param locale
	 * @return
	 */
	private static Property stractProperty(Hashtable pollingData,DataTable ret, int mode, Locale locale) throws FinderException, NamingException, UnknownHostException {
		
		
		//com.clustercontrol.bean.Property.javaを作ります。
		Property property = (new NodeProperty()).getProperty(mode, locale);
		ArrayList propertyList;
		
		//ノード情報"説明"の生成
		if(ret.getValue(OID_DESCR) != null){
			if(((String)ret.getValue(OID_DESCR).getValue()).length() !=0){
				
				propertyList = PropertyUtil.getProperty(property, NodeProperty.DESCRIPTION);
				((Property)propertyList.get(0)).setValue("Auto detect at " + (new Date()).toString());
			}
		}
		
		
		try {
			String ipAddressString = (String)pollingData.get("IPAddress");
			InetAddress address = InetAddress.getByName(ipAddressString);
			int ipAddressVersion = 0;
			
			if (address instanceof Inet4Address){
				//IPv4の場合はさらにStringをチェック
				if (ipAddressString.matches(".{1,3}?\\..{1,3}?\\..{1,3}?\\..{1,3}?")){
					propertyList = PropertyUtil.getProperty(property, NodeProperty.IP_ADDRESS_V4);
					((Property)propertyList.get(0)).setValue((String)pollingData.get("IPAddress"));
					ipAddressVersion = 4;
				}
			
			} else if (address instanceof Inet6Address){
				propertyList = PropertyUtil.getProperty(property, NodeProperty.IP_ADDRESS_V6);
				((Property)propertyList.get(0)).setValue((String)pollingData.get("IPAddress"));
				ipAddressVersion = 6;
			}
			
			//IPアドレスのバージョン
			propertyList = PropertyUtil.getProperty(property, NodeProperty.IP_ADDRESS_VERSION);
			((Property)propertyList.get(0)).setValue(new Integer(ipAddressVersion));
		} catch (UnknownHostException e) {
			m_log.error(e.getMessage());
			throw e;
		}
		
		
		//SNMP関連データの設定
		propertyList = PropertyUtil.getProperty(property, NodeProperty.SNMP_PORT);
		((Property)propertyList.get(0)).setValue(Integer.valueOf(Integer.parseInt((String)pollingData.get("port"))));
		
		propertyList = PropertyUtil.getProperty(property, NodeProperty.SNMP_COMMUNITY);
		((Property)propertyList.get(0)).setValue((String)pollingData.get("community"));
		
		
		propertyList = PropertyUtil.getProperty(property, NodeProperty.SNMP_VERSION);
		((Property)propertyList.get(0)).setValue(SnmpVersionConstant.typeToString((Integer)pollingData.get("version")));
		
		
		//hostname の設定
		if(ret.getValue(OID_NAME) != null){
			String hostname = (String)ret.getValue(OID_NAME).getValue();
			if(hostname.length() != 0){
				//hosname.domainであればhostnameだけを入力
				if(hostname.indexOf(".") != -1){
					hostname = hostname.substring(0,hostname.indexOf("."));
				}
				//ホスト名、ノード名にそれぞれ設定
				propertyList = PropertyUtil.getProperty(property, NodeProperty.HOST_NAME);
				((Property)propertyList.get(0)).setValue(hostname);
				propertyList = PropertyUtil.getProperty(property, NodeProperty.NODE_NAME);
				((Property)propertyList.get(0)).setValue(hostname);
			}
		}
		
		
		//連絡先はsnmpd.confに書かれている内容を設定する。
		if(ret.getValue(OID_CONTACT) != null){
			if(((String)ret.getValue(OID_CONTACT).getValue()).length() != 0){
				propertyList = PropertyUtil.getProperty(property, NodeProperty.ADMINISTRATOR);
				((Property)propertyList.get(0)).setValue((String)ret.getValue(OID_CONTACT).getValue());
			}
		}	
		
		//OSカテゴリの設定
		boolean isWindows = false;

		//プラットフォーム名は、Windows, Linux, Solaris以外はOtherとする
		String platform = "OTHER";

		if(ret.getValue(OID_DESCR) != null){
			String description = ((String)ret.getValue(OID_DESCR).getValue()); 
			if(description.length() != 0){
				String OsName = "";
				
				//OSの種別はキーワードマッチで行う
				
				if(description.matches(".*indows.*")){
					OsName = "Windows";
					platform = "WINDOWS";
					isWindows=true;
				}else if(description.matches(".*inux.*")){
					OsName = "Linux";
					platform = "LINUX";
				}else if(description.matches(".*SunOS.*") || description.matches("Solaris")){
					OsName= "Solaris";
					platform = "SOLARIS";
				}else{
					if(description.indexOf(" ") != -1){
						OsName = description.substring(0,description.indexOf(" "));
					}
				}
				
				//OS名は上の判定ロジックを利用した値を設定
				propertyList = PropertyUtil.getProperty(property, NodeProperty.OS_NAME);
				((Property)propertyList.get(0)).setValue(OsName);
				
				//OSのリリースは
				//propertyList = PropertyUtil.getProperty(property, NodeProperty.OS_RELEASE);
				//((Property)propertyList.get(0)).setValue(description);
				
				//OSバージョン
				propertyList = PropertyUtil.getProperty(property, NodeProperty.OS_VERSION);
				((Property)propertyList.get(0)).setValue(description);
				
				//result.put(FacilityAttributeConstant.MACHINE,description);
				
				//result.put( FacilityAttributeConstant.CHARSET,description);
			}
		}
		
		// プラットフォームファミリー
		// デフォルト値はOTHER
		propertyList = PropertyUtil.getProperty(property, NodeProperty.PLATFORM_FAMILY_NAME);
		((Property)propertyList.get(0)).setValue(platform);

		
		
		//propertyListの中にdevicPropertyが入っていてその中に設定を行っていく。
		
		propertyList = PropertyUtil.getProperty(property, NodeProperty.DEVICE);
		Property deviceProperty = (Property)propertyList.get(0);
		int index = PropertyUtil.getPropertyIndex(property, deviceProperty);
		
		
		
		HashMap<String, Boolean> diskNameDuplicateSet = createDiskNameDuplicateSet(ret);
		HashMap<String, Boolean> nicNameDuplicateSet = createNicNameDuplicateSet(ret, isWindows);
		
		
		
		// ノード作成時、「デバイス」の入力項目が１つ存在するため、
		// カウンタを利用して、既存項目として入力するか、新規項目として入力するかを判定する
		int deviceCount=0;
		
		/*
		 * OIDインデックスの最大値を検索する。
		 * 本来はHinemos3.2のような実装にすべきだが、Hinemos3.0,3.1と3.2の
		 * ソースコードは大きく異なるため流用はできない。
		 * 3.1,3.0では、きれいではないが、デグレの可能性の低い修正とする。
		 */
		int maxI = 1;
		for (Object tmpOid : ret.keySet()) {
			String tmpStr = (String)tmpOid;
			if (tmpStr.indexOf(OID_DISK_INDEX) == -1) {
				continue;
			}
			String tmpI = tmpStr.substring(tmpStr.lastIndexOf(".") + 1);
			if (maxI < Integer.parseInt(tmpI)) {
				maxI = Integer.parseInt(tmpI);
			}
		}
		m_log.info("stractProperty maxI(disk)=" + maxI);
		
		// Diskの情報を設定
		for (int i = 1; i <= maxI; i++) {
			
			// OID_DISK_INDEX=".1.3.6.1.4.1.2021.13.15.1.1.1";
			// OID_DISK_NAME =".1.3.6.1.4.1.2021.13.15.1.1.2";
			String oidCounter = OID_DISK_INDEX+"."+i;
			
			if( ret.getValue(oidCounter) != null){
				if(((String)ret.getValue(oidCounter).getValue()).length() != 0 ){
					String disk = (String)ret.getValue(OID_DISK_NAME+"."+i).getValue();
					
					//ramディスクは除外します。
					if(!(disk.startsWith("ram"))){
						
						Property diskProperty = null;
						
						if(deviceCount == 0){
							// 既存入力項目としての「デバイス」にセットする場合
							diskProperty = deviceProperty;
							
						} else {
							// 2つめ以降はコピーをした状況からスタート
							diskProperty = PropertyUtil.copy(deviceProperty);
						}
						
						// デバイス名が重複している場合は、(OIDインデックス)をつける
						if (diskNameDuplicateSet != null && diskNameDuplicateSet.get(disk) != null && diskNameDuplicateSet.get(disk)){
							disk = disk + "(" + i + ")";
						}
						// デバイス
						diskProperty.setValue(disk);
//						diskProperty.setValue((String)ret.getValue(OID_DISK_NAME+"."+i).getValue());
						// デバイス名
						propertyList = PropertyUtil.getProperty(diskProperty, NodeProperty.DEVICE_NAME);
						((Property)propertyList.get(0)).setValue(disk);
//						((Property)propertyList.get(0)).setValue(((String)ret.getValue(OID_DISK_NAME+"."+i).getValue()));
						// デバイスインデックス
						propertyList = PropertyUtil.getProperty(diskProperty, NodeProperty.DEVICE_INDEX);
						((Property)propertyList.get(0)).setValue(Integer.parseInt(((String)ret.getValue(OID_DISK_INDEX+"."+i).getValue())));
						// デバイス種別
						propertyList = PropertyUtil.getProperty(diskProperty, NodeProperty.DEVICE_TYPE);
						((Property)propertyList.get(0)).setValue("disk");
						
						
						if (deviceCount != 0){
							// 2つめ以降の場合は、子要素として追加
							property.addChildren(diskProperty, index + deviceCount);
						}
						
						deviceCount++;
					}
				}
			}
		}
		
		
		//NICのインデックスがWindowsの場合には連続ではないので、
		//とってきたすべての値からNICの情報を検索します。
		
		Iterator itr = ret.keySet().iterator();
		while(itr.hasNext()){
			String fullOid = (String)itr.next();
			
			//OID_NIC_INDEX =".1.3.6.1.2.1.2.2.1.1";
			//OID_NIC_NAME  =".1.3.6.1.2.1.2.2.1.2";
			
			if(fullOid.startsWith(OID_NIC_INDEX)){//NIC情報で始まるか判定
				
				String tmpIndex = fullOid.substring(fullOid.lastIndexOf("."));
				String deviceName = "";
				
				if( ((String)ret.getValue(fullOid).getValue()).length() != 0 ){
					
					deviceName = convString((String)ret.getValue(OID_NIC_NAME+tmpIndex).getValue(),isWindows);
//					deviceName = convString((String)ret.getValue(OID_NIC_NAME+tmpIndex).getValue(),isWindows) + "(" + tmpIndex + ")";
					
					Property nicProperty = null;
					
					if(deviceCount == 0){
						// デバイスの設定
						nicProperty = deviceProperty;
						
					} else {
						nicProperty = PropertyUtil.copy(deviceProperty);
					}
					
					// デバイス名が重複している場合は、(OIDインデックス)をつける
					if (nicNameDuplicateSet != null && nicNameDuplicateSet.get(deviceName) != null && nicNameDuplicateSet.get(deviceName)){
						deviceName = deviceName + "(" + tmpIndex + ")";
					}
					// デバイスの設定
					nicProperty.setValue(deviceName);
					// デバイス名の設定
					propertyList = PropertyUtil.getProperty(nicProperty, NodeProperty.DEVICE_NAME);
					((Property)propertyList.get(0)).setValue(deviceName);
					// デバイスINDEXの設定
					propertyList = PropertyUtil.getProperty(nicProperty, NodeProperty.DEVICE_INDEX);
					((Property)propertyList.get(0)).setValue(Integer.parseInt(((String)ret.getValue(OID_NIC_INDEX+tmpIndex).getValue())));
					// デバイスTypeの設定
					propertyList = PropertyUtil.getProperty(nicProperty, NodeProperty.DEVICE_TYPE);
					((Property)propertyList.get(0)).setValue("nic");
					
					if (deviceCount != 0) {
						// 2つめ以降の場合は、子要素として追加
						property.addChildren(nicProperty, index + deviceCount);
					}
					
					deviceCount++;	
				}
			}
		}
		
		//ファイルシステム
		propertyList = PropertyUtil.getProperty(property, NodeProperty.FILE_SYSTEM);
		Property fileSystemProperty = (Property)propertyList.get(0);
		index = PropertyUtil.getPropertyIndex(property, fileSystemProperty);
		
		deviceCount=0;
		
		maxI = 1;
		for (Object tmpOid : ret.keySet()) {
			String tmpStr = (String)tmpOid;
			if (tmpStr.indexOf(OID_FILESYSTEM_INDEX) == -1) {
				continue;
			}
			String tmpI = tmpStr.substring(tmpStr.lastIndexOf(".") + 1);
			if (maxI < Integer.parseInt(tmpI)) {
				maxI = Integer.parseInt(tmpI);
			}
		}
		m_log.info("stractProperty maxI(FS)=" + maxI);
		
		for (int i = 0; i <= maxI; i++){
			// OID_FILESYSTEM_INDEX = ".1.3.6.1.2.1.25.2.3.1.1";
			// OID_FILESYSTEM_NAME  = ".1.3.6.1.2.1.25.2.3.1.3";
			String oidCounter = OID_FILESYSTEM_INDEX+"."+i;
			
			if( ret.getValue(oidCounter) != null){
				if( ((String)ret.getValue(oidCounter).getValue()).length() != 0 ){
					
					//hrStrageFixedDiskの場合のみノード情報に追加
					//.1.3.6.1.2.1.25.2.1.4←hrStrageFixedDisk
					
					String strageType =  ret.getValue(OID_FILESYSTEM_TYPE+"."+i).getValue().toString();
					
					if(strageType.equals(".1.3.6.1.2.1.25.2.1.4")){
						
						Property copyOfFileSystemProperty = null;
						
						if(deviceCount == 0){
							copyOfFileSystemProperty = fileSystemProperty;
							
						} else {
							copyOfFileSystemProperty = PropertyUtil.copy(fileSystemProperty);
						}
						
						
						//ファイルシステムと書いてあるところにマウントポイントを表示
						copyOfFileSystemProperty.setValue(convStringFilessystem((String)ret.getValue(OID_FILESYSTEM_NAME+"."+i).getValue()));
						
						//�ǥХ���̾
						propertyList = PropertyUtil.getProperty(copyOfFileSystemProperty, NodeProperty.FILE_SYSTEM_MOUNT_POINT);
						((Property)propertyList.get(0)).setValue(convStringFilessystem(((String)ret.getValue(OID_FILESYSTEM_NAME+"."+i).getValue())));
						//�ǥХ���INDEX
						propertyList = PropertyUtil.getProperty(copyOfFileSystemProperty, NodeProperty.FILE_SYSTEM_INDEX);
						((Property)propertyList.get(0)).setValue(Integer.parseInt(((String)ret.getValue(OID_FILESYSTEM_INDEX+"."+i).getValue())));
						
						if (deviceCount != 0) {
							property.addChildren(copyOfFileSystemProperty, index + deviceCount);
						}
						
						
						deviceCount++;
						
					}
				}
			}
		}
		
		return property;
	}
	
	
	/**
	 * OIDとデバイスの名前を変換します。
	 * このメソッドは現在(ver2.3.0)のバージョンでは使用しません。
	 * @param deviceOID
	 * @return
	 */
	/*private static String convDevice(String deviceOID){
	 String ret = null;
	 
	 if(deviceOID.equals(".1.3.6.1.2.1.25.3.1.1")){
	 ret = "Other";
	 }else if (deviceOID.equals(".1.3.6.1.2.1.25.3.1.2")){
	 ret = "Unknown";
	 }else if (deviceOID.equals(".1.3.6.1.2.1.25.3.1.3")){
	 ret = "Processor";
	 }else if (deviceOID.equals(".1.3.6.1.2.1.25.3.1.4")){
	 ret = "Network";
	 }else if (deviceOID.equals(".1.3.6.1.2.1.25.3.1.5")){
	 ret = "Printer";
	 }else if (deviceOID.equals(".1.3.6.1.2.1.25.3.1.6")){
	 ret = "DiskStorage";
	 }else if (deviceOID.equals(".1.3.6.1.2.1.25.3.1.10")){
	 ret = "Video";
	 }else if (deviceOID.equals(".1.3.6.1.2.1.25.3.1.11")){
	 ret = "Audio";
	 }else if (deviceOID.equals(".1.3.6.1.2.1.25.3.1.12")){
	 ret = "Coprocessor";
	 }else if (deviceOID.equals(".1.3.6.1.2.1.25.3.1.13")){
	 ret = "Keyboard";
	 }else if (deviceOID.equals(".1.3.6.1.2.1.25.3.1.14")){
	 ret = "Modem";
	 }else if (deviceOID.equals(".1.3.6.1.2.1.25.3.1.15")){
	 ret = "ParallelPor";
	 }else if (deviceOID.equals(".1.3.6.1.2.1.25.3.1.16")){
	 ret = "Pointing";
	 }else if (deviceOID.equals(".1.3.6.1.2.1.25.3.1.17")){
	 ret = "SerialPort";
	 }else if (deviceOID.equals(".1.3.6.1.2.1.25.3.1.18")){
	 ret = "Tape";
	 }else if (deviceOID.equals(".1.3.6.1.2.1.25.3.1.19")){
	 ret = "Clock";
	 }else if (deviceOID.equals(".1.3.6.1.2.1.25.3.1.20")){
	 ret = "VolatileMemory";
	 }else if (deviceOID.equals(".1.3.6.1.2.1.25.3.1.21")){
	 ret = "NonVolatileMemory ";
	 }else{
	 ret = "Unknow"; 
	 }
	 return ret;
	 
	 }*/
	
	private static String convString(String str, boolean isWindows){
		
		
		
		
		if(!isWindows){
			String ret;
			//Windowsではない時には、LDAPの禁止文字以外の文字に置換
			ret = str.replaceAll("/"," ");
			ret=ret.replaceAll("\\\\", " ");
			ret=ret.replaceAll(";" , " ");
			ret=ret.replaceAll("," , " ");
			ret=ret.replaceAll("<" , " ");
			ret=ret.replaceAll(">" , " ");
			ret=ret.replaceAll("\\\\+" , " ");
			ret=ret.replaceAll("\"" , " ");
			return ret;
			
		}else{
			
			//strはなぜかASCIIが16進で入っている。
			
			char[] chars;
			short  first;
			short second;
			chars=str.toCharArray();
//			char ret[] = new char[chars.length/3 + 1]; 
			
			StringBuffer retStr = new StringBuffer();
			
			int j=0;
			for(int i = 0; i<chars.length;){
				
				
				first  = (short) (chars[i] - 48); //48は"0"なので、"1"→1の変換	
				second = (short)(chars[i+1]- 48);
				
				if(second >10){
					//16進でA-Fの場合には、さらに7を引く
					//10 ⇔ A(16進)なので("A"→65)を10にする、 10 = "A"(65) - "0"(48) - 7
					second -=7;
				}
				
				
//				ret[j] = (char) (first*16+second);
				retStr.append((char) (first*16+second));
				
				i+=3;//1文字は"56 "とかで構成するので、配列2つを読んで" "をスキップ
				j++;//リターンも文字もインクリメント
			}
			
//			return (new String(ret));
			// 変換後の文字列の最終文字がnullであるため、それを除外
			
			String ret = retStr.substring(0, retStr.length()-1);
			
			//登録できない文字を変換
			ret=ret.replaceAll("/"," ");
			ret=ret.replaceAll("\\\\", " ");
			ret=ret.replaceAll(";" , " ");
			ret=ret.replaceAll("," , " ");
			ret=ret.replaceAll("<" , " ");
			ret=ret.replaceAll(">" , " ");
			ret=ret.replaceAll("\\\\+" , " ");
			ret=ret.replaceAll("\"" , " ");
			
			return ret;
			
		}
		
	}
	
	private static String convStringFilessystem(String str){
		
		
//		char ret[] = new char[chars.length/3 + 1]; 
		
		String returnString ;
		
		if(str.matches("/.*")){
			//UNIX系OSの場合
			return str;
		}
		else if(str.matches("[A-Z]:\\\\.*")){
			//ドライブレターが先頭にある場合は
			//そのドライブレターのみを取得
			
			returnString = str.substring(0,3);
			
			return returnString;
		}
		else{
//			strはなぜかASCIIが16進で入っている。
			//文字が化けて入力された場合には、変換を行う。
			
			System.out.println(str);
			
			char[] chars;
			short  first;
			short second;
			chars=str.toCharArray();
			StringBuffer ret = new StringBuffer();
			
			int j=0;
			
			for(int i = 0; i<chars.length;){
				
				
				first  = (short) (chars[i] - 48); //48は"0"なので、"1"→1の変換	
				second = (short)(chars[i+1]- 48);
				
				if(second >10){
					//16進でA-Fの場合には、さらに7を引く
					//10 ⇔ A(16進)なので("A"→65)を10にする、 10 = "A"(65) - "0"(48) - 7
					second -=7;
				}
				
				
//				ret[j] = (char) (first*16+second);
				ret.append((char) (first*16+second));
				
				i+=3;//1文字は"56 "とかで構成するので、配列2つを読んで" "をスキップ
				j++;//リターンも文字もインクリメント
			}
			
//			return (new String(ret));
			
			
			return ret.substring(0,3);
		}
		
	}
	
	
	private static HashMap<String, Boolean> createDiskNameDuplicateSet(DataTable dataTable){
		HashMap<String, Boolean> ret = new HashMap<String, Boolean>();
		
		
		int i = 1;
		
		while (true) {
			
			// OID_DISK_INDEX=".1.3.6.1.4.1.2021.13.15.1.1.1";
			// OID_DISK_NAME =".1.3.6.1.4.1.2021.13.15.1.1.2";
			String oidCounter = OID_DISK_INDEX+"."+i;
			
			if( dataTable.getValue(oidCounter) != null){
				if(((String)dataTable.getValue(oidCounter).getValue()).length() != 0 ){
					String disk = (String)dataTable.getValue(OID_DISK_NAME+"."+i).getValue();
					
					//ramディスクは除外します。
					if(!(disk.startsWith("ram"))){
						
						// デバイス名
						String diskName = (String)dataTable.getValue(OID_DISK_NAME+"."+i).getValue();
						
						Boolean isDuplicate = ret.get(diskName);
						if (isDuplicate == null) {
							ret.put(diskName, false);
						} else if (!isDuplicate) {
							ret.put(diskName, true);
						}
					}
					
					i++;
					
				} else {
					break;
				}
			} else {
				break;
			}
		}
		
		
		return ret;
	}
	
	private static HashMap<String, Boolean> createNicNameDuplicateSet(DataTable dataTable, boolean isWindows){
		HashMap<String, Boolean> ret = new HashMap<String, Boolean>();
		
		
		Iterator itr = dataTable.keySet().iterator();
		while(itr.hasNext()){
			String fullOid = (String)itr.next();
			
			//OID_NIC_INDEX =".1.3.6.1.2.1.2.2.1.1";
			//OID_NIC_NAME  =".1.3.6.1.2.1.2.2.1.2";
			
			if(fullOid.startsWith(OID_NIC_INDEX)){//NIC情報で始まるか判定
				
				String tmpIndex = fullOid.substring(fullOid.lastIndexOf("."));
				
				if( ((String)dataTable.getValue(fullOid).getValue()).length() != 0 ){
					
					String nicName = convString((String)dataTable.getValue(OID_NIC_NAME+tmpIndex).getValue(),isWindows);
					
					Boolean isDuplicate = ret.get(nicName);
					if (isDuplicate == null) {
						ret.put(nicName, false);
					} else if (!isDuplicate) {
						ret.put(nicName, true);
					}
					
				}
			}
		}
		
		return ret;
	}
	
}
