/*

 Copyright (C) 2006 NTT DATA Corporation

 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 */

package com.clustercontrol.performance.monitor.ejb.entity;

import javax.ejb.EntityBean;

import com.clustercontrol.performance.monitor.ejb.entity.CollectorSnmpMstPK;

/**
 * 収集毎の収集項目の情報を保持するEntity Bean <BR>
 * @ejb.bean name="CollectorSnmpMst"
 *           jndi-name="CollectorSnmpMst"
 *           type="CMP"
 *           schema="CollectorSnmpMst" 
 *           cmp-version="2.x"
 *           data-source="java:/HinemosDS"
 *           primkey-field="platformId","itemCode","variableId"
 *           
 *  @jboss.depends name="jboss.jca:service=DataSourceBinding,name=HinemosDS"
 *  
 *  @jboss.read-only read-only="true"
 *  
 *  @ejb.permission
 *     unchecked="true"
 *     
 *  @ejb.persistence 
 *   table-name="cc_collector_snmp_mst"  
 *           
 *  @ejb.finder 
 *    query="SELECT OBJECT(a) FROM CollectorSnmpMst as a"  
 *    signature="java.util.Collection findAll()"  
 *
 *  @ejb.finder 
 *    query="SELECT OBJECT(a) FROM CollectorSnmpMst as a where a.platformId = ?1 AND a.itemCode = ?2"  
 *    signature="java.util.Collection findByPlatformIdAndItemCode(java.lang.String platformId, java.lang.String itemCode)"  
 *
 *  @ejb.pk class="com.clustercontrol.performance.monitor.ejb.entity.CollectorSnmpMstPK"
 */
public abstract class CollectorSnmpMstBean implements EntityBean {
	
	/**
	 *
	 * <!-- begin-user-doc -->
	 * The  ejbCreate method.
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.create-method 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public CollectorSnmpMstPK ejbCreate(
			String platformId,
			String itemCode,
			String variableId,
			String tableOid,
			String oidIndex,
			String valueType,
			String pollingOid,
			String failureValue
			) throws javax.ejb.CreateException {
		
		this.setPlatformId(platformId);
		this.setItemCode(itemCode);
		this.setVariableId(variableId);
		this.setTableOid(tableOid);
		this.setOidIndex(oidIndex);
		this.setValueType(valueType);
		this.setPollingOid(pollingOid);
		this.setFailureValue(failureValue);

		return null;
	}
	
	/**
	 * コンストラクター
	 * @param platformId プラットフォーム
	 * @param itemCode 収集項目コード
	 * @param variableId 変数名
	 * @param tableOid OIDベース
	 * @param oidIndex OIDインデックス
	 * @param valueType 値の型
	 * @param pollingOid ポーリング対象OID
	 * @param failureValue 取得失敗時の値
	 * @throws javax.ejb.CreateException
	 */
	public void ejbPostCreate(
			String platformId,
			String itemCode,
			String variableId,
			String tableOid,
			String oidIndex,
			String valueType,
			String pollingOid,
			String failureValue
			) throws javax.ejb.CreateException {
	}
	
	/**
	 * プラットフォームを取得します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="platform_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 * @ejb.pk-field 
	 * 
	 * @ejb.interface-method
	 * 
	 * @jboss.method-attributes read-only="true"
	 * 
	 * @return Returns the platformId.
	 */
	public abstract String getPlatformId();

	/**
	 * プラットフォームを設定します。
	 * 
	 * @param platformId The platformId to set.
	 */
	public abstract void setPlatformId(String platformId);

	/**
	 * 収集項目コードを取得します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="item_code"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(256)"
	 *     read-only="false"
	 * @ejb.pk-field 
	 * 
	 * @ejb.interface-method
	 * 
	 * @jboss.method-attributes read-only="true"
	 * 
	 * @return Returns the itemCode.
	 */
	public abstract String getItemCode();

	/**
	 * 収集項目コードを設定します。
	 * 
	 * @param itemCode The itemCode to set.
	 */
	public abstract void setItemCode(String itemCode);

	/**
	 * 変数名を取得します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="variable_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 * @ejb.pk-field 
	 * 
	 * @ejb.interface-method
	 * 
	 * @jboss.method-attributes read-only="true"
	 * 
	 * @return Returns the variableId.
	 */
	public abstract String getVariableId();

	/**
	 * 変数名を設定します。
	 * 
	 * @param variableId The variableId to set.
	 */
	public abstract void setVariableId(String variableId);

	/**
	 * OIDベースを取得します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="table_oid"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(1024)"
	 *     read-only="false"
	 * 
	 * @ejb.interface-method
	 * 
	 * @jboss.method-attributes read-only="true"
	 * 
	 * @return Returns the tableOid.
	 */
	public abstract String getTableOid();

	/**
	 * OIDベースを設定します。
	 * 
	 * @param tableOid The tableOid to set.
	 */
	public abstract void setTableOid(String tableOid);

	/**
	 * OIDインデックスを取得します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="oid_index"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(256)"
	 *     read-only="false"
	 * 
	 * @ejb.interface-method
	 * 
	 * @jboss.method-attributes read-only="true"
	 * 
	 * @return Returns the oidIndex.
	 */
	public abstract String getOidIndex();

	/**
	 * OIDインデックスを設定します。
	 * 
	 * @param oidIndex The oidIndex to set.
	 */
	public abstract void setOidIndex(String oidIndex);

	/**
	 * 値の型を取得します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="value_type"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(256)"
	 *     read-only="false"
	 * 
	 * @ejb.interface-method
	 * 
	 * @jboss.method-attributes read-only="true"
	 * 
	 * @return Returns the valueType.
	 */
	public abstract String getValueType();

	/**
	 * 値の型を設定します。
	 * 
	 * @param valueType The valueType to set.
	 */
	public abstract void setValueType(String valueType);

	/**
	 * ポーリングIDを取得します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="polling_oid"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(1024)"
	 *     read-only="false"
	 * 
	 * @ejb.interface-method
	 * 
	 * @jboss.method-attributes read-only="true"
	 * 
	 * @return Returns the pollingOid.
	 */
	public abstract String getPollingOid();

	/**
	 * ポーリングIDを設定します。
	 * 
	 * @param pollingOid The pollingOid to set.
	 */
	public abstract void setPollingOid(String pollingOid);

	/**
	 * 取得失敗時の値を取得します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="failure_value"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(256)"
	 *     read-only="false"
	 * 
	 * @ejb.interface-method
	 * 
	 * @jboss.method-attributes read-only="true"
	 * 
	 * @return Returns the failureValue.
	 */
	public abstract String getFailureValue();

	/**
	 * 取得失敗時の値を設定します。
	 * 
	 * @param failureValue The failureValue to set.
	 */
	public abstract void setFailureValue(String failureValue);

}
