/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 */

package com.clustercontrol.performance.view;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

import com.clustercontrol.bean.FacilityConstant;
import com.clustercontrol.bean.FacilityTreeItem;
import com.clustercontrol.performance.action.RecordController;
import com.clustercontrol.performance.bean.GraphConstant;
import com.clustercontrol.performance.composite.RecordGraphHolderComposite;
import com.clustercontrol.performance.composite.action.RecordSetGraphSelectionChangedListener;
import com.clustercontrol.performance.preference.PerformancePreferencePage;
import com.clustercontrol.performance.util.CollectorItemCodeFactory;
import com.clustercontrol.performance.util.Messages;
import com.clustercontrol.performance.util.RealtimeCollectorInfo;
import com.clustercontrol.performance.util.RealtimeCollectorItemInfo;
import com.clustercontrol.performance.view.action.RecordSetGraphAction;
import com.clustercontrol.performance.view.action.RecordSetGraphAction2;
import com.clustercontrol.performance.bean.CollectorItemInfo;
import com.clustercontrol.performance.bean.CollectorProperty;
import com.clustercontrol.performance.bean.GraphProperty;
import com.clustercontrol.view.ScopeListBaseView;
/**
 * 実績グラフ表示を行うViewクラス
 * 
 * @version 1.0
 * @since 1.
 */
public class RecordGraphView extends ScopeListBaseView {

    public static final String ID = "com.clustercontrol.performance.view.RecordGraphView";

    // 表示できるグラフの最大数
    private static int MAX_GRAPH_NUM = 4;
    
    // グラフ描画処理を委譲する
    // 現在表示しているファシリティ、収集項目の情報もこのインスタンスで管理
    private RecordGraphHolderComposite graphHolderComposite = null;

//    public RealtimeGraphComposite graphComposite = null;

    // グラフ表示対象の収集設定
    private CollectorProperty collectorProperty;

    //グラフ表示の基本情報(表示間隔など)を保持する領域を確保する。
    public RealtimeCollectorInfo collectorInfo;

    public RealtimeCollectorItemInfo collectorItemInfo;

    private Composite parent;
    
    // 現在グラフ表示しているスコープ
	public FacilityTreeItem currentTreeItem;
    
	private PerformancePreferencePage perfPrePage;
	
    // staticでなければ、ダイアログ経由で停止することができない。
//    static private boolean isRequestCollectorToRun = false;
	
    /**
     *  コンストラクタ
     */
    public RecordGraphView() {
    	// ノードを含め、INTERNAL, UNREGISTEREDを含めず, TOPICを受信しないスコープツリーとする
        super(false, false, false, false);
        initialize();
    }

    
    private void initialize() {

        //グラフ表示の基本情報(表示間隔など)を保持する領域を確保する。
        collectorInfo = new RealtimeCollectorInfo();
        //グラフ表示の表示データ基本情報(表示間隔など)を保持する領域を確保する。
        collectorItemInfo = new RealtimeCollectorItemInfo();
        
        // 初期値は0(auto)である.autoをセットしておく.
        collectorInfo.setGraphPlotNum(0);
		
		// プリファレンスクラスのインスタンスを生成する。
		perfPrePage = new PerformancePreferencePage();
    }
    
    
    /**
     * 選択されたスコープ(ノード)の情報を表示します。
     * 
     * @param item
     *            スコープツリーアイテム
     */
    protected void doSelectTreeItem(FacilityTreeItem item) {

    	// グラフ表示対象スコープを変更
    	currentTreeItem = item;

    	if (collectorInfo.getFacilityId() != null && 
    			collectorInfo.getFacilityId().equals(item.getData().getFacilityId())) {
    		// 何もしない。(連打への対処)
    	} else {
    		//選択されたスコープ情報をグラフ基本情報に書き込む。
    		collectorInfo.setFacilityId(item.getData().getFacilityId());
    		collectorInfo.setSubScopeNum(item.getChildren().length);

    		//選択されたスコープのサブスコープ情報をグラフ基本情報に書き込む。
    		//データに直接アクセスできず、リストでしか取得できないので一旦保持する。
    		FacilityTreeItem[] childrenList = item.getChildren();

    		// ファシリティID順に並び替える
    		Arrays.sort(childrenList, new Comparator(){
    			public int compare(Object o1, Object o2) {
    				if (o1 instanceof FacilityTreeItem && o2 instanceof FacilityTreeItem) {
    					String object1 = ((FacilityTreeItem) o1).getData().getFacilityId();
    					String object2 = ((FacilityTreeItem) o2).getData().getFacilityId();

    					return object1.compareTo(object2);
    				}
    				return 0;
    			}
    		});

    		if (item.getChildren().length > 0) {
    			ArrayList subScopeFacilityId = new ArrayList();
    			ArrayList subScopeFacilityName = new ArrayList();

    			for (int i = 0; i < childrenList.length; i++) {
    				subScopeFacilityId.add(childrenList[i].getData().getFacilityId());
    				subScopeFacilityName.add(childrenList[i].getData().getFacilityName());
    			}
    			collectorInfo.setSubScopeFacilityId(subScopeFacilityId);
    			collectorInfo.setSubScopeFacilityName(subScopeFacilityName);
    		}
    		this.update();
    	}
    }

    /**
     * 初期化を行います。
     * リストで収集項目を指定してグラフ描画ボタンを押下したときに呼ばれます。
     */
    public void setCollectorProperty(CollectorProperty property) {

		// 既に表示されているグラフとスコープのパスを消去し表示が残らないようにする.
  	    if (graphHolderComposite != null) {
  	    	graphHolderComposite.disposeGraph();
//  	    	graphHolderComposite.dispose();	// グラフの消去
//			this.getPathLabel().setText("");	// 収集ID、スコープ表示ラベルの初期化
//			this.getBaseComposite().layout(true, true);
//			collectorInfo.setFacilityId(null);
//			
//	        // グラフを表示するコンポジットを生成
//	        // RecordGraphHolderCompositeのインスタンスを生成する。
//	    	graphHolderComposite = new RecordGraphHolderComposite(parent, SWT.NONE , MAX_GRAPH_NUM);
    	}
    	
        this.collectorProperty = property;
        
        // グラフ表示用のコンポジットに収集プロパティ情報を設定する
        graphHolderComposite.setMasterData(collectorProperty);
        
    	// ここは非常に重要。tree共通部品を用いつつ、ツリー情報を上書きすることによりカスタマイズしている。 
//        this.item =  collectorProperty.getCollectorData().getFacilityTree();
        this.getScopeTreeComposite().setScopeTree(
        		collectorProperty.getCollectorData().getFacilityTree());
        
        int interval = property.getCollectorData().getIntervalSec();
        
        // 実績グラフでは、収集時点でグラフ表示間隔が決定されるので、
        // 収集項目選択時にinterval値をセットする。
        collectorInfo.setInterval(interval);
        
        collectorInfo.setCollectStartTime(collectorProperty.getCollectorData().getStartDate());
        collectorInfo.setCollectEndTime(collectorProperty.getCollectorData().getStopDate());
        
        // 表示範囲などを指定せずに表示グラフのみ指定して実行する場合もあるので、ここで値をセットする必要あり.
        collectorInfo.setGraphStartTime(collectorProperty.getCollectorData().getStartDate());
        
        long startTime = collectorProperty.getCollectorData().getStartDate().getTime();
        
		// GraphConstant.REALTIME_GRAPH_MAX_PLOT 最大表示プロット数
		collectorInfo.setGraphEndTime(new Date(startTime + interval * 1000 * (GraphConstant.REALTIME_GRAPH_MAX_PLOT + 1)));
        collectorInfo.setGraphPlotNum(0);

        List<CollectorItemInfo> itemList = collectorProperty.getItemList();
        
        collectorItemInfo.createItemInfoForCollector(itemList.size());
        for (int i = 0; i < itemList.size(); i++) {
        	CollectorItemInfo info = itemList.get(i);
        	// 配列を準備する.
        	collectorItemInfo.setItemInfoForCollector(
        			i,
        			info.getItemCode(),
        			info.getDeviceName(),
        			true);  // true暫定
        }
        // 詳細項目の有無のデータを判定してセットする.
        for (int i = 0; i < itemList.size(); i++) {
        	List<String> factorySubItemCodeList = CollectorItemCodeFactory.getSubItemCode(
        			collectorItemInfo.getItemCodeForCollector(i));
        	String deviceName = collectorItemInfo.getDeviceNameForCollector(i);
        	
        	boolean a = true;
        	
        	if (factorySubItemCodeList == null || factorySubItemCodeList.size() == 0) { // 子項目が存在しない項目の場合.deviceindex=0
        		a = false;
        	} else {
        		// 複数デバイスの場合への対応 
        		loop1: for (int m = 0; m < factorySubItemCodeList.size() ; m++) {
        			boolean c = false;  // 内訳項目毎の有無のフラグ.
        			loop2: for (int n = 0; n < collectorItemInfo.getItemNumForCollector(); n++) { // 収集itemCode数分だけチェックする.
        				if (collectorItemInfo.getItemCodeForCollector(n).equals(factorySubItemCodeList.get(m).toString())) {
        					if (deviceName.equals(collectorItemInfo.getDeviceNameForCollector(n))) {
        						c = true; // 必要項目が見つかった場合.
        						break loop2;
        					}
        				}
        			}
        			if (! c) {
        				a = false; // 必要項目が見つからなかった場合.
        				break loop1;
        			}
        		}
        	}
        	if (! a) { // 詳細表示が可能でない場合.
        		collectorItemInfo.isItemDetailedForCollector(i, false);
        	} else {
        		// 初期値でtrueにしているので何もしない.
        	}
        } // for
        
        if (itemList != null && itemList.size() > 0) {
        	// 初期状態用に先頭のレコードをセットする
        	CollectorItemInfo info = (CollectorItemInfo)itemList.get(0);
        	// 初期値を登録する。初期値は先頭レコードとする。
        	// 利用者は登録内容を変更して表示内容を決める。
        	for (int i = 0; i < 4; i++) {
        		collectorItemInfo.setItemInfo(
        				i,
        				info.getItemCode(),
        				"NonDisplay",	// 初期状態は非表示.スコープ代表値以外は条件により表示されない場合があるので不適.ただ代表値にしない.
        				info.getDeviceName(),
        				true);	// for test.
        	} // for
        } // if
        
        // 描画する
        update();
    }
    
    /**
     * @see org.eclipse.ui.IWorkbenchWindowActionDelegate#dispose()
     */
    public void dispose() { 
    	
    	// 削除ロックを解除
    	RecordController.getInstance().unlock();
    	
    	// セッションを切断
    	RecordController.deleteInstance();
    	super.dispose();
    }
    
    /**
     * グラフ表示対象の収集設定を返します。
     * @return グラフ表示対象の収集設定
     */
    public CollectorProperty getCollectorProperty() {
    	return this.collectorProperty;
    }
    
//    /**
//     * グラフ表示設定を返します。
//     * @return グラフ表示設定
//     */
//    public GraphProperty[] getGraphProperty() {
//    	return graphCompositeR.getGraphPropertys();
//    }
    
    protected Composite createListContents(Composite parent) {

    	//スコープ選択時にgraphCompositeをnewするために保持する。
    	this.parent = parent;
    	
        // グラフを表示するコンポジットを生成
        // RecordGraphHolderCompositeのインスタンスを生成する。
    	graphHolderComposite = new RecordGraphHolderComposite(parent, SWT.NONE , MAX_GRAPH_NUM);
    	
    	GridLayout layout = new GridLayout(1, true);
    	this.parent.setLayout(layout);
    	layout.marginHeight = 0;
    	layout.marginWidth = 0;			
    	
    	//スコープの表示を消す
    	super.getScopeTreeComposite().setScopeTree(null);
    	
		if(this.loadCollectorPropertey()) {	// プリファレンス情報との整合を確認する	
			this.setCollectorProperty(this.collectorProperty);	// CollectorInfo,CollectorItemInfoに値を挿入する  
			this.getPreference();   // プリファレンスに保存してあるデータをCollectorInfo,CollectorItemInfoに格納する。
		}
		
		//ボタン（アクション）を制御するリスナーを登録
        super.getScopeTreeComposite().getTreeViewer().addSelectionChangedListener(
        		new RecordSetGraphSelectionChangedListener());
        
//    	this.update();
    	
    	//初期表示グラフを表示すべきか。
    	//   この点、グラフ表示条件の選択がされていないことを明示する
    	//   するため、空のグラフは表示しない。
//    	return this.graphComposite;
    	return this.graphHolderComposite;
    }
    
    /**
     * 表示期間が変更された際にもRecordSetGraphAction2から呼ばれる
     */
    public void update() {    	
    	
//    	// 連続押下対応
//    	try {
//    		Thread.sleep(10);
//    	} catch (InterruptedException e1) {
//    		// TODO 自動生成された catch ブロック
//    		e1.printStackTrace();
//    	}
    	
    	//グラフ表示
    	//   初期表示の場合はスコープ選択しても何も表示しない。
    	//   (グラフ表示条件未指定であることをわかりやすくする)
    	int interval = collectorInfo.getInterval();
    	int graphPlotNum = collectorInfo.getGraphPlotNum();
    	// マネージャへのデータ要求をするか否かの判定を初期化する。
//    	isRequestCollectorToRun = false;
    	
    	// intervalは初期状態のみゼロとなる。
    	if (interval != 0 && (collectorInfo.getFacilityId() != null)) {
    		boolean isXRangeAuto = false;
    		if (collectorInfo.getGraphPlotNum() == 0) {
    			isXRangeAuto = true;
    		}
    		
//    		if (graphComposite != null) {
//    			graphComposite.dispose();
//    		}
//    		
//    		graphComposite = new RealtimeGraphComposite(this.parent, SWT.NONE);
//    		graphComposite.setCollectorInfo(collectorInfo);
//    		graphComposite.setCollectorItemInfo(collectorItemInfo);
//    		
//    		GridData baseGridData = new GridData();
//    		baseGridData.horizontalAlignment = GridData.FILL;
//    		baseGridData.verticalAlignment = GridData.FILL;
//    		baseGridData.grabExcessHorizontalSpace = true;
//    		baseGridData.grabExcessVerticalSpace = true;
//    		graphComposite.setLayoutData(baseGridData);
//    		
//    		GridLayout baseLayout = new GridLayout(1, true);
//    		graphComposite.setLayout(baseLayout);
//    		baseLayout.marginHeight = 0;
//    		baseLayout.marginWidth = 0;	
    		
    		// グラフを削除する
    		graphHolderComposite.disposeGraph();
    		
    		/*
    		 * ここからがグラフ描画の処理
    		 */
    		int graphNum = collectorInfo.getGraphNum();  // 表示するグラフ数
    		String facilityId = collectorInfo.getFacilityId();  // 表示対象のファシリティID
    		
    		for (int i = 0; i < graphNum; i++) {
    			String itemCode =  collectorItemInfo.getItemCode(i);
    			String deviceName = collectorItemInfo.getDeviceName(i);
    			String displayType =  collectorItemInfo.getDisplayType(i);
    			
    			int graphType = GraphProperty.INVISIBLE;
    			//　FIXME 定数クラスに変更の必要
    			if (displayType.equals("NonDisplay")) {
    				graphType = GraphProperty.INVISIBLE;
    			} else if (displayType.equals("SelectedScope")) {
    				graphType = GraphProperty.TYPE1;
    			} else if (displayType.equals("Detail")) {
    				graphType = GraphProperty.TYPE2;
    			} else if (displayType.equals("SubScope")) {
    				graphType = GraphProperty.TYPE3;
    			}
    			
    			Date startDate = collectorInfo.getGraphStartTime();
    			Date endDate = collectorInfo.getGraphEndTime();
    			
    			// 各グラフを表示する
    			graphHolderComposite.redrawGraph(i, facilityId, itemCode, deviceName, graphType, startDate, endDate
    					,isXRangeAuto, graphPlotNum);
    			
//    			graphComposite.addGraph(
//    					i,
//    					itemCode,
//    					deviceName,
//    					collectorInfo.getSubScopeNum(),
//    					displayType, interval, isXRangeAuto, graphPlotNum);	// isXRangeAutoはとりあえずtrueの仕様とする.
//    			
//    			collectorItemInfo.setIsCollect(i, graphComposite.isCollect());
//    			
//    			if (graphComposite.isCollect()) {
//    				setCollector(itemCode, displayType, interval, facilityId);
//    			}
    		}
    		
//    		// ここは、以下の2つのチェックを経ている。
//    		//   (1) ダイアログでのグラフ表示の有無の判定。 
//    		//   (2) サブスコープ表示でノードを選択した場合のグラフ表示の有無の判定。
//    		if (! isRequestCollectorToRun) {
//    			try {
//    			} catch (Exception e) {
//    				// まだ収集を開始していない場合はそのまま処理を先に進める。
//    			}
//    		}
    		
    		//ScopeListBaseViewのパッチを適用することにより解決せず。このロジックを削除したいが残す。
    		// うまく再描画されないので、Sash変更で応急対処。
    		SashForm treeSash = this.getTreeSash();
    		treeSash.setWeights(new int[] { 29, 71 });
    		treeSash.setWeights(new int[] { 30, 70 });
			
//			// プリファレンスにRealtimeCollectorItemInfoの情報を格納する。
//			this.setPreference();
    	}
    	
    }
    
    private void setCollector(String itemCode, String displayType, int interval, String facilityId) {
    	// collectorIdの指定
    	String collectorId = collectorProperty.getCollectorData().getCollectorID();
    	// facility情報の指定
    	String[] facilityIdList;
    	
    	if (collectorInfo.getSubScopeNum() > 0 && displayType.equals("SubScope")) {     
    		facilityIdList = new String[collectorInfo.getSubScopeNum()];
    		
    		for (int i = 0 ; i < collectorInfo.getSubScopeNum(); i++) {
    			facilityIdList[i] = collectorInfo.getSubScopeFacilityId(i);
    		} 
    	} else {
    		facilityIdList = new String[1];
    		facilityIdList[0] = facilityId;
    	}
    	
    	List<CollectorItemInfo> itemList = collectorProperty.getItemList();
    	CollectorItemInfo[] itemInfoArray = new CollectorItemInfo[itemList.size()];
    	itemList.toArray(itemInfoArray);
		
    	Date startDate = collectorInfo.getGraphStartTime();
    	Date endDate = collectorInfo.getGraphEndTime();
	
		// 自動グラフ表示無期限収集対応(設定されていた箇所が切り詰められた場合)
		Date nowDate = new Date();		
		if (collectorInfo.getGraphStartTime().before(collectorInfo.getCollectStartTime())) { // グラフ表示時刻 ＜ 収集開始時刻
			startDate = collectorInfo.getCollectStartTime();
			endDate = new Date(startDate.getTime() + collectorInfo.getInterval() * 1000 * GraphConstant.REALTIME_GRAPH_MAX_PLOT);  
			if (endDate.after(nowDate)) { // グラフ表示終了時刻が現在時刻をすぎている場合
				endDate = nowDate;
			} 
		}
			
//    	// itemCodeとdeviceIndexを手がかりにしてitemIdのリストを作成する.
//    	List<String> ItemCodeCheckList = null;
//    	
//    	if (displayType.equals("Detail")) {
//    		// 順序はfactoryにあくまで合わせる。(グラフ表示も)
//    		ItemCodeCheckList = CollectorItemCodeFactory.getSubItemCode(itemCode);
//    	} else {
//    		ItemCodeCheckList = new ArrayList<String>();
//    		ItemCodeCheckList.add(itemCode); // スコープ代表値とサブスコープ代表値では、下位のitemCodeはない.
//    	}
//    	
//    	// itemIdを格納する配列を用意する.
//    	int[] collectorItemIdList = new int[ItemCodeCheckList.size()];	// 配列とする現行仕様を見直すかはあとで検討。
//    	// 収集IDが集めた項目数(itemCode数にdeviceIndexを加味した数.
//    	int collectorItemNum = collectorItemInfo.getItemNumForCollector();
//    	
//    	// 各itemCodeごとにチェックする.
//    	loop1: for (int m = 0; m < ItemCodeCheckList.size() ; m++) {
//    		boolean found = false;  // 内訳項目毎の有無のフラグ.
//    		// itemCodeとdeviceIndexをキーにしたときのitemIdを取得する.
//    		loop2: for (int n = 0; n < collectorItemNum; n++) { // 収集itemCode数分だけチェックする.
//    			// まずはitemCodeレベルでチェックする.
//    			if (collectorItemInfo.getItemCodeForCollector(n).equals(ItemCodeCheckList.get(m).toString())) {
//    				// itemCodeが一致したら次にdeviceIndexをチェックする.
//    				if (deviceIndex.equals(collectorItemInfo.getIndexForCollector(n))) {
//    					collectorItemIdList[m] = n;
//    					found = true;
//    					break loop2;	// 必要項目が見つかった場合.
//    				}
//    			}
//    		}
//    		if (! found) {
//    			break loop1;
//    		}
//    	}
    	
    	// 1つのグラフのための必要データをセットしている.
    	// collectorItemIdList
    	//        詳細表示の場合は、複数になる。それ以外はひとつである。ただ、いずれもdeviceIndexが
    	//        正しい必要があるので注意.単にitemCodeだけみると先頭デバイスを表示してしまう.
//    	this.drawGraph1Test(collectorId, collectorItemIdList, facilityIdList, startDate, endDate, displayType);
//    	this.drawGraph1Test(collectorId, itemInfoArray, facilityIdList, startDate, endDate, displayType);

    	
//    	isRequestCollectorToRun = true;
    }
    
//    /**
//     * グラフを描画する。
//     * 
//     * @param collectorId 収集ID
//     * @param collectorItemIdList 収集項目のリスト
//     * @param facilityIdList ファシリティIDのリスト
//     * @param startDate 収集開始時刻
//     * @param endDate 収集終了時刻
//     * @param displayType 表示種別
//     */
//    public synchronized void drawGraph1Test(
//    		String collectorId,
//    		CollectorItemInfo[] collectorItemInfoList,
//    		String[] facilityIdList,
//    		Date startDate,
//    		Date endDate,
//    		String displayType) {
//    	
//    	// マネージャからデータを取得
//    	RecordController controller = RecordController.getInstance();
//    	// マネージャとの接続に失敗した場合はエラーダイアログを表示
//    	if (controller == null) {
//    		return;
//    	}
//    	
//    	// 全グラフ共通
//    	CollectedDataSet dataSet = controller.getRecordCollectedData(
//    			collectorId, facilityIdList, collectorItemInfoList, startDate, endDate);
//    	
//    	// 性能データの取得に失敗した場合はエラーダイアログを表示
//    	if (dataSet == null) {
//    		return;
//    	}
//    	
//    	
//    	// ここで作成するデータはあくまで1つのグラフ用のもの。頭を混乱させてはいけない。
//    	
//    	int counter = 0;
//    	
//    	if (displayType.equals("SelectedScope")) {
//    		// facilityはひとつ。線もひとつ。
//    		// partialのみ取得。サブスコープには使えないので注意
//    		counter = 1;
//    	} else if (displayType.equals("SubScope")) {
//    		counter = collectorInfo.getSubScopeNum();
//    	} else {
//    		counter = collectorItemInfoList.length;
//    	}
//    	
//    	
//    	int graphDotNum = 0;
//    	
//    	if (displayType.equals("SelectedScope") || displayType.equals("Detail")) {
//    		for(int i=0; i < counter; i++){
//    			List dataListForCheck = dataSet.getCollectedDataList(facilityIdList[0], collectorItemInfoList[i]);
//    		}
//    	} else {
//    		for(int i=0; i < counter; i++){
//    			List dataListForCheck = dataSet.getCollectedDataList(facilityIdList[i], collectorItemInfoList[0]);
//    		}
//    	}
//    	
//    	List dataListForCheck = dataSet.getCollectedDataList(facilityIdList[0], collectorItemInfoList[0]);
//    	graphDotNum = dataListForCheck.size();
//    	
//        // 線を1本ずつ完成させていくので、配列で保持しておく。マネージャ側の仕様の見直しが必要とおもわれる。
//    	double[] sumOfDataInfoValueSum = new double[graphDotNum]; // = 0.0D;
//    	
//    	for (int i = 0; i < counter; i++){
//    		List dataList= null;
//    		
//    		// 詳細表示では値を足していくので
//    		if (displayType.equals("Detail")) {
//    			dataList = dataSet.getCollectedDataList(facilityIdList[0], collectorItemInfoList[i]);
//    		} else {
//    			dataList = dataSet.getCollectedDataList(facilityIdList[i], collectorItemInfoList[0]);
//    		}
//    		
//    		if (dataList.size() != 0) { // 収集中のグラフ表示ではマネージャから値を取得できていない場合もあるため
//    			double dataInfoValue = 0.0D;
//    			for(int j=0; j < dataList.size(); j++){
//    				CollectedDataInfo dataInfo = (CollectedDataInfo) dataList.get(j);
//    				
//    				if (!Double.isNaN(dataInfo.getValue())) {
//    					if (dataInfo.getValue() >= 0.0) {
//    						
//    						if (displayType.equals("SelectedScope") || displayType.equals("SubScope")) {
//    							dataInfoValue = dataInfo.getValue(); 
//    						} else if (displayType.equals("Detail")) {
//    							// 値を積みあげる。
//    							sumOfDataInfoValueSum[j] = sumOfDataInfoValueSum[j] + dataInfo.getValue();
//    							dataInfoValue = sumOfDataInfoValueSum[j]; 
//    						}
//    						if (!Double.isNaN(dataInfoValue)) {
//    							graphComposite.m_timeseries[i].addOrUpdate(new Second(dataInfo.getDate()),dataInfoValue);
//    						}
//    					}
//    				}
//    			} // for
//    		} else {
//    		} // else
//    	} // for
//    } // if


    
	/**
	 * 収集IDをプリファレンスから取得し、collectorPropertyを取得するメソッド
	 * @return boolean
	 */
	private boolean loadCollectorPropertey() {
		
		String collectorID = perfPrePage.getCollectorId();
		
		if(!"".equals(collectorID)){ // プリファレンスページにcollectorIDの情報が存在する場合
			collectorProperty = RecordController.getInstance().getCollectorProperty(collectorID);
			if(collectorProperty != null) // 実績収集一覧にデータが存在する場合
				return true;
		}
		return false;
	}
	
	/**
	 * プリファレンスより格納してある情報を取得するメソッド
	 *
	 */
	private void getPreference(){
		
		collectorInfo = perfPrePage.getRealtimeCollectorInfo(this.collectorInfo);
		collectorItemInfo = perfPrePage.getRealtimeCollectorItemInfo(this.collectorItemInfo);
		
		Label pathLabel = this.getPathLabel();
		pathLabel.setText(Messages.getString("SCOPE") + " : " + perfPrePage.getPathLabel());
	}
	
	/**
	 * プリファレンスに情報をセットするメソッド
	 *
	 */
	private void setPreference() {
		perfPrePage.setCollectorId(this.collectorProperty.getCollectorData().getCollectorID());
		
		String pathLabelSplit[] = this.getPathLabel().getText().split(" "); // スコープのパスだけを抽出
		perfPrePage.setPathLabel(pathLabelSplit[2]);
		perfPrePage.setRealtimeCollectorInfo(this.collectorInfo);
		perfPrePage.setRealtimeCollectorItemInfo(this.collectorItemInfo);
		
		perfPrePage.savePreference();	// プリファレンスページのデータを保存する
		
	}
	
    /**
     * ビューのアクションの有効/無効を設定
     * 
     * @param type 選択種別
     * @param selection ボタン（アクション）を有効にするための情報 
     * @since 1.0
     */
    public void setEnabledAction(int type, ISelection selection) {        
        // ビューアクションの使用可/不可を設定
    	super.setEnabledAction(RecordSetGraphAction.ID, selection);
    	super.setEnabledAction(RecordSetGraphAction2.ID, selection); 	
    	
        // 初期値を設定    	
    	super.setEnabledAction(RecordSetGraphAction.ID, false);
    	super.setEnabledAction(RecordSetGraphAction2.ID, false);
        
    	if (type == FacilityConstant.TYPE_COMPOSITE) {

        } else if (type == FacilityConstant.TYPE_SCOPE) {
    		super.setEnabledAction(RecordSetGraphAction.ID, true);
    		super.setEnabledAction(RecordSetGraphAction2.ID, true);
        } else if (type == FacilityConstant.TYPE_NODE) {
    		super.setEnabledAction(RecordSetGraphAction.ID, true);
    		super.setEnabledAction(RecordSetGraphAction2.ID, true);
        }
    }
	
}