/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.maintenance.bean;



/**
 * メンテナンス機能の種別の定義を定数として格納するクラスです。
 *
 * @version 2.2.0
 * @since 2.2.0
 */
public class MaintenanceTypeMstConstant {
	
	public static final int DELETE_EVENT_LOG_INDEX = 0;
	public static final int DELETE_JOB_HISTORY_INDEX = 1;
	public static final int DELETE_CRUN_HISTORY_INDEX = 2;
	
	public static final String DELETE_EVENT_LOG_NAME = "maintenance.delete_event_log";
	public static final String DELETE_JOB_HISTORY_NAME = "maintenance.delete_job_history";
	public static final String DELETE_CRUN_HISTORY_NAME = "maintenance.delete_crun_history";
	
	public static final String DELETE_EVENT_LOG = "DELETE_EVENT_LOG";
	public static final String DELETE_JOB_HISTORY = "DELETE_JOB_HISTORY";
	public static final String DELETE_CRUN_HISTORY = "DELETE_CRUN_HISTORY";
	
	/**
	 * 
	 * メンテナンス[作成・変更]ダイアログ「種別」リストの表示位置から、種別IDを取得します。
	 * 
	 * @param index
	 * @return
	 */
	public static String indexToTypeId(int index) {
		
		String ret = null;
		
		switch (index) {
		
		case DELETE_EVENT_LOG_INDEX:
			ret = DELETE_EVENT_LOG;
			break;
			
		case DELETE_JOB_HISTORY_INDEX:
			ret = DELETE_JOB_HISTORY;
			break;
			
		case DELETE_CRUN_HISTORY_INDEX:
			ret = DELETE_CRUN_HISTORY;
			break;
		
		}
		
		return ret;
	}
	
	/**
	 * 
	 * メンテナンス[作成・変更]ダイアログ「種別」リストの種別IDから表示用文字列を取得します。
	 * 
	 * @param typeId
	 * @return
	 */
	public static String typeIdToNameId(String typeId) {
		
		String ret = null;
		
		if (typeId.equals(DELETE_EVENT_LOG)) {
			ret = DELETE_EVENT_LOG_NAME;
			
		} else if (typeId.equals(DELETE_JOB_HISTORY)) {
			ret = DELETE_JOB_HISTORY_NAME;
			
		} else if (typeId.equals(DELETE_CRUN_HISTORY)) {
			ret = DELETE_CRUN_HISTORY_NAME;
			
		}
		
		return ret;
	}
	
}
