/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.http.ejb.entity;

import javax.ejb.EntityBean;


/**
 * HTTP監視設定を管理するEntity Bean<BR>
 *   @ejb.bean name="MonitorHttpInfo"
 *           jndi-name="MonitorHttpInfo"
 *           type="CMP"
 *           schema="MonitorHttpInfo" 
 *           cmp-version="2.x"
 *           data-source="java:/HinemosDS"
 *           primkey-field="monitorTypeId","monitorId"
 *           
 *  @jboss.depends name="jboss.jca:service=DataSourceBinding,name=HinemosDS"
 *  
 *  @jboss.container-configuration
 *     name="Instance Per Transaction CMP 2.x EntityBean"
 *
 *  @jboss.optimistic-locking
 *     modified-strategy="true"
 *  
 *  @ejb.permission
 *     unchecked="true"
 *     
 *  @ejb.persistence 
 *   table-name="cc_monitor_http_info"  
 *           
 *  @ejb.finder 
 *    query="SELECT OBJECT(a) FROM MonitorHttpInfo as a"  
 *    signature="java.util.Collection findAll()"  
 *
 *  @ejb.pk class="com.clustercontrol.http.ejb.entity.MonitorHttpInfoPK"
 */
public abstract class MonitorHttpInfoBean implements EntityBean {
	
	/**
	 *
	 * <!-- begin-user-doc -->
	 * The  ejbCreate method.
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.create-method 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public MonitorHttpInfoPK ejbCreate(
			String monitorTypeId,
			String monitorId, 
			String requestUrl,
			Integer timeout,
			Integer urlReplace,
			Integer proxySet,
			String proxyHost,
			Integer proxyPort
	) throws javax.ejb.CreateException {
		
		this.setMonitorTypeId(monitorTypeId);
		this.setMonitorId(monitorId);
		this.setRequestUrl(requestUrl);
		this.setTimeout(timeout);
		this.setUrlReplace(urlReplace);
		this.setProxySet(proxySet);
		this.setProxyHost(proxyHost);
		this.setProxyPort(proxyPort);
		return null;
	}
	
	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="monitor_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 * @ejb.pk-field 
	 *
	 * @ejb.interface-method
	 * 
	 * @return Returns the monitorId.
	 */
	public abstract String getMonitorId();
	
	/**
	 * @ejb.interface-method
	 * 
	 * @param monitorId The monitorId to set.
	 */
	public abstract void setMonitorId(String monitorId);
	
	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="monitor_type_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 * @ejb.pk-field 
	 *
	 * @ejb.interface-method
	 * 
	 * @return Returns the monitorTypeId.
	 */
	public abstract String getMonitorTypeId();
	
	/**
	 * @ejb.interface-method
	 * 
	 * @param monitorTypeId The monitorTypeId to set.
	 */
	public abstract void setMonitorTypeId(String monitorTypeId);
	
	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="proxy_host"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 * 
	 * @return Returns the proxyHost.
	 */
	public abstract String getProxyHost();
	
	/**
	 * @ejb.interface-method
	 * 
	 * @param proxyHost The proxyHost to set.
	 */
	public abstract void setProxyHost(String proxyHost);
	
	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="proxy_port"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 *  
	 * @ejb.interface-method
	 * 
	 * @return Returns the proxyPort.
	 */
	public abstract Integer getProxyPort();

	/**
	 * @ejb.interface-method
	 * 
	 * @param proxyPort The proxyPort to set.
	 */
	public abstract void setProxyPort(Integer proxyPort);
	
	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="proxy_set"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 *  
	 * @ejb.interface-method
	 * 
	 * @return Returns the proxySet.
	 */
	public abstract Integer getProxySet();

	/**
	 * @ejb.interface-method
	 * 
	 * @param proxySet The proxySet to set.
	 */
	public abstract void setProxySet(Integer proxySet);
	
	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="request_url"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(2083)"
	 *     read-only="false"
	 * 
	 * @ejb.interface-method
	 * 
	 * @return Returns the requestUrl.
	 */
	public abstract String getRequestUrl();
	
	/**
	 * @ejb.interface-method
	 * 
	 * @param requestUrl The requestUrl to set.
	 */
	public abstract void setRequestUrl(String requestUrl);
	
	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="timeout"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 * 
	 * @ejb.interface-method
	 * 
	 * @return Returns the timeout.
	 */
	public abstract Integer getTimeout();

	/**
	 * @ejb.interface-method
	 * 
	 * @param timeout The timeout to set.
	 */
	public abstract void setTimeout(Integer timeout);
	
	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="url_replace"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 *  
	 * @ejb.interface-method
	 * 
	 * @return Returns the urlReplace.
	 */
	public abstract Integer getUrlReplace();

	/**
	 * @ejb.interface-method
	 * 
	 * @param urlReplace The urlReplace to set.
	 */
	public abstract void setUrlReplace(Integer urlReplace);
}
