/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.collectiverun.action;

import java.rmi.AccessException;
import java.rmi.RemoteException;
import java.util.Locale;

import javax.ejb.FinderException;
import javax.naming.NamingException;

import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.ViewListInfo;
import com.clustercontrol.collectiverun.ejb.session.CollectiveRunController;
import com.clustercontrol.collectiverun.util.EjbConnectionManager;
import com.clustercontrol.util.PropertyUtil;

/**
 * 一括制御[履歴]情報を取得するクライアント側アクションクラス<BR>
 * 
 * サーバから一括制御[履歴]情報を取得します。
 * 
 * @version 2.1.1
 * @since 1.0.0
 */
public class GetHistoryInfo {
	
	/**
	 * 一括制御[履歴]情報を取得します。
	 * 
	 * @param histories 表示履歴数
	 * @return 一括制御[履歴]情報
	 * @throws AccessException 
	 */
	public ViewListInfo getHistory(int histories) throws AccessException {
		CollectiveRunController collectiveRun = EjbConnectionManager
		.getConnectionManager().getCollectiveRunController();
		
		ViewListInfo list = null;
		try {
			list = collectiveRun.getHistoryList(Locale.getDefault(), histories);
		} catch (RemoteException e) {
			if(e instanceof AccessException){
				// アクセス権なしの場合
				throw (AccessException) e;
			}
		} catch (FinderException e) {
		} catch (NamingException e) {
		}
		
		return list;
	}
	
	/**
	 * 一括制御[履歴]情報取得処理
	 * 
	 * @param property フィルタ条件
	 * @param histories 表示履歴数
	 * @return 一括制御[履歴]情報
	 * @throws AccessException 
	 */
	public ViewListInfo getHistory(Property property, int histories) throws AccessException {
		PropertyUtil.deletePropertyDefine(property);
		
		CollectiveRunController collectiveRun = EjbConnectionManager
		.getConnectionManager().getCollectiveRunController();
		
		ViewListInfo list = null;
		try {
			list = collectiveRun.getHistoryList(property, Locale.getDefault(), histories);
		} catch (RemoteException e) {
			if(e instanceof AccessException){
				// アクセス権なしの場合
				throw (AccessException) e;
			}
		} catch (FinderException e) {
		} catch (NamingException e) {
		}
		
		return list;
	}
}