/*
 
Copyright (C) 2008 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.notify.mail.action;

import java.rmi.AccessException;
import java.rmi.RemoteException;
import java.util.ArrayList;

import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.naming.NamingException;

import org.eclipse.jface.dialogs.MessageDialog;

import com.clustercontrol.notify.mail.ejb.entity.MailTemplateInfoData;
import com.clustercontrol.notify.mail.ejb.session.MailTemplateController;
import com.clustercontrol.notify.mail.util.EjbConnectionManager;
import com.clustercontrol.util.Messages;

/**
 * メールテンプレート情報を取得するクライアント側アクションクラス<BR>
 * 
 * @version 2.4.0
 * @since 2.4.0
 */
public class GetMailTemplate {

    /**
     * メールテンプレート情報を返します。<BR>
     * マネージャにSessionBean経由でアクセスします。
     * 
     * @param mailTemplateId 取得対象のメールテンプレートID
     * @return メールテンプレート情報
     * 
     * @see com.clustercontrol.notify.mail.util.EjbConnectionManager
	 * @see com.clustercontrol.notify.mail.ejb.session.MailTemplateController
	 * @see com.clustercontrol.notify.mail.ejb.session.MailTemplateControllerBean#getMailTemplateInfo(java.lang.String)
     */
    public MailTemplateInfoData getMailTemplate(String mailTemplateId) {

    	MailTemplateController mailTemplate = EjbConnectionManager.getConnectionManager()
                .getMailTemplateController();

    	MailTemplateInfoData info = null;
        try {
        	info = mailTemplate.getMailTemplateInfo(mailTemplateId);
        } catch (RemoteException e) {
			if(e instanceof AccessException){
				// アクセス権なしの場合、エラーダイアログを表示する
	            MessageDialog.openInformation(null, Messages.getString("message"),
	                    Messages.getString("message.accesscontrol.16"));
			}
        } catch (FinderException e) {
        } catch (NamingException e) {
        }
        return info;
    }
    
    /**
     * メールテンプレートID一覧を返します。<BR>
     * マネージャにSessionBean経由でアクセスします。
     * 
     * @return メールテンプレートID一覧
     * 
     * @see com.clustercontrol.notify.mail.util.EjbConnectionManager
	 * @see com.clustercontrol.notify.mail.ejb.session.MailTemplateController
	 * @see com.clustercontrol.notify.mail.ejb.session.MailTemplateControllerBean#getMailTemplateIdList()
     */
    public ArrayList getMailTemplateIdList() {

    	MailTemplateController mailTemplate = EjbConnectionManager.getConnectionManager()
                .getMailTemplateController();

        ArrayList records = null;
        try {
            records = mailTemplate.getMailTemplateIdList();
        } catch (RemoteException e) {
			if(e instanceof AccessException){
				// アクセス権なしの場合、エラーダイアログを表示する
	            MessageDialog.openInformation(null, Messages.getString("message"),
	                    Messages.getString("message.accesscontrol.16"));
			}
        } catch (CreateException e) {
        } catch (FinderException e) {
        } catch (NamingException e) {
        }
        return records;
    }
    
    /**
     * メールテンプレート情報一覧を返します。<BR>
     * マネージャにSessionBean経由でアクセスします。
     * 
     * @return メールテンプレート情報一覧
     * 
     * @see com.clustercontrol.notify.mail.util.EjbConnectionManager
	 * @see com.clustercontrol.notify.mail.ejb.session.MailTemplateController
	 * @see com.clustercontrol.notify.mail.ejb.session.MailTemplateControllerBean#getMailTemplateList()
     */
    public ArrayList getMailTemplateList() {

    	MailTemplateController mailTemplate = EjbConnectionManager.getConnectionManager()
                .getMailTemplateController();

        ArrayList records = null;
        try {
            records = mailTemplate.getMailTemplateList();
        } catch (RemoteException e) {
			if(e instanceof AccessException){
				// アクセス権なしの場合、エラーダイアログを表示する
	            MessageDialog.openInformation(null, Messages.getString("message"),
	                    Messages.getString("message.accesscontrol.16"));
			}
        } catch (CreateException e) {
        } catch (FinderException e) {
        } catch (NamingException e) {
        }
        return records;
    }
}