#!/bin/sh

#Copyright (c) 2010 NTT DATA CORPORATION
#
#This program is free software; you can redistribute it and/or
#Modify it under the terms of the GNU General Public License
#as published by the Free Software Foundation, version 2.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details

echo ""
echo "##################################################################"
echo ""
echo "      Operation Management Software Hinemos Agent for ${PLATFORM_NAME}"
echo "                                     Installer Ver. ${VERSION}"
echo ""
echo "                        Copyright (c) 2010 NTT DATA CORPORATION"
echo ""
echo "##################################################################"
echo ""

IPADDR=""
JAVA_PATH=""

#プラットフォームをチェック
if [ ${PLATFORM} = "solaris" ]; then
	EXEC_USER=`/usr/ucb/whoami`
	PS="/usr/ucb/ps auxwww"
elif [ ${PLATFORM} = "hp-ux" ]; then
	EXEC_USER=`/usr/bin/whoami`
	PS="ps -ef"
elif [ ${PLATFORM} = "aix" ]; then
	EXEC_USER=`/usr/bin/whoami`
	PS="ps -ef"
fi

##
## インストール実行ユーザの確認
##
if [ $EXEC_USER != "root" ]; then
		echo ""
		echo "ERROR  Set up Hinemos Agent at a root user."
		echo ""
		exit 1
fi


##
## インストールディレクトリの確認
##
installdir_check() {
	echo "Installation directory ${HINEMOS_AGENT_HOME} is confirmed."
	if [ -d ${HINEMOS_AGENT_HOME} ]; then
		echo "Warning : Installation directory ${HINEMOS_AGENT_HOME} already exists."
		echo "Please change the directory name or delete it."
		echo ""
		echo "The installation is canceled."
		exit 1
	else
		echo "Installation directory ${HINEMOS_AGENT_HOME} doesn't exist. It is created."
		echo "mkdir -p ${HINEMOS_AGENT_HOME}"
		echo ""
	fi
}



##
## JREのインストール
##
jre_install() {

	#javaコマンドまでのパスを入力
	while [ 1 ] ;
	do
		echo -n "Please input Java path (e.g. /opt/jre1.5.0_22/bin/java) :"
		read JAVA_PATH
		echo "Is it ${JAVA_PATH}? (Y/N default:Y)"
		read JAVA_ANS
		JAVA_ANS=${JAVA_ANS:-Y}
		echo ""
		case ${JAVA_ANS} in
			y|Y)
				break
				;;
			n|N)
				;;
			*)
				echo "Please input Y or N."
				;;
		esac
	done
	
	#既にインストールされているJREを利用するため、新規にインストールは行わない
	#hinemos_agent.cfgにJRE_PATHの内容をコピー
	REPLACE_PATH=`echo ${JAVA_PATH} | sed 's/\//\\\\\//g'`
	sed "s/%%java_proc%%/${REPLACE_PATH}/" ${EXEC_PATH}/hinemos_agent.cfg > ${HINEMOS_AGENT_HOME}/bin/hinemos_agent.cfg

}



##
## syslogのセットアップ
##
syslog_setting() {

	#マネージャへの転送設定を行うか確認する
	echo "Setting syslog"
	sleep 1
	echo ""
	echo "Do you change the setting of the syslog?(Y/N)"
	
	while [ 1 ];
	do
	
		read SYSLOG_ANSER
		
		case ${SYSLOG_ANSER} in
			y|Y)
				if [ -f ${SYSLOG_CONF} ] ;then
					
					#既に転送設定がされているかを確認
					TMP_A=0
					grep "add for Hinemos Agent" ${SYSLOG_CONF} > /dev/null 2>&1 && TMP_A=1
					
					if [ "${TMP_A}" -eq 0 ] ; then
						
						echo "" >> ${SYSLOG_CONF}
						echo "#add for Hinemos Agent ${VERSION}" >> ${SYSLOG_CONF}
						echo "*.info	@${IPADDR}" >> ${SYSLOG_CONF}
						echo "" >> ${SYSLOG_CONF}
					
						#syslogの再起動
						if [ ${PLATFORM} = "hp-ux" ]; then
							${SYSLOG_STOP}
							${SYSLOG_START}
						else
							${SYSLOG_RESTART}
						fi
						
						echo "syslog.conf was changed."
						
					else
					
						echo "Warning : syslog.conf is already set."
						echo "Please change the setting referring to the unix setup guide."
						sleep 2
						
					fi
					
				else
					echo "${SYSLOG_CONF} is not found"
				fi
				break
				;;
			n|N)
				echo "syslog.conf was not changed."
				echo "Please change the setting referring to the unix setup guide."
				sleep 1
				break
				;;
			*)
				echo "Please input Y or N."
				;;
		esac
	done

}


##
## syslogのセットアップ切り戻し
##
syslog_restore_setting() {
	
	echo ""
	echo "syslog settings are not changed because there is a possibility that the settings are used by any programs but hinemos."
	echo ""
}


##
## インストーラ本編(始)
##
while [ 1 ];
do
	echo "Hinemos Agent's"
	echo "	 1) Installation"
	echo "	 2) Uninstallation"
	echo "	 9) Quit this installer"
	echo ""
	echo -n "===> "

	read CHOSEN_NUMBER

	case ${CHOSEN_NUMBER} in
		##
		## インストール
		##
		1)
			echo ""
			echo "Setup Hinemos agent."
			echo ""
			echo ""

			while [ 1 ];
			do
				echo "Installation will be start.  Is it all right? (Y/N)"
				read ANS
				case ${ANS} in
					y|Y)
						
						# インストールディレクトリの確認
						installdir_check

						while [ 1 ] ;
						do
							echo -n "Please input the manager's IP Address :"
							read IPADDR
							echo "Is it ${IPADDR}? (Y/N default:Y)"
							read IP_ANS
							IP_ANS=${IP_ANS:-Y}
							echo ""
							case ${IP_ANS} in
								y|Y)
									break
									;;
								n|N)
									;;
								*)
									echo "Please input Y or N."
									;;
							esac
						done

						# コピー開始
						echo "Start copying required files."
						cp -pr $EXEC_PATH/hinemos_agent /opt
						mkdir /${HINEMOS_AGENT_HOME}/sbin
						cp -pr $EXEC_PATH/agent_installer_${PLATFORM}.sh ${HINEMOS_AGENT_HOME}/sbin
						cp -pr $EXEC_PATH/install.sh ${HINEMOS_AGENT_HOME}/sbin
						
						if [ -d $EXEC_PATH/service ] ; then
							cp -pr $EXEC_PATH/service ${HINEMOS_AGENT_HOME}/sbin
						fi
						
						echo "Copying required files was completed."
						echo ""
						
						# ジョブエージェントへのマネージャIPアドレスの反映
						echo "" >> ${HINEMOS_AGENT_HOME}/lib/agent/Agent.properties
						echo "### Hinemos Manager ###" >> ${HINEMOS_AGENT_HOME}/lib/agent/Agent.properties
						echo java.naming.provider.url=jnp://$IPADDR:1099 >> ${HINEMOS_AGENT_HOME}/lib/agent/Agent.properties
						echo "" >> ${HINEMOS_AGENT_HOME}/lib/agent/Agent.properties

						# ジョブエージェントのログ出力先設定
						echo "" >> ${HINEMOS_AGENT_HOME}/lib/agent/log4j.properties
						echo "### log directory setting ###" >> ${HINEMOS_AGENT_HOME}/lib/agent/log4j.properties
						echo log4j.appender.file.File=${HINEMOS_AGENT_HOME}/var/log/agents.log >> ${HINEMOS_AGENT_HOME}/lib/agent/log4j.properties
						echo "" >> ${HINEMOS_AGENT_HOME}/lib/agent/log4j.properties
						
						# ログ転送エージェントの読み込むログファイルの文字エンコードを設定
						REPLACE_PATH=`echo ${LOG_FILE_ENCODING} | sed 's/\//\\\\\//g'`
						sed "s/UTF-8/${REPLACE_PATH}/" ${EXEC_PATH}/hinemos_agent/lib/log_agent/Agent.properties > ${HINEMOS_AGENT_HOME}/lib/log_agent/Agent.properties
						
						# ログ転送エージェントへのマネージャIPアドレスの反映
						echo "" >> ${HINEMOS_AGENT_HOME}/lib/log_agent/Agent.properties
						echo "### Hinemos Manager ###" >> ${HINEMOS_AGENT_HOME}/lib/log_agent/Agent.properties
						echo java.naming.provider.url=jnp://$IPADDR:1099 >> ${HINEMOS_AGENT_HOME}/lib/log_agent/Agent.properties
						echo "" >> ${HINEMOS_AGENT_HOME}/lib/log_agent/Agent.properties
						
						# ログへのマネージャへ転送するための設定（マネージャへ直接転送）
						echo "" >> ${HINEMOS_AGENT_HOME}/lib/log_agent/log4j.properties
						echo "### syslog host setting ###" >> ${HINEMOS_AGENT_HOME}/lib/log_agent/log4j.properties
						echo log4j.appender.syslog.SyslogHost=$IPADDR >> ${HINEMOS_AGENT_HOME}/lib/log_agent/log4j.properties
						echo "" >> ${HINEMOS_AGENT_HOME}/lib/log_agent/log4j.properties
						
						# ログ転送エージェントのログ出力先設定
						echo "" >> ${HINEMOS_AGENT_HOME}/lib/log_agent/log4j.properties
						echo "### log directory setting ###" >> ${HINEMOS_AGENT_HOME}/lib/log_agent/log4j.properties
						echo log4j.appender.file.File=${HINEMOS_AGENT_HOME}/var/log/logagent.log >> ${HINEMOS_AGENT_HOME}/lib/log_agent/log4j.properties
						echo "" >> ${HINEMOS_AGENT_HOME}/lib/log_agent/log4j.properties
						
						
						# JREのインストール
						jre_install
						
						
						# syslogのセットアップ
						syslog_setting
						
						echo ""
						echo "The Hinemos agent was installed."
						echo ""
						break
						;;
					n|N)
						echo "Installation is canceled and return to the menu."
						echo ""
						sleep 1
						break
						;;
					*)
						;;
				esac
			done
			;;
		##
		## アンインストール
		##
		2)	  
			echo "The Hinemos agent will be uninstalled. Is it all right (Y/N)?"
			read ANS
			case ${ANS} in
				y|Y)
					#プロセス終了の確認
					${PS} | grep /agent/ | grep -v grep | grep hinemos > /dev/null
					RET1=$?  

					${PS} | grep /log_agent/ | grep -v grep | grep hinemos > /dev/null 
					RET2=$?  
				
					if [ ${RET1} -eq 0 -o ${RET2} -eq 0 ]; then
						echo "Hinemos agent is running. "
						echo "Please execute uninstallation after stopping Hinemos agent."
						echo "The Hinemos agent's uninstallation is canceled."
						exit 1
					fi
					
					
					#syslogの設定きり戻し
					syslog_restore_setting
					
					
					#Hinemosエージェントファイルの削除
					if [ -d ${HINEMOS_AGENT_HOME} ] ; then
						rm -fr ${HINEMOS_AGENT_HOME}
						echo "${HINEMOS_AGENT_HOME} was deleted."
					else
						echo "${HINEMOS_AGENT_HOME} doesn't exist."
					fi
					;;
				*)
					;;
			esac
			echo ""
			;;
		##
		## 終了
		##
		9)  
			echo "Hinemos agent installer is finished."
			exit 0
			;;
		*)
			echo ""
			;;
  	esac
done
##
## インストーラ本編(終)
##
